/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.utils;

import com.dtyunxi.cube.center.source.api.constant.ClueWarehouseGroupTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.EnableEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceFindOptTypeEnum;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.center.source.api.dto.response.ClueWarehouseItemBlackListRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemResultRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceLogDetailRespDto;
import com.dtyunxi.cube.center.source.api.dto.response.SourceOrderResultRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.calculator.impl.SourceOrderGroupCalculatorImpl;
import com.dtyunxi.cube.center.source.biz.vo.ClueWarehouseGroupTypeGroupVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceExecuteContextVo;
import com.dtyunxi.cube.center.source.biz.vo.SourceGroupRuleScoreResultGroupVo;
import com.dtyunxi.cube.center.source.biz.vo.WarehouseInventoryVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.basics.CsInventoryBasicsQueryRespDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.inventory.DgLogicWarehouseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceExecuteUtils {
    private static final Logger logger = LoggerFactory.getLogger(SourceOrderGroupCalculatorImpl.class);

    private static SourceLogDetailRespDto buildAndSetSourceLogRespDto(SourceFindOptTypeEnum sourceFindOptTypeEnum, SourceExecuteContextVo sourceExecuteContextVo, String resultMsg) {
        SourceLogDetailRespDto sourceLogDetailRespDto = new SourceLogDetailRespDto();
        if (sourceExecuteContextVo.getCurrentClueActRespDto() != null) {
            sourceLogDetailRespDto.setLinkClueId(sourceExecuteContextVo.getCurrentClueActRespDto().getId());
        }
        Optional<List<SourceLogDetailRespDto>> optional = Optional.ofNullable(sourceExecuteContextVo.getSourceLogDetailRespDtoList());
        sourceLogDetailRespDto.setSgFindOptSort(Integer.valueOf(optional.map(List::size).orElse(0) + 1));
        sourceLogDetailRespDto.setSgFindOptTime(new Date());
        sourceLogDetailRespDto.setSgFindOptType(sourceFindOptTypeEnum.getCode());
        sourceLogDetailRespDto.setSgFindOptResult(resultMsg);
        return sourceLogDetailRespDto;
    }

    public static SourceOrderResultRespDto completionSourceOrderResultRespDtoByFailMsg(SourceFindOptTypeEnum sourceFindOptTypeEnum, SourceExecuteContextVo sourceExecuteContextVo, SourceOrderResultRespDto sourceOrderResultRespDto, String sgFailResultDesc) {
        sourceOrderResultRespDto.setSgStatus(SourceStatusEnum.SOURCE_FAIL.getCode());
        sourceOrderResultRespDto.setSgFailResultDesc(sgFailResultDesc);
        List sourceLogDetailRespDtoList = Optional.ofNullable(sourceExecuteContextVo.getSourceLogDetailRespDtoList()).orElse(new ArrayList());
        sourceLogDetailRespDtoList.add(SourceExecuteUtils.buildAndSetSourceLogRespDto(sourceFindOptTypeEnum, sourceExecuteContextVo, sgFailResultDesc));
        if (sourceExecuteContextVo.getSourceLogDetailRespDtoList() == null) {
            sourceExecuteContextVo.setSourceLogDetailRespDtoList(sourceLogDetailRespDtoList);
        }
        BizException sourceException = SourceExceptionCode.SOURCE_EXECUTE_FAIL_EXCEPTION.buildBizException(new String[]{sourceExecuteContextVo.getOrderDetailRespDto().getSgOrderNo() + "\u5bfb\u6e90\u5931\u8d25:" + sgFailResultDesc});
        logger.error(sourceException.getMessage(), (Throwable)sourceException);
        return sourceOrderResultRespDto;
    }

    public static void saveOrderResourceLog(SourceFindOptTypeEnum sourceFindOptTypeEnum, SourceExecuteContextVo sourceExecuteContextVo, String msg) {
        List sourceLogDetailRespDtoList = Optional.ofNullable(sourceExecuteContextVo.getSourceLogDetailRespDtoList()).orElse(new ArrayList());
        sourceLogDetailRespDtoList.add(SourceExecuteUtils.buildAndSetSourceLogRespDto(sourceFindOptTypeEnum, sourceExecuteContextVo, msg));
        if (sourceExecuteContextVo.getSourceLogDetailRespDtoList() == null) {
            sourceExecuteContextVo.setSourceLogDetailRespDtoList(sourceLogDetailRespDtoList);
        }
    }

    public static void saveOrderResourceGroupRuleScoreResultLog(SourceFindOptTypeEnum sourceFindOptTypeEnum, SourceExecuteContextVo sourceExecuteContextVo, ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo, List<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList) {
        List sourceLogDetailRespDtoList = Optional.ofNullable(sourceExecuteContextVo.getSourceLogDetailRespDtoList()).orElse(new ArrayList());
        sourceLogDetailRespDtoList.add(SourceExecuteUtils.buildAndSetSourceLogRespDto(sourceFindOptTypeEnum, sourceExecuteContextVo, SourceExecuteUtils.buildGroupRuleScoreResultListString(clueWarehouseGroupTypeGroupVo, sourceGroupRuleScoreResultGroupVoList)));
        if (sourceExecuteContextVo.getSourceLogDetailRespDtoList() == null) {
            sourceExecuteContextVo.setSourceLogDetailRespDtoList(sourceLogDetailRespDtoList);
        }
    }

    public static void saveOrderResourceLog(SourceFindOptTypeEnum sourceFindOptTypeEnum, SourceExecuteContextVo sourceExecuteContextVo, List<ClueWarehouseGroupTypeGroupVo> clueWarehouseGroupTypeGroupVos) {
        List sourceLogDetailRespDtoList = Optional.ofNullable(sourceExecuteContextVo.getSourceLogDetailRespDtoList()).orElse(new ArrayList());
        sourceLogDetailRespDtoList.add(SourceExecuteUtils.buildAndSetSourceLogRespDto(sourceFindOptTypeEnum, sourceExecuteContextVo, sourceFindOptTypeEnum.getDesc() + " " + SourceExecuteUtils.buildWarehouseGroupListString(clueWarehouseGroupTypeGroupVos)));
        if (sourceExecuteContextVo.getSourceLogDetailRespDtoList() == null) {
            sourceExecuteContextVo.setSourceLogDetailRespDtoList(sourceLogDetailRespDtoList);
        }
    }

    private static String buildWarehouseGroupListString(List<ClueWarehouseGroupTypeGroupVo> clueWarehouseGroupTypeGroupVos) {
        StringBuilder stringBuilder = new StringBuilder();
        clueWarehouseGroupTypeGroupVos.forEach(vo -> {
            stringBuilder.append("\u3010").append(vo.getClueWarehouseGroupTypeEnum().getDesc()).append("\uff0c").append(Optional.ofNullable(vo.getCsLogicWarehousePageRespDtoList()).map(List::size).orElse(0));
            if (CollectionUtils.isNotEmpty(vo.getCsLogicWarehousePageRespDtoList())) {
                stringBuilder.append("\uff0c").append(String.join((CharSequence)"\uff0c", vo.getCsLogicWarehousePageRespDtoList().stream().map(dto -> dto.getWarehouseCode() + dto.getWarehouseName()).collect(Collectors.toList()).toArray(new String[vo.getCsLogicWarehousePageRespDtoList().size()])));
            }
            stringBuilder.append("\u3011");
        });
        return stringBuilder.toString();
    }

    public static String buildGroupRuleScoreResultListString(ClueWarehouseGroupTypeGroupVo clueWarehouseGroupTypeGroupVo, List<SourceGroupRuleScoreResultGroupVo> sourceGroupRuleScoreResultGroupVoList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u3010").append(ClueWarehouseGroupTypeEnum.forCode((String)clueWarehouseGroupTypeGroupVo.getClueWarehouseGroupActRespDto().getWarehouseGroupType()).desc).append("\u3011").append("\u8ba1\u7b97\u5f97\u5206").append("\u3010").append(String.join((CharSequence)"\uff1b", sourceGroupRuleScoreResultGroupVoList.stream().map(vo -> vo.getCsLogicWarehousePageRespDto().getWarehouseCode() + vo.getCsLogicWarehousePageRespDto().getWarehouseName() + "\uff0c" + vo.getWarehouseResultScore()).collect(Collectors.toList()).toArray(new String[sourceGroupRuleScoreResultGroupVoList.size()]))).append("\u3011");
        return stringBuilder.toString();
    }

    public static List<String> buildWarehouseItemMatchListString(List<OrderItemResultRespDto> resultRespDtoList) {
        if (CollectionUtils.isEmpty(resultRespDtoList)) {
            return null;
        }
        HashMap resultStringMap = new HashMap();
        Map<Long, List<OrderItemResultRespDto>> listMap = resultRespDtoList.stream().collect(Collectors.groupingBy(OrderItemResultRespDto::getDeliveryLogicWarehouseId));
        listMap.forEach((k, v) -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\u3010").append(((OrderItemResultRespDto)v.get(0)).getDeliveryLogicWarehouseCode() + ((OrderItemResultRespDto)v.get(0)).getDeliveryLogicWarehouseName()).append("\u3011").append("\u5339\u914d").append("\u5546\u54c1");
            Map<String, Map> itemMap = v.stream().collect(Collectors.toMap(OrderItemResultRespDto::getLinkItemSkuCode, v1 -> {
                HashMap<String, Object> dtoMap = new HashMap<String, Object>();
                dtoMap.put("skuCode", v1.getLinkItemSkuCode());
                dtoMap.put("deliveryItemNum", v1.getDeliveryItemNum());
                dtoMap.put("ztWarehouseItemNum", v1.getZtDeliveryWarehouseItemNum());
                return dtoMap;
            }, (v1, v2) -> {
                v1.put("deliveryItemNum", ((BigDecimal)v1.get("deliveryItemNum")).add((BigDecimal)v2.get("deliveryItemNum")));
                v1.put("ztWarehouseItemNum", ((BigDecimal)v1.get("ztWarehouseItemNum")).add((BigDecimal)v2.get("ztWarehouseItemNum")));
                return v1;
            }));
            itemMap.forEach((ik, iv) -> stringBuilder.append("\u3010").append(iv.get("skuCode")).append("\uff0c").append(((BigDecimal)iv.get("deliveryItemNum")).intValue()).append("\uff0c").append("\u53ef\u5bfb\u6e90\u5728\u9014").append(((BigDecimal)iv.get("ztWarehouseItemNum")).intValue()).append("\u3011"));
            resultStringMap.put(k, stringBuilder.toString());
        });
        ArrayList<String> resultStringList = new ArrayList<String>();
        List<Long> sortList = resultRespDtoList.stream().map(OrderItemResultRespDto::getDeliveryLogicWarehouseId).distinct().collect(Collectors.toList());
        sortList.forEach(id -> resultStringList.add((String)resultStringMap.get(id)));
        return resultStringList;
    }

    public static String buildWarehouseItemBatchMatchListString(List<OrderItemResultRespDto> resultRespDtoList) {
        if (CollectionUtils.isEmpty(resultRespDtoList)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u5206\u7ec4\u5339\u914d\u5546\u54c1\u6279\u6b21\u660e\u7ec6 ");
        for (OrderItemResultRespDto orderItemRespDto : resultRespDtoList) {
            stringBuilder.append("\n").append("\u3010").append(orderItemRespDto.getLinkItemSkuCode()).append("\uff0c").append(orderItemRespDto.getDeliveryItemBatchNo()).append("\uff0c").append(orderItemRespDto.getDeliveryItemNum().intValue()).append("\uff0c").append("\u53ef\u5bfb\u6e90\u5728\u9014").append(orderItemRespDto.getZtDeliveryWarehouseItemNum().intValue()).append("\uff0c").append(orderItemRespDto.getDeliveryLogicWarehouseName()).append("\u3011");
        }
        return stringBuilder.toString();
    }

    public static String buildWarehouseAccessListString(List<DgLogicWarehouseDto> csLogicWarehousePageRespDtoList) {
        StringBuilder stringBuilder = new StringBuilder();
        csLogicWarehousePageRespDtoList.forEach(vo -> stringBuilder.append("\u3010").append(vo.getWarehouseCode()).append("\uff1b").append(vo.getWarehouseName()).append("\u3011"));
        return stringBuilder.toString();
    }

    public static String buildWarehouseAccessListStringByResultItemList(List<OrderItemResultRespDto> resultRespDtoList) {
        Map<Long, OrderItemResultRespDto> groupMap = resultRespDtoList.stream().collect(Collectors.toMap(OrderItemResultRespDto::getDeliveryLogicWarehouseId, v1 -> v1, (v1, v2) -> v1));
        Map<Long, BigDecimal> itemNumMap = resultRespDtoList.stream().collect(Collectors.toMap(OrderItemResultRespDto::getDeliveryLogicWarehouseId, OrderItemResultRespDto::getDeliveryItemNum, (v1, v2) -> v1.add((BigDecimal)v2)));
        Map<Long, BigDecimal> itemZtNumMap = resultRespDtoList.stream().collect(Collectors.toMap(OrderItemResultRespDto::getDeliveryLogicWarehouseId, OrderItemResultRespDto::getZtDeliveryWarehouseItemNum, (v1, v2) -> v1.add((BigDecimal)v2)));
        StringBuilder stringBuilder = new StringBuilder();
        groupMap.forEach((k, v) -> stringBuilder.append("\u3010").append(v.getDeliveryLogicWarehouseCode()).append("\uff1b").append(v.getDeliveryLogicWarehouseName()).append("\uff0c").append(((BigDecimal)itemNumMap.get(k)).intValue()).append("\uff0c").append("\u53ef\u5bfb\u6e90\u5728\u9014").append(((BigDecimal)itemZtNumMap.get(k)).intValue()).append("\u3011"));
        return stringBuilder.toString();
    }

    public static BigDecimal distance(BigDecimal centerLon, BigDecimal centerLat, BigDecimal targetLon, BigDecimal targetLat) {
        BigDecimal jl_jd = new BigDecimal("102834.74258026089786013677476285");
        BigDecimal jl_wd = new BigDecimal("111712.69150641055729984301412873");
        BigDecimal b = centerLat.subtract(targetLat).abs().multiply(jl_jd);
        BigDecimal a = centerLon.subtract(targetLon).abs().multiply(jl_wd);
        return new BigDecimal(Math.sqrt(a.multiply(a).add(b.multiply(b)).doubleValue()));
    }

    public static String buildWarehouseItemMatchErrorListString(List<OrderItemRespDto> resultRespDtoList, List<OrderItemResultRespDto> resultRespList, SourceExecuteContextVo sourceExecuteContextVo) {
        if (CollectionUtils.isEmpty(resultRespDtoList)) {
            return null;
        }
        List<Object> blackItemCodeList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sourceExecuteContextVo.getHitClueItemBlacklist())) {
            blackItemCodeList = sourceExecuteContextVo.getHitClueItemBlacklist().stream().map(ClueWarehouseItemBlackListRespDto::getSkuCode).collect(Collectors.toList());
        }
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<OrderItemRespDto>> itemInfoGroupMap = resultRespDtoList.stream().collect(Collectors.groupingBy(OrderItemRespDto::getItemSkuCode));
        for (String skuCode : itemInfoGroupMap.keySet()) {
            List<OrderItemRespDto> orderItemRespDtos = itemInfoGroupMap.get(skuCode);
            BigDecimal origItemNum = orderItemRespDtos.stream().map(OrderItemRespDto::getOrigItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal itemNum = orderItemRespDtos.stream().map(OrderItemRespDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal availableNum = BigDecimal.ZERO;
            if (Objects.nonNull(sourceExecuteContextVo.getLogicWarehouseStockMap())) {
                availableNum = ((List)sourceExecuteContextVo.getLogicWarehouseStockMap().getOrDefault(skuCode, new ArrayList())).stream().map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal ztWarehouseItemNum = BigDecimal.ZERO;
            if (Objects.nonNull(sourceExecuteContextVo.getZtWarehouseStockMap())) {
                ztWarehouseItemNum = ((List)sourceExecuteContextVo.getZtWarehouseStockMap().getOrDefault(skuCode, new ArrayList())).stream().map(WarehouseInventoryVo::getZtSurplusStock).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            stringBuilder.append("\n");
            stringBuilder.append("\u3010").append("\u5546\u54c1\u957f\u7f16\u7801").append(skuCode);
            if (EnableEnum.ENABLE.getCode().equals(sourceExecuteContextVo.getCurrentClueActRespDto().getSingleWarehouseDelivery())) {
                stringBuilder.append("\u65e0\u6cd5\u5355\u4ed3\u6ee1\u8db3\u5e93\u5b58");
            }
            stringBuilder.append("\uff0c").append("\u8ba2\u5355\u660e\u7ec6\u6240\u9700").append(origItemNum.intValue());
            if (EnableEnum.DISABLE.getCode().equals(sourceExecuteContextVo.getCurrentClueActRespDto().getSingleWarehouseDelivery())) {
                stringBuilder.append("\uff0c").append("\u53ef\u5bfb\u6e90").append(availableNum.intValue());
                stringBuilder.append("\uff0c").append("\u53ef\u5bfb\u6e90\u5728\u9014").append(ztWarehouseItemNum.intValue());
                stringBuilder.append("\uff0c").append("\u7f3a\u8d27").append(itemNum.intValue());
            }
            if (EnableEnum.ENABLE.getCode().equals(sourceExecuteContextVo.getCurrentClueActRespDto().getSingleWarehouseDelivery())) {
                sourceExecuteContextVo.getCurrentWarehouseGroupTotalInventoryDtoMap().forEach((k, v) -> {
                    WarehouseInventoryVo warehouseInventoryVo = (WarehouseInventoryVo)((Object)((Object)v.get(skuCode)));
                    if (Objects.nonNull((Object)warehouseInventoryVo)) {
                        BigDecimal surplusStock = BigDecimal.ZERO;
                        if (Objects.nonNull(sourceExecuteContextVo.getLogicWarehouseStockMap())) {
                            surplusStock = ((List)sourceExecuteContextVo.getLogicWarehouseStockMap().getOrDefault(skuCode, new ArrayList())).stream().filter(dto -> Objects.equals(dto.getWarehouseCode(), warehouseInventoryVo.getWarehouseCode())).map(CsInventoryBasicsQueryRespDto::getAvailable).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        BigDecimal ztSaleable = BigDecimal.ZERO;
                        if (Objects.nonNull(sourceExecuteContextVo.getZtWarehouseStockMap())) {
                            ztSaleable = ((List)sourceExecuteContextVo.getZtWarehouseStockMap().getOrDefault(skuCode, new ArrayList())).stream().filter(dto -> Objects.equals(dto.getWarehouseCode(), warehouseInventoryVo.getWarehouseCode())).map(WarehouseInventoryVo::getZtSurplusStock).reduce(BigDecimal.ZERO, BigDecimal::add);
                        }
                        stringBuilder.append("\uff1b");
                        stringBuilder.append(warehouseInventoryVo.getWarehouseName());
                        stringBuilder.append("[" + warehouseInventoryVo.getWarehouseCode() + "]");
                        stringBuilder.append("\u53ef\u5bfb\u6e90");
                        stringBuilder.append(surplusStock.intValue());
                        stringBuilder.append("\uff0c").append("\u53ef\u5bfb\u6e90\u5728\u9014").append(ztSaleable.intValue());
                    }
                });
            }
            if (blackItemCodeList.contains(skuCode)) {
                stringBuilder.append("\uff0c").append("\u539f\u56e0").append("\uff1a").append("\u5546\u54c1\u9ed1\u540d\u5355");
            } else if (itemNum.compareTo(BigDecimal.ZERO) > 0) {
                stringBuilder.append("\uff0c").append("\u539f\u56e0").append("\uff1a").append("\u5e93\u5b58\u4e0d\u8db3");
            }
            stringBuilder.append("\u3011");
        }
        return stringBuilder.toString();
    }

    public static String buildSourceItemBlackByResultItemList(SourceExecuteContextVo sourceExecuteContextVo) {
        if (CollectionUtils.isEmpty(sourceExecuteContextVo.getHitClueItemBlacklist())) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u547d\u4e2d\u5546\u54c1\u9ed1\u540d\u5355\u660e\u7ec6 ");
        for (ClueWarehouseItemBlackListRespDto itemBlackListRespDto : sourceExecuteContextVo.getHitClueItemBlacklist()) {
            stringBuilder.append("\n").append("\u3010").append(itemBlackListRespDto.getItemName()).append("\uff0c").append(itemBlackListRespDto.getSkuCode());
            if (StringUtils.isNotEmpty((CharSequence)itemBlackListRespDto.getBatchNo())) {
                stringBuilder.append("\uff0c").append(itemBlackListRespDto.getBatchNo());
            }
            stringBuilder.append("\u3011");
        }
        return stringBuilder.toString();
    }
}

