/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.center.source.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.dto.request.OrderItemReqDto;
import com.dtyunxi.cube.center.source.api.dto.response.OrderItemRespDto;
import com.dtyunxi.cube.center.source.api.exception.SourceAssert;
import com.dtyunxi.cube.center.source.api.exception.SourceExceptionCode;
import com.dtyunxi.cube.center.source.biz.service.IOrderItemService;
import com.dtyunxi.cube.center.source.dao.das.OrderItemDas;
import com.dtyunxi.cube.center.source.dao.eo.OrderItemEo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderItemServiceImpl
implements IOrderItemService {
    @Resource
    private OrderItemDas orderItemDas;

    @Override
    public Long addOrderItem(OrderItemReqDto addReqDto) {
        OrderItemEo orderItemEo = new OrderItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderItemEo);
        this.orderItemDas.insert((BaseEo)orderItemEo);
        return orderItemEo.getId();
    }

    @Override
    public int batchAddOrderItem(List<OrderItemReqDto> addReqDtoList) {
        ArrayList orderItemEoList = new ArrayList();
        CubeBeanUtils.copyCollection(orderItemEoList, addReqDtoList, OrderItemEo.class);
        return this.orderItemDas.insertBatch(orderItemEoList);
    }

    @Override
    public void modifyOrderItem(OrderItemReqDto modifyReqDto) {
        OrderItemEo orderItemEo = new OrderItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderItemEo);
        this.orderItemDas.updateSelective((BaseEo)orderItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderItemRespDto queryById(Long id) {
        OrderItemEo orderItemEo = (OrderItemEo)this.orderItemDas.selectByPrimaryKey(id);
        if (orderItemEo == null) {
            return null;
        }
        OrderItemRespDto orderItemRespDto = new OrderItemRespDto();
        DtoHelper.eo2Dto((BaseEo)orderItemEo, (BaseVo)orderItemRespDto);
        return orderItemRespDto;
    }

    @Override
    public List<OrderItemRespDto> queryByOrderId(Long orderId) {
        SourceAssert.notNull((Object)orderId, (SourceExceptionCode)SourceExceptionCode.CHECK_PARAM_CAN_NOT_NULL, (String[])new String[]{"\u5bfb\u6e90\u5355id"});
        OrderItemEo queryEo = new OrderItemEo();
        queryEo.setSgOrderId(orderId);
        List orderItemEoList = this.orderItemDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)orderItemEoList)) {
            ArrayList<OrderItemRespDto> orderItemRespDtoList = new ArrayList<OrderItemRespDto>();
            CubeBeanUtils.copyCollection(orderItemRespDtoList, (Collection)orderItemEoList, OrderItemRespDto.class);
            return orderItemRespDtoList;
        }
        return null;
    }

    @Override
    public PageInfo<OrderItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderItemReqDto orderItemReqDto = (OrderItemReqDto)JSON.parseObject((String)filter, OrderItemReqDto.class);
        OrderItemEo orderItemEo = new OrderItemEo();
        DtoHelper.dto2Eo((BaseVo)orderItemReqDto, (BaseEo)orderItemEo);
        PageInfo eoPageInfo = this.orderItemDas.selectPage((BaseEo)orderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

