package com.dtyunxi.finance.api.dto.response;

import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;

import com.dtyunxi.dto.BaseRespDto;

import javax.persistence.Column;

/**
* 仓储费合同表Eo对象
*
* @author xuanxin
* @since 2022-07-18
*/
@ApiModel(value = "StorageContractRespDto", description = "仓储费合同表Eo对象")
public class StorageContractRespDto extends BaseRespDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
    *  合同名称
    */
    @ApiModelProperty(name = "contractName", value = "合同名称")
    private String contractName;

    @ApiModelProperty(name = "chargeMode", value = "计算方式 1按半数；2按面积；3按金额")
    private Integer chargeMode;

    /**
    *  是否作废;0:未作废;1:作废;
    */
    @ApiModelProperty(name = "isCancel", value = "是否作废;0:未作废;1:作废;")
    private Integer isCancel;
    /**
    *  物理仓编码
    */
    @ApiModelProperty(name = "warehouseCode", value = "物理仓编码")
    private String warehouseCode;
    /**
    *  物理仓名称
    */
    @ApiModelProperty(name = "warehouseName", value = "物理仓名称")
    private String warehouseName;
    /**
    *  合同每月日均板数
    */
    @ApiModelProperty(name = "contractAverageSupport", value = "合同每月日均板数")
    private Integer contractAverageSupport;
    /**
     * 合同合作开始日期
     */
    @ApiModelProperty(name = "contractCooperativeStartTime", value = "合同合作开始日期")
    private Date contractCooperativeStartTime;
    /**
     * 合同合作结束日期
     */
    @ApiModelProperty(name = "contractCooperativeEndTime", value = "合同合作结束日期")
    private Date contractCooperativeEndTime;
    /**
    *  有效开始时间
    */
    @ApiModelProperty(name = "validStartTime", value = "有效开始时间")
    private Date validStartTime;
    /**
    *  有效结束时间
    */
    @ApiModelProperty(name = "validEndTime", value = "有效结束时间")
    private Date validEndTime;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "orgId", value = "组织id")
    private Long orgId;

    /**
     * 仓储费详情列表
     */
    @ApiModelProperty(name = "storageContractDetailRespDtoList" ,value = "仓储费详情列表")
    private List<StorageContractDetailRespDto> storageContractDetailRespDtoList;

    /**
     *  状态
     */
    @ApiModelProperty(name = "status" ,value = "状态")
    private Integer status;

    public Date getContractCooperativeStartTime() {
        return contractCooperativeStartTime;
    }

    public void setContractCooperativeStartTime(Date contractCooperativeStartTime) {
        this.contractCooperativeStartTime = contractCooperativeStartTime;
    }

    public Date getContractCooperativeEndTime() {
        return contractCooperativeEndTime;
    }

    public void setContractCooperativeEndTime(Date contractCooperativeEndTime) {
        this.contractCooperativeEndTime = contractCooperativeEndTime;
    }

    public Integer getChargeMode() {
        return chargeMode;
    }

    public void setChargeMode(Integer chargeMode) {
        this.chargeMode = chargeMode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<StorageContractDetailRespDto> getStorageContractDetailRespDtoList() {
        return storageContractDetailRespDtoList;
    }

    public void setStorageContractDetailRespDtoList(List<StorageContractDetailRespDto> storageContractDetailRespDtoList) {
        this.storageContractDetailRespDtoList = storageContractDetailRespDtoList;
    }

    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setContractName(String contractName){
    this.contractName = contractName;
    }
    public String getContractName(){
    return this.contractName;
    }
    public void setIsCancel(Integer isCancel){
    this.isCancel = isCancel;
    }
    public Integer getIsCancel(){
    return this.isCancel;
    }
    public void setWarehouseCode(String warehouseCode){
    this.warehouseCode = warehouseCode;
    }
    public String getWarehouseCode(){
    return this.warehouseCode;
    }
    public void setWarehouseName(String warehouseName){
    this.warehouseName = warehouseName;
    }
    public String getWarehouseName(){
    return this.warehouseName;
    }
    public void setContractAverageSupport(Integer contractAverageSupport){
    this.contractAverageSupport = contractAverageSupport;
    }
    public Integer getContractAverageSupport(){
    return this.contractAverageSupport;
    }
    public void setValidStartTime(Date validStartTime){
    this.validStartTime = validStartTime;
    }
    public Date getValidStartTime(){
    return this.validStartTime;
    }
    public void setValidEndTime(Date validEndTime){
    this.validEndTime = validEndTime;
    }
    public Date getValidEndTime(){
    return this.validEndTime;
    }
    public void setOrgId(Long orgId){
    this.orgId = orgId;
    }
    public Long getOrgId(){
    return this.orgId;
    }
}
