package com.dtyunxi.finance.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.ApportionmentOrderBizTypeReqDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrderBizTypeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 分摊基础单据业务类型关系表服务接口
*
* @author jiaye
* @since 2025-08-20
*/
@Api(tags = {"分摊基础单据业务类型关系表服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-IApportionmentOrderBizTypeApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/apportionment/orderBizType",
    url = "${com.dtyunxi.finance.api:}"
)
public interface IApportionmentOrderBizTypeApi {

/**
* 新增分摊基础单据业务类型关系表
*
* @param addReqDto 分摊基础单据业务类型关系表请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增分摊基础单据业务类型关系表", notes = "新增分摊基础单据业务类型关系表")
RestResponse<Long> addApportionmentOrderBizType(@RequestBody ApportionmentOrderBizTypeReqDto addReqDto);

    /**
    * 修改分摊基础单据业务类型关系表
    *
    * @param modifyReqDto 分摊基础单据业务类型关系表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改分摊基础单据业务类型关系表", notes = "修改分摊基础单据业务类型关系表")
    RestResponse<Void> modifyApportionmentOrderBizType(@RequestBody ApportionmentOrderBizTypeReqDto modifyReqDto);

    /**
    * 删除分摊基础单据业务类型关系表
    *
    * @param ids        分摊基础单据业务类型关系表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除分摊基础单据业务类型关系表", notes = "删除分摊基础单据业务类型关系表")
    RestResponse<Void> removeApportionmentOrderBizType(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
