package com.dtyunxi.finance.api.dto.response.logistic;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "LogisticRecordQueryRespDto", description = "物流设置记录表Dto")
public class LogisticRecordQueryRespDto extends BaseVo {

    @ApiModelProperty(name = "lastTime",value = "ID")
    private Long id;// '主键',

    @ApiModelProperty(name = "contractName",value = "合同名称")
    private String contractName;// '合同名称',

    @ApiModelProperty(name = "warehouseId",value = "仓库ID")
    private String warehouseId;

    @ApiModelProperty(name = "warehouseName",value = "仓库")
    private String warehouseName;// '仓库',

    @ApiModelProperty(name = "logisticId",value = "物流公司ID")
    private String logisticId;

    @ApiModelProperty(name = "logisticCompany",value = "物流公司")
    private String logisticCompany;// '物流公司',

    @ApiModelProperty(name = "transportType",value = "承运方式")
    private String transportType;// '承运方式',

    @ApiModelProperty(name = "chargeMode",value = "计算方式")
    private Integer chargeMode;// '计算方式',

    @ApiModelProperty(name = "params",value = "计算方式json参数")
    private String params;// '计算方式json参数',

    @ApiModelProperty(name = "bizParams",value = "计算方式json参数")
    private List<Map<String, Object>> bizParams;

    @ApiModelProperty(name = "startTime",value = "有效开始时间")
    private Date startTime;//  '有效开始时间',

    @ApiModelProperty(name = "endTime",value = "有效结束时间")
    private Date endTime;// '有效结束时间',

    @ApiModelProperty(name = "deliveryPrice",value = "送货费用")
    private BigDecimal deliveryPrice;//  '送货费用',

    @ApiModelProperty(name = "unloadPrice",value = "卸货费单价")
    private BigDecimal unloadPrice;//  '卸货费单价',

    @ApiModelProperty(name = "contractOilPrice",value = "合同基准油价")
    private BigDecimal contractOilPrice;// '合同基准油价',

    @ApiModelProperty(name = "address",value = "发改委地址")
    private String address;// 发改委地址',

    @ApiModelProperty(name = "remark",value = "备注")
    private String remark;// 备注',

    @ApiModelProperty(name = "seasonType", value = "季节类型")
    private Integer seasonType;//季节类型

    @ApiModelProperty(name = "offSeason", value = "淡季")
    private String offSeason;//淡季

    @ApiModelProperty(name = "peakSeason", value = "旺季")
    private String peakSeason;//旺季

    @ApiModelProperty(name = "extension",value = "扩展字段")
    private String extension;// '扩展字段',

    @ApiModelProperty(name = "createPerson",value = "创建人")
    private String createPerson;// 创建人',

    @ApiModelProperty(name = "createTime",value = "创建时间")
    private Date createTime;// 创建时间',

    @ApiModelProperty(name = "updatePerson",value = "修改人")
    private String updatePerson;// 修改人',

    @ApiModelProperty(name = "updateTime",value = "修改时间")
    private Date updateTime;// 修改时间',

    @ApiModelProperty(name = "status",value = "状态")
    private Integer status;//0默认，1作废
}
