package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.ApportionmentOrderBizTypeReqDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrderBizTypeRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 分摊基础单据业务类型关系表服务接口
*
* @author jiaye
* @since 2025-08-20
*/
@Api(tags = {"分摊基础单据业务类型关系表服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-query-IApportionmentOrderBizTypeQueryApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/apportionment/orderBizType",
    url = "${com.dtyunxi.finance.api:}"
)
public interface IApportionmentOrderBizTypeQueryApi {

    /**
    * 根据id查询分摊基础单据业务类型关系表
    *
    * @param id 分摊基础单据业务类型关系表id
    * @return   分摊基础单据业务类型关系表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询分摊基础单据业务类型关系表", notes = "根据id查询分摊基础单据业务类型关系表")
    RestResponse<ApportionmentOrderBizTypeRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 分摊基础单据业务类型关系表分页数据
    *
    * @param filter   分摊基础单据业务类型关系表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 分摊基础单据业务类型关系表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "分摊基础单据业务类型关系表分页数据", notes = "根据filter查询条件查询分摊基础单据业务类型关系表数据，filter=ApportionmentOrderBizTypeReqDto")
    RestResponse<PageInfo<ApportionmentOrderBizTypeRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
