package com.dtyunxi.finance.api.exception.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
public enum SortingContractStatusEnum {
    DEFAULT(0, "默认"),
    WAIT_EFFECT(1, "待生效"),
    EFFECT(2, "生效"),
    LOSE_EFFECT(3, "已失效"),
    TO_VOID(4, "已作废"),
    /**
     * 仅查询
     */
    OTHER_STATUS(5, "生效中、已失效"),
    ;

    private Integer code;
    private String message;

    SortingContractStatusEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

}
