package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.response.ExpressCostAreaRespDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 快递费合同区域服务接口
*
* @author 天泽
* @since 2022-11-10
*/
@Api(tags = {"快递费合同区域服务"})
@FeignClient(
    contextId = "com-dtyunxi-tcbj-api-query-IExpressCostAreaQueryApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/express/cost/area",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IExpressCostAreaQueryApi {

    /**
    * 根据id查询快递费合同区域
    *
    * @param id 快递费合同区域id
    * @return   快递费合同区域数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询快递费合同区域", notes = "根据id查询快递费合同区域")
    RestResponse<ExpressCostAreaRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 快递费合同区域分页数据
    *
    * @param filter   快递费合同区域查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 快递费合同区域分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "快递费合同区域分页数据", notes = "根据filter查询条件查询快递费合同区域数据，filter=ExpressCostAreaReqDto")
    RestResponse<PageInfo<ExpressCostAreaRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                               @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                               @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
