package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.LogisticsSetttingsReqDto;
import com.dtyunxi.finance.api.dto.response.LogisticsSetttingsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 物流公司关联设置服务接口
*
* @author longde
* @since 2022-07-15
*/
@Api(tags = {"物流公司关联设置服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-query-ILogisticsSetttingsQueryApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/logistics/settings",
    url = "${com.dtyunxi.finance.api:}"
)
public interface ILogisticsSettingsQueryApi {

    /**
    * 根据id查询物流公司关联设置
    *
    * @param id 物流公司关联设置id
    * @return   物流公司关联设置数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询物流公司关联设置", notes = "根据id查询物流公司关联设置")
    RestResponse<LogisticsSetttingsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 物流公司关联设置分页数据
    *
    * @param filter   物流公司关联设置查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 物流公司关联设置分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "物流公司关联设置分页数据", notes = "根据filter查询条件查询物流公司关联设置数据，filter=LogisticsSetttingsReqDto")
    RestResponse<PageInfo<LogisticsSetttingsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


//    @GetMapping("/distinct")
//    @ApiOperation(value = "distinct查询承运方式", notes = "distinct查询承运方式")
//    RestResponse<PageInfo<LogisticsSetttingsRespDto>> queryDistinct();

}
