package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.StorageContractDetailReqDto;
import com.dtyunxi.finance.api.dto.response.StorageContractDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 仓储费用关联明细表服务接口
*
* @author xuanxin
* @since 2022-07-18
*/
@Api(tags = {"仓储费用关联明细表服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-query-IStorageContractDetailQueryApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/storageContractDetail",
    url = "${com.dtyunxi.finance.api:}"
)
public interface IStorageContractDetailQueryApi {

    /**
    * 根据id查询仓储费用关联明细表
    *
    * @param id 仓储费用关联明细表id
    * @return   仓储费用关联明细表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询仓储费用关联明细表", notes = "根据id查询仓储费用关联明细表")
    RestResponse<StorageContractDetailRespDto> queryById(@PathVariable("id") Long id);


    /**
     * 根据id查询所有关联此id的仓储费合同详情表
     *
     * @param contractId 仓储费合同表id
     * @return   仓储费合同详情表列表数据
     */
    @GetMapping("/contractId")
    @ApiOperation(value = "根据id查询所有关联此id的仓储费合同详情表", notes = "根据id查询所有关联此id的仓储费合同详情表")
    RestResponse<List<StorageContractDetailRespDto>> queryListByContractId(@RequestParam("contractId") Long contractId);

    /**
    * 仓储费用关联明细表分页数据
    *
    * @param filter   仓储费用关联明细表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 仓储费用关联明细表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "仓储费用关联明细表分页数据", notes = "根据filter查询条件查询仓储费用关联明细表数据，filter=StorageContractDetailReqDto")
    RestResponse<PageInfo<StorageContractDetailRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
