/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.logistic.AppointAreaReqDto;
import com.dtyunxi.finance.api.dto.request.logistic.VolumeLadderDto;
import com.dtyunxi.finance.biz.service.IAppointAreaService;
import com.dtyunxi.finance.dao.das.AppointAreaDas;
import com.dtyunxi.finance.dao.das.LogisticRecordDas;
import com.dtyunxi.finance.dao.eo.AppointAreaEo;
import com.dtyunxi.finance.dao.eo.LogisticRecordEo;
import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppointAreaServiceImpl
implements IAppointAreaService {
    @Resource
    private AppointAreaDas appointAreaDas;
    @Resource
    private LogisticRecordDas logisticRecordDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchCreate(List<AppointAreaReqDto> reqDto) {
        if (CollectionUtil.isEmpty(reqDto)) {
            return;
        }
        String templateId = reqDto.get(0).getTemplateId();
        List eos = ((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)templateId)).list(Integer.valueOf(2000));
        Map<Object, Object> eoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)eos)) {
            eoMap = eos.stream().collect(Collectors.toMap(AppointAreaEo::getUniqueKey, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<AppointAreaEo> insertEos = new ArrayList<AppointAreaEo>();
        ArrayList<AppointAreaEo> updateEos = new ArrayList<AppointAreaEo>();
        if (CollectionUtils.isNotEmpty(reqDto)) {
            for (AppointAreaReqDto areaReqDto : reqDto) {
                AppointAreaEo appointAreaEo = new AppointAreaEo();
                BeanUtils.copyProperties((Object)areaReqDto, (Object)appointAreaEo);
                appointAreaEo.setTemplateId(Long.valueOf(areaReqDto.getTemplateId()));
                String uniqueKey = appointAreaEo.getUniqueKey();
                if (CollectionUtil.isNotEmpty((Map)eoMap) && eoMap.containsKey(uniqueKey)) {
                    appointAreaEo.setId(((AppointAreaEo)eoMap.get(uniqueKey)).getId());
                    updateEos.add(appointAreaEo);
                    continue;
                }
                insertEos.add(appointAreaEo);
            }
        }
        if (CollectionUtils.isNotEmpty(insertEos)) {
            this.appointAreaDas.insertBatch(insertEos);
        }
        if (CollectionUtils.isNotEmpty(updateEos)) {
            updateEos.stream().forEach(i -> this.appointAreaDas.updateSelective((BaseEo)i));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long removeAppointArea(Long id) {
        AppointAreaEo areaEo = (AppointAreaEo)this.appointAreaDas.selectByPrimaryKey(id);
        if (null != areaEo && null != areaEo.getId()) {
            areaEo.setDr(1);
            this.appointAreaDas.deleteData(areaEo);
        }
        return areaEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAllAppointArea(String templateId) {
        AppointAreaEo queryEo = new AppointAreaEo();
        queryEo.setTemplateId(Long.valueOf(templateId));
        List areaEos = this.appointAreaDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)areaEos)) {
            for (AppointAreaEo appointAreaEo : areaEos) {
                appointAreaEo.setDr(1);
                this.appointAreaDas.deleteData(appointAreaEo);
            }
        }
    }

    @Override
    public Long updateAppointAreaById(AppointAreaReqDto reqDto) {
        AppointAreaEo areaEo = (AppointAreaEo)this.appointAreaDas.selectByPrimaryKey(reqDto.getId());
        if (null != areaEo) {
            areaEo.setParams(reqDto.getParams());
            areaEo.setDay(reqDto.getDay());
            areaEo.setArea(reqDto.getArea());
            areaEo.setCity(reqDto.getCity());
            areaEo.setProvince(reqDto.getProvince());
            areaEo.setType(reqDto.getType());
            if (StringUtils.isNotBlank((CharSequence)reqDto.getTemplateId())) {
                areaEo.setTemplateId(Long.valueOf(reqDto.getTemplateId()));
            }
            areaEo.setChargeType(reqDto.getChargeType());
            this.appointAreaDas.update((BaseEo)areaEo);
        }
        return areaEo.getId();
    }

    @Override
    public void volumeLadderSave(VolumeLadderDto volumeLadderDto) {
        if (volumeLadderDto == null || volumeLadderDto.getAppointAreaId() == null || volumeLadderDto.getAppointAreaId() < 1L || CollectionUtil.isEmpty((Collection)volumeLadderDto.getDetails())) {
            throw new BizException("\u5408\u540c\u533a\u57dfID\u548c\u9636\u68af\u503cdetails\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AppointAreaEo areaEo = (AppointAreaEo)this.appointAreaDas.selectByPrimaryKey(volumeLadderDto.getAppointAreaId());
        if (areaEo == null) {
            throw new BizException("\u5408\u540c\u533a\u57dfID\u4e0d\u6b63\u786e");
        }
        areaEo.setVolumeLadder(JSON.toJSONString((Object)volumeLadderDto.getDetails()));
        this.appointAreaDas.updateSelective((BaseEo)areaEo);
    }

    @Override
    public Long addAppointArea(AppointAreaReqDto reqDto) {
        this.addCheckParams(reqDto);
        AppointAreaEo eo = new AppointAreaEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)eo);
        eo.setTemplateId(Long.valueOf(reqDto.getTemplateId()));
        this.appointAreaDas.insert((BaseEo)eo);
        return eo.getId();
    }

    private void addCheckParams(AppointAreaReqDto reqDto) {
        if (reqDto.getTemplateId() == null) {
            throw new BizException("\u5408\u540cId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getProvince())) {
            throw new BizException("\u5408\u540c\u533a\u57df\u65b0\u589e\u7701\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LogisticRecordEo one = (LogisticRecordEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logisticRecordDas.filter().eq((Object)"id", (Object)reqDto.getTemplateId())).last("limit 1")).one();
        if (one == null) {
            throw new BizException("\u5408\u540cId\u4e0d\u6b63\u786e");
        }
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)this.appointAreaDas.filter().eq((Object)"template_id", (Object)reqDto.getTemplateId())).eq((Object)"province", (Object)reqDto.getProvince());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCity())) {
            filter.eq((Object)"city", (Object)reqDto.getCity());
        } else {
            filter.isNull((Object)"city");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getArea())) {
            filter.eq((Object)"area", (Object)reqDto.getArea());
        } else {
            filter.isNull((Object)"area");
        }
        Integer count = filter.count();
        if (count != null && count > 0) {
            throw new BizException("\u5408\u540c\u5bf9\u5e94\u7684\u533a\u57df\u4fe1\u606f\u5df2\u5b58\u5728");
        }
    }
}

