/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.ApportionmentOrganizationReqDto;
import com.dtyunxi.finance.api.dto.response.ApportionmentOrganizationRespDto;
import com.dtyunxi.finance.biz.service.IApportionmentOrganizationService;
import com.dtyunxi.finance.dao.das.ApportionmentOrganizationDas;
import com.dtyunxi.finance.dao.eo.ApportionmentOrganizationEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApportionmentOrganizationServiceImpl
implements IApportionmentOrganizationService {
    @Resource
    private ApportionmentOrganizationDas apportionmentOrganizationDas;

    @Override
    public void batchCreate(String ruleCode, Long ruleId, List<ApportionmentOrganizationReqDto> reqDtoList) {
        ApportionmentOrganizationEo delEo = new ApportionmentOrganizationEo();
        delEo.setRuleCode(ruleCode);
        this.apportionmentOrganizationDas.delete((BaseEo)delEo);
        ArrayList<ApportionmentOrganizationEo> eos = new ArrayList<ApportionmentOrganizationEo>();
        for (ApportionmentOrganizationReqDto dto : reqDtoList) {
            dto.setRuleCode(ruleCode);
            dto.setRuleId(ruleId);
            ApportionmentOrganizationEo eo = new ApportionmentOrganizationEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
            eos.add(eo);
        }
        this.apportionmentOrganizationDas.insertBatch(eos);
    }

    @Override
    public List<ApportionmentOrganizationRespDto> getByRuleCode(String ruleCode) {
        List eos = ((ExtQueryChainWrapper)this.apportionmentOrganizationDas.filter().eq((Object)"rule_code", (Object)ruleCode)).list();
        ArrayList<ApportionmentOrganizationRespDto> dtoList = new ArrayList<ApportionmentOrganizationRespDto>();
        DtoHelper.eoList2DtoList((Collection)eos, dtoList, ApportionmentOrganizationRespDto.class);
        return dtoList;
    }

    @Override
    public Long addApportionmentOrganization(ApportionmentOrganizationReqDto addReqDto) {
        ApportionmentOrganizationEo apportionmentOrganizationEo = new ApportionmentOrganizationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)apportionmentOrganizationEo);
        this.apportionmentOrganizationDas.insert((BaseEo)apportionmentOrganizationEo);
        return apportionmentOrganizationEo.getId();
    }

    @Override
    public void modifyApportionmentOrganization(ApportionmentOrganizationReqDto modifyReqDto) {
        ApportionmentOrganizationEo apportionmentOrganizationEo = new ApportionmentOrganizationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)apportionmentOrganizationEo);
        this.apportionmentOrganizationDas.updateSelective((BaseEo)apportionmentOrganizationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeApportionmentOrganization(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.apportionmentOrganizationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ApportionmentOrganizationRespDto queryById(Long id) {
        ApportionmentOrganizationEo apportionmentOrganizationEo = (ApportionmentOrganizationEo)this.apportionmentOrganizationDas.selectByPrimaryKey(id);
        ApportionmentOrganizationRespDto apportionmentOrganizationRespDto = new ApportionmentOrganizationRespDto();
        DtoHelper.eo2Dto((BaseEo)apportionmentOrganizationEo, (BaseVo)apportionmentOrganizationRespDto);
        return apportionmentOrganizationRespDto;
    }

    @Override
    public PageInfo<ApportionmentOrganizationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ApportionmentOrganizationReqDto apportionmentOrganizationReqDto = (ApportionmentOrganizationReqDto)JSON.parseObject((String)filter, ApportionmentOrganizationReqDto.class);
        ApportionmentOrganizationEo apportionmentOrganizationEo = new ApportionmentOrganizationEo();
        DtoHelper.dto2Eo((BaseVo)apportionmentOrganizationReqDto, (BaseEo)apportionmentOrganizationEo);
        PageInfo eoPageInfo = this.apportionmentOrganizationDas.selectPage((BaseEo)apportionmentOrganizationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ApportionmentOrganizationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

