/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.api.dto.request.CarrierDeliveryAddressReqDto;
import com.dtyunxi.finance.api.dto.response.CarrierDeliveryAddressRespDto;
import com.dtyunxi.finance.biz.service.ICarrierDeliveryAddressService;
import com.dtyunxi.finance.dao.das.CarrierDeliveryAddressDas;
import com.dtyunxi.finance.dao.eo.CarrierDeliveryAddressEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CarrierDeliveryAddressServiceImpl
implements ICarrierDeliveryAddressService {
    @Resource
    private CarrierDeliveryAddressDas carrierDeliveryAddressDas;

    @Override
    public void batchCreate(Long carrierCorrectionId, List<CarrierDeliveryAddressReqDto> reqDtoList) {
        CarrierDeliveryAddressEo delEo = new CarrierDeliveryAddressEo();
        delEo.setCarrierCorrectionId(carrierCorrectionId);
        this.carrierDeliveryAddressDas.delete((BaseEo)delEo);
        if (CollUtil.isEmpty(reqDtoList)) {
            return;
        }
        ArrayList<CarrierDeliveryAddressEo> eos = new ArrayList<CarrierDeliveryAddressEo>();
        for (CarrierDeliveryAddressReqDto dto : reqDtoList) {
            dto.setCarrierCorrectionId(carrierCorrectionId);
            CarrierDeliveryAddressEo eo = new CarrierDeliveryAddressEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)eo);
            eos.add(eo);
        }
        this.carrierDeliveryAddressDas.insertBatch(eos);
    }

    @Override
    public Long addCarrierDeliveryAddress(CarrierDeliveryAddressReqDto addReqDto) {
        CarrierDeliveryAddressEo carrierDeliveryAddressEo = new CarrierDeliveryAddressEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)carrierDeliveryAddressEo);
        this.carrierDeliveryAddressDas.insert((BaseEo)carrierDeliveryAddressEo);
        return carrierDeliveryAddressEo.getId();
    }

    @Override
    public void modifyCarrierDeliveryAddress(CarrierDeliveryAddressReqDto modifyReqDto) {
        CarrierDeliveryAddressEo carrierDeliveryAddressEo = new CarrierDeliveryAddressEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)carrierDeliveryAddressEo);
        this.carrierDeliveryAddressDas.updateSelective((BaseEo)carrierDeliveryAddressEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCarrierDeliveryAddress(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.carrierDeliveryAddressDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CarrierDeliveryAddressRespDto queryById(Long id) {
        CarrierDeliveryAddressEo carrierDeliveryAddressEo = (CarrierDeliveryAddressEo)this.carrierDeliveryAddressDas.selectByPrimaryKey(id);
        CarrierDeliveryAddressRespDto carrierDeliveryAddressRespDto = new CarrierDeliveryAddressRespDto();
        DtoHelper.eo2Dto((BaseEo)carrierDeliveryAddressEo, (BaseVo)carrierDeliveryAddressRespDto);
        return carrierDeliveryAddressRespDto;
    }

    @Override
    public PageInfo<CarrierDeliveryAddressRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CarrierDeliveryAddressReqDto carrierDeliveryAddressReqDto = (CarrierDeliveryAddressReqDto)JSON.parseObject((String)filter, CarrierDeliveryAddressReqDto.class);
        CarrierDeliveryAddressEo carrierDeliveryAddressEo = new CarrierDeliveryAddressEo();
        DtoHelper.dto2Eo((BaseVo)carrierDeliveryAddressReqDto, (BaseEo)carrierDeliveryAddressEo);
        PageInfo eoPageInfo = this.carrierDeliveryAddressDas.selectPage((BaseEo)carrierDeliveryAddressEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CarrierDeliveryAddressRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<CarrierDeliveryAddressRespDto> getByCarrierCorrectionId(Long carrierCorrectionId) {
        List addressEos = ((ExtQueryChainWrapper)this.carrierDeliveryAddressDas.filter().eq((Object)"carrier_correction_id", (Object)carrierCorrectionId)).list();
        ArrayList<CarrierDeliveryAddressRespDto> dtoList = new ArrayList<CarrierDeliveryAddressRespDto>();
        DtoHelper.eoList2DtoList((Collection)addressEos, dtoList, CarrierDeliveryAddressRespDto.class);
        return dtoList;
    }
}

