/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.scheduler;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.yunxi.dg.base.center.share.dao.mapper.ReleasePreemptMapper;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleasePreemptScheduler
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(ReleasePreemptScheduler.class);
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    private ReleasePreemptMapper releasePreemptMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePreemptTask() {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        log.info("\u5f00\u59cb\u6267\u884c\u91ca\u653e\u9884\u5360\u8c03\u5ea6\u4efb\u52a1");
        try {
            List<String> orderNos = this.queryOrdersNeedReleasePreempt();
            if (orderNos == null || orderNos.isEmpty()) {
                log.info("\u6ca1\u6709\u9700\u8981\u91ca\u653e\u9884\u5360\u7684\u8ba2\u5355");
                return;
            }
            log.info("\u67e5\u8be2\u5230\u9700\u8981\u91ca\u653e\u9884\u5360\u7684\u8ba2\u5355\u6570\u91cf: {}, \u8ba2\u5355\u53f7\u5217\u8868: {}", (Object)orderNos.size(), orderNos);
            int successCount = 0;
            int failCount = 0;
            for (String orderNo : orderNos) {
                try {
                    this.releasePreemptForOrder(orderNo);
                    ++successCount;
                    log.info("\u8ba2\u5355 {} \u91ca\u653e\u9884\u5360\u6210\u529f", (Object)orderNo);
                }
                catch (Exception e) {
                    ++failCount;
                    log.error("\u8ba2\u5355 {} \u91ca\u653e\u9884\u5360\u5931\u8d25: {}", new Object[]{orderNo, e.getMessage(), e});
                }
            }
            log.info("\u91ca\u653e\u9884\u5360\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff0c\u6210\u529f: {}, \u5931\u8d25: {}", (Object)successCount, (Object)failCount);
        }
        catch (Exception e) {
            log.error("\u91ca\u653e\u9884\u5360\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\u5f02\u5e38: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            MDC.clear();
        }
    }

    private List<String> queryOrdersNeedReleasePreempt() {
        try {
            return this.releasePreemptMapper.queryOrdersNeedReleasePreempt();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9700\u8981\u91ca\u653e\u9884\u5360\u7684\u8ba2\u5355\u5931\u8d25: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private void releasePreemptForOrder(String orderNo) {
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            log.warn("\u8ba2\u5355\u53f7\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u91ca\u653e\u9884\u5360");
            return;
        }
        try {
            ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
            releasePreemptDto.setSourceNo(orderNo);
            releasePreemptDto.setSourceType("\u63a5\u53e3\u81ea\u52a8\u53d6\u6d88");
            this.calcInventoryService.releasePreempt(releasePreemptDto);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u91ca\u653e\u9884\u5360\u63a5\u53e3\u5931\u8d25\uff0c\u8ba2\u5355\u53f7: {}, \u9519\u8bef: {}", new Object[]{orderNo, e.getMessage(), e});
            throw e;
        }
    }

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.releasePreemptTask();
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

