/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryPreemptionApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PUBLISH_TOPIC", tag="CHILD_ORDER_PREEMPT_LOGIC_TAG")
public class PreemptVirtualByLogicProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(PreemptVirtualByLogicProcess.class);
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    ICsInventoryPreemptionApi csInventoryPreemptionApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        log.info("CHILD_ORDER_PREEMPT_LOGIC_TAG:\u6d88\u606f={}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        try {
            String jsonStr = (String)messageData;
            PreemptDto param = (PreemptDto)JSONObject.parseObject((String)jsonStr, PreemptDto.class);
            Integer searchCountForLessNum = (Integer)RestResponseHelper.extractData((RestResponse)this.csInventoryPreemptionApi.searchCountForLessNum(param.getSourceNo()));
            if (searchCountForLessNum > 0) {
                log.info("\u5b58\u5728\u7f3a\u8d27\u9884\u5360\u60c5\u51b5\uff0c\u6b64\u65f6\u5ffd\u7565\uff0c\u4e0d\u8fdb\u884c\u53cd\u5411\u9884\u5360");
                return MessageResponse.SUCCESS;
            }
            param.setSourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_PREEMPT.getCode());
            this.calcInventoryService.preemptVirtual(param);
            if (StringUtils.isNotBlank((CharSequence)param.getExternalOrderNo())) {
                try {
                    MessageVo messageVo = new MessageVo();
                    messageVo.setData((Object)param.getExternalOrderNo());
                    this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PREEMPT_VIRTUAL_BY_LOGIC_SUCCESS", (Object)messageVo);
                }
                catch (Exception e) {
                    log.error("\u9884\u5360\u903b\u8f91\u4ed3\u53cd\u5411\u9884\u5360\u4f9b\u8d27\u4ed3\u6210\u529f\uff0c\u5e7f\u64ad\u6d88\u606f\u5f02\u5e38: {}", (Throwable)e);
                }
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }
}

