/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShareGoodsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.GenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.OrderAuditResultEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.ShareGoodBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.ShareGoodsOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsAutoAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.VirtualWarehousePageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.OrderAuditRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IShareGoodsOrderService;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualWarehouseService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IOrderAuditDomain;
import com.yunxi.dg.base.center.share.domain.entity.IShareGoodsOrderDetailDomain;
import com.yunxi.dg.base.center.share.domain.entity.IShareGoodsOrderDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualInventoryDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.dto.calc.TransferDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.center.share.eo.OrderAuditEo;
import com.yunxi.dg.base.center.share.eo.ShareGoodsOrderDetailEo;
import com.yunxi.dg.base.center.share.eo.ShareGoodsOrderEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizShareGoodsOrderService")
public class ShareGoodsOrderServiceImpl
implements IShareGoodsOrderService {
    private static final Logger log = LoggerFactory.getLogger(ShareGoodsOrderServiceImpl.class);
    private static final String SHARE_GOODS_ORDER = "share_goods_order";
    @Autowired
    IShareGoodsOrderDomain shareGoodsOrderDomain;
    @Autowired
    IShareGoodsOrderDetailDomain shareGoodsOrderDetailDomain;
    @Autowired
    IContext context;
    @Autowired
    IOrderAuditDomain orderAuditDomain;
    @Autowired
    IVirtualInventoryDomain virtualInventoryDomain;
    @Autowired
    IVirtualWarehouseService virtualWarehouseService;
    @Autowired
    IVirtualWarehouseDomain virtualWarehouseDomain;
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    IInventorySharedWarehouseDomain inventorySharedWarehouseDomain;
    @Autowired
    IInventorySharedDomain inventorySharedDomain;
    @Autowired
    @Qualifier(value="bizShareGoodsOrderService")
    IShareGoodsOrderService self;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long generateShareGoodsOrder(ShareGoodsOrderReqDto addReqDto) {
        log.info("\u65b0\u589e\u5206\u8d27\u5355\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)addReqDto));
        this.checkParams(addReqDto);
        String orderNo = StringUtils.isNotBlank((CharSequence)addReqDto.getOrderNo()) ? addReqDto.getOrderNo() : GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.SHARE_GOODS_ORDER.getCode()).getCode();
        ShareGoodsOrderEo insertEo = new ShareGoodsOrderEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[]{"id"});
        insertEo.setOrderStatus(ShareGoodsOrderStatusEnum.WAIT_AUDIT.getCode());
        insertEo.setOrderNo(orderNo);
        insertEo.setBusinessType(StringUtils.isNotBlank((CharSequence)addReqDto.getBusinessType()) ? addReqDto.getBusinessType() : ShareGoodBusinessTypeEnum.MANUALLY_CREATE.getCode());
        log.info("\u751f\u6210\u5206\u8d27\u5355\u4e3b\u8868\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)insertEo));
        this.shareGoodsOrderDomain.insert((BaseEo)insertEo);
        List ShareGoodsOrderDetailEos = addReqDto.getDetailList().stream().map(dto -> {
            ShareGoodsOrderDetailEo detailEo = new ShareGoodsOrderDetailEo();
            CubeBeanUtils.copyProperties((Object)detailEo, (Object)dto, (String[])new String[]{"id"});
            detailEo.setOrderNo(orderNo);
            return detailEo;
        }).collect(Collectors.toList());
        this.shareGoodsOrderDetailDomain.insertBatch(ShareGoodsOrderDetailEos);
        return insertEo.getId();
    }

    private void checkParams(ShareGoodsOrderReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"\u5ba1\u6838\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        String supplyWarehouseCode = addReqDto.getSupplyWarehouseCode();
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)supplyWarehouseCode), (String)"\u4f9b\u8d27\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        String receiveWarehouseCode = addReqDto.getReceiveWarehouseCode();
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)receiveWarehouseCode), (String)"\u6536\u8d27\u4ed3\u7f16\u7801\u4e0d\u5b58\u5728");
        AssertUtils.isTrue((!supplyWarehouseCode.equals(receiveWarehouseCode) ? 1 : 0) != 0, (String)"\u4f9b\u8d27\u4ed3\u548c\u6536\u8d27\u4ed3\u76f8\u540c\uff0c\u65e0\u6cd5\u63d0\u4ea4\u5206\u8d27\u5355\u4fe1\u606f");
        VirtualWarehouseRespDto supplyVirtualWarehouseEo = this.virtualWarehouseService.queryByCode(addReqDto.getSupplyWarehouseCode());
        AssertUtils.notNull((Object)supplyVirtualWarehouseEo, (String)"60055", (Object[])new Object[]{"\u83b7\u53d6\u4e0d\u5230\u4f9b\u8d27\u4ed3\u4fe1\u606f"});
        VirtualWarehouseRespDto receiveVirtualWarehouseEo = this.virtualWarehouseService.queryByCode(addReqDto.getReceiveWarehouseCode());
        AssertUtils.notNull((Object)receiveVirtualWarehouseEo, (String)"60056", (Object[])new Object[]{"\u83b7\u53d6\u4e0d\u5230\u63a5\u53d7\u4ed3\u4fe1\u606f"});
        AssertUtils.isTrue((ObjectUtils.isNotEmpty((Object)supplyVirtualWarehouseEo.getGroupId()) && ObjectUtils.isNotEmpty((Object)receiveVirtualWarehouseEo.getGroupId()) && supplyVirtualWarehouseEo.getGroupId().equals(receiveVirtualWarehouseEo.getGroupId()) ? 1 : 0) != 0, (String)"60057", (String)"\u4f9b\u8d27\u4ed3\u548c\u63a5\u53d7\u4ed3\u4e0d\u5728\u540c\u4e00\u4e2a\u5206\u7ec4");
        ArrayList<String> warehouseCodeList = new ArrayList<String>();
        warehouseCodeList.add(supplyWarehouseCode);
        warehouseCodeList.add(receiveWarehouseCode);
        QueryWrapper virtualWarehouseQueryWrapper = new QueryWrapper();
        virtualWarehouseQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        virtualWarehouseQueryWrapper.eq((Object)"warehouse_status", (Object)EnableDisableEnum.ENABLE.getCode());
        virtualWarehouseQueryWrapper.eq((Object)"dr", (Object)0);
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)virtualWarehouseQueryWrapper);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)virtualWarehouseEos), (String)"\u8bb0\u5f55\u67e5\u8be2\u4e0d\u5b58\u5728");
        virtualWarehouseEos.forEach(warehouse -> {
            if (warehouse.getWarehouseCode().equals(supplyWarehouseCode)) {
                addReqDto.setSupplyWarehouseId(warehouse.getId());
                addReqDto.setSupplyWarehouseName(warehouse.getWarehouseName());
            }
            if (warehouse.getWarehouseCode().equals(receiveWarehouseCode)) {
                addReqDto.setReceiveWarehouseId(warehouse.getId());
                addReqDto.setReceiveWarehouseName(warehouse.getWarehouseName());
            }
        });
        List itemDetailList = addReqDto.getDetailList();
        BigDecimal totalQuantity = BigDecimal.ZERO;
        HashSet<String> skuCodes = new HashSet<String>();
        for (ShareGoodsOrderDetailReqDto dto : itemDetailList) {
            String skuCode = dto.getSkuCode();
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)skuCode), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u5b58\u5728");
            BigDecimal quantity = dto.getQuantity();
            AssertUtils.isTrue((null != quantity && quantity.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u5c0f\u4e8e0");
            totalQuantity = totalQuantity.add(quantity);
            skuCodes.add(skuCode);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"warehouse_code", (Object)supplyWarehouseCode);
        queryWrapper.in((Object)"sku_code", skuCodes);
        queryWrapper.eq((Object)"dr", (Object)0);
        List virtualInventoryEos = this.virtualInventoryDomain.getMapper().selectList((Wrapper)queryWrapper);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)virtualInventoryEos), (String)String.format("\u865a\u62df\u5e93\u5b58\u8868\u4e0d\u5b58\u5728\u5546\u54c1\u7f16\u7801\uff1a\u3010%s\u3011\u7684\u6279\u6b21\u4fe1\u606f", JSON.toJSONString(skuCodes)));
        Map map = virtualInventoryEos.stream().collect(Collectors.toMap(VirtualInventoryEo::getSkuCode, Function.identity(), (k1, k2) -> k1));
        for (ShareGoodsOrderDetailReqDto dto : itemDetailList) {
            VirtualInventoryEo virtualInventoryEo = (VirtualInventoryEo)map.get(dto.getSkuCode());
            AssertUtils.isTrue((boolean)Objects.nonNull(virtualInventoryEo), (String)"\u4f9b\u8d27\u4ed3\u5e93\u5b58\u8bb0\u5f55\u4e0d\u5b58\u5728");
            dto.setSkuName(virtualInventoryEo.getSkuName());
        }
        addReqDto.setTotalQuantity(totalQuantity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editShareGoodsOrder(String orderNo, ShareGoodsOrderReqDto updateReqDto) {
        log.info("\u7f16\u8f91\u5206\u8d27\u5355\u53c2\u6570\uff1a[orderNo:{}, {}]", (Object)orderNo, (Object)JSON.toJSONString((Object)updateReqDto));
        AssertUtils.notNull((Object)updateReqDto, (String)"\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        ShareGoodsOrderEo eo = this.queryEoByOrderNo(orderNo);
        AssertUtils.isTrue((CsShareGoodsOrderStatusEnum.REJECT.getCode().equals(eo.getOrderStatus()) || CsShareGoodsOrderStatusEnum.WAIT_AUDIT.getCode().equals(eo.getOrderStatus()) ? 1 : 0) != 0, (String)String.format("\u8be5\u5206\u8d27\u5355\u72b6\u6001\u4e3a\uff1a\u3010%s\u3011\u4e0d\u80fd\u4fee\u6539", CsShareGoodsOrderStatusEnum.getDescByCode((String)eo.getOrderStatus())));
        QueryWrapper deleteOrderWrapper = new QueryWrapper();
        deleteOrderWrapper.eq((Object)"order_no", (Object)orderNo);
        deleteOrderWrapper.eq((Object)"dr", (Object)0);
        eo.setDr(1);
        this.shareGoodsOrderDomain.getMapper().update((Object)eo, (Wrapper)deleteOrderWrapper);
        QueryWrapper deleteOrderDetailWrapper = new QueryWrapper();
        deleteOrderDetailWrapper.eq((Object)"order_no", (Object)orderNo);
        deleteOrderDetailWrapper.eq((Object)"dr", (Object)0);
        ShareGoodsOrderDetailEo detailEo = new ShareGoodsOrderDetailEo();
        detailEo.setDr(1);
        this.shareGoodsOrderDetailDomain.getMapper().update((Object)detailEo, (Wrapper)deleteOrderDetailWrapper);
        updateReqDto.setOrderNo(orderNo);
        this.generateShareGoodsOrder(updateReqDto);
    }

    private ShareGoodsOrderEo queryEoByOrderNo(String orderNo) {
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5355\u53f7\u4e0d\u5b58\u5728");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ShareGoodsOrderEo eo = (ShareGoodsOrderEo)this.shareGoodsOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.isTrue((null != eo ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        return eo;
    }

    @Override
    public void cancelShareGoodsOrder(String orderNo) {
        log.info("\u5173\u95ed\u5206\u8d27\u5355\u53c2\u6570\uff1a[orderNo:{}]", (Object)orderNo);
        ShareGoodsOrderEo eo = this.queryEoByOrderNo(orderNo);
        AssertUtils.isTrue((boolean)CsShareGoodsOrderStatusEnum.WAIT_AUDIT.getCode().equals(eo.getOrderStatus()), (String)String.format("\u8be5\u5206\u8d27\u5355\u72b6\u6001\u4e3a\uff1a\u3010%s\u3011\u4e0d\u80fd\u5173\u95ed", CsShareGoodsOrderStatusEnum.getDescByCode((String)eo.getOrderStatus())));
        QueryWrapper deleteOrderWrapper = new QueryWrapper();
        deleteOrderWrapper.eq((Object)"order_no", (Object)orderNo);
        deleteOrderWrapper.eq((Object)"dr", (Object)0);
        eo.setOrderStatus(ShareGoodsOrderStatusEnum.CANCEL.getCode());
        this.shareGoodsOrderDomain.getMapper().update((Object)eo, (Wrapper)deleteOrderWrapper);
    }

    @Override
    public List<String> batchAuditShareGoodsOrder(List<ShareGoodsOrderAuditReqDto> auditReqDtos) {
        log.info("\u5ba1\u6838\u5206\u8d27\u5355\u53c2\u6570\uff1a {}", (Object)JSON.toJSONString(auditReqDtos));
        List<String> orderNos = this.auditCheckParams(auditReqDtos);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"order_no", orderNos);
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List eos = this.shareGoodsOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)eos), (String)"\u8bb0\u5f55\u67e5\u8be2\u4e0d\u5b58\u5728");
        Map orderMap = eos.stream().collect(Collectors.toMap(ShareGoodsOrderEo::getOrderNo, Function.identity(), (k1, k2) -> k1));
        HashMap<String, ShareGoodsOrderEo> updateOrderMap = new HashMap<String, ShareGoodsOrderEo>();
        ArrayList<String> failResult = new ArrayList<String>();
        for (String orderNo : orderNos) {
            ShareGoodsOrderEo eo = (ShareGoodsOrderEo)orderMap.get(orderNo);
            if (Objects.isNull(eo)) {
                failResult.add(String.format("%s\u5355\u53f7\uff0c\u4e0d\u5b58\u5728", orderNo));
                continue;
            }
            if (!ShareGoodsOrderStatusEnum.WAIT_AUDIT.getCode().equals(eo.getOrderStatus()) && !ShareGoodsOrderStatusEnum.AUDIT_PASS_OPERATION_FAILED.getCode().equals(eo.getOrderStatus())) {
                failResult.add(String.format("%s\u5355\u53f7\uff0c%s\u72b6\u6001\u4e0d\u5141\u8bb8\u505a\u5ba1\u6838\u64cd\u4f5c", orderNo, ShareGoodsOrderStatusEnum.getDescByCode((String)eo.getOrderStatus())));
                continue;
            }
            updateOrderMap.put(orderNo, eo);
        }
        QueryWrapper detailEoQueryWrapper = new QueryWrapper();
        detailEoQueryWrapper.in((Object)"order_no", orderNos);
        detailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List orderDetailEoList = this.shareGoodsOrderDetailDomain.getMapper().selectList((Wrapper)detailEoQueryWrapper);
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)orderDetailEoList), (String)"\u8bb0\u5f55\u67e5\u8be2\u4e0d\u5b58\u5728");
        Map<String, List<ShareGoodsOrderDetailEo>> detailMap = orderDetailEoList.stream().collect(Collectors.groupingBy(ShareGoodsOrderDetailEo::getOrderNo));
        Map auditMap = auditReqDtos.stream().collect(Collectors.toMap(ShareGoodsOrderAuditReqDto::getOrderNo, Function.identity(), (k1, k2) -> k1));
        if (updateOrderMap.isEmpty()) {
            return failResult;
        }
        ArrayList<FutureTask<String>> resultList = new ArrayList<FutureTask<String>>();
        for (Map.Entry entry : updateOrderMap.entrySet()) {
            FutureTask<String> futureTask = new FutureTask<String>(() -> {
                String errorMsg = "";
                try {
                    errorMsg = this.self.audit(detailMap, auditMap, entry);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errorMsg = e.getMessage();
                }
                return errorMsg;
            });
            this.executorService.execute(futureTask);
            resultList.add(futureTask);
        }
        while (resultList.size() > 0) {
            Iterator iterator = resultList.iterator();
            while (iterator.hasNext()) {
                try {
                    String result = (String)((FutureTask)iterator.next()).get();
                    log.info("\u5ba1\u6838\u5206\u8d27\u5355\u7ed3\u679c:{}", (Object)result);
                    if (StringUtils.isNotBlank((CharSequence)result)) {
                        failResult.add(result);
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("\u591a\u7ebf\u7a0b\u64cd\u4f5c\u9501\u5e93\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                }
                iterator.remove();
            }
        }
        log.info("\u5206\u8d27\u5355\u8fd4\u56de\u5931\u8d25\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(failResult));
        return failResult;
    }

    @Override
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public String audit(Map<String, List<ShareGoodsOrderDetailEo>> detailMap, Map<String, ShareGoodsOrderAuditReqDto> auditMap, Map.Entry<String, ShareGoodsOrderEo> entry) {
        String failResult = "";
        String orderNo = entry.getKey();
        ShareGoodsOrderEo orderEo = entry.getValue();
        List<ShareGoodsOrderDetailEo> detailEos = detailMap.get(orderNo);
        if (CollectionUtils.isEmpty(detailEos)) {
            failResult = String.format("%s\u5355\u53f7\uff0c\u7f3a\u5931\u4ea7\u54c1\u660e\u7ec6\u4fe1\u606f", orderNo);
            return failResult;
        }
        ShareGoodsOrderAuditReqDto auditReqDto = auditMap.get(orderNo);
        String auditResult = auditReqDto.getAuditResult();
        if (OrderAuditResultEnum.AUDIT_PASS.getCode().equals(auditResult)) {
            this.self.auditPassOrder(auditReqDto, orderEo, detailEos);
        } else if (OrderAuditResultEnum.AUDIT_FAILED.getCode().equals(auditResult)) {
            this.self.auditFailedOrder(auditReqDto, orderEo);
        }
        return failResult;
    }

    private List<String> auditCheckParams(List<ShareGoodsOrderAuditReqDto> auditReqDtos) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(auditReqDtos), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<String> orderNos = new ArrayList<String>(auditReqDtos.size());
        auditReqDtos.forEach(dto -> {
            String orderNo = dto.getOrderNo();
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5ba1\u6838\u5355\u636e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            String auditResult = dto.getAuditResult();
            AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)auditResult) && null != OrderAuditResultEnum.getByCode((String)auditResult) ? 1 : 0) != 0, (String)"\u5ba1\u6838\u7ed3\u679c\u53c2\u6570\u6709\u8bef");
            boolean flag = OrderAuditResultEnum.AUDIT_FAILED.getCode().equals(auditResult) && StringUtils.isNotBlank((CharSequence)dto.getRemark()) || OrderAuditResultEnum.AUDIT_PASS.getCode().equals(auditResult);
            AssertUtils.isTrue((boolean)flag, (String)"\u5ba1\u6838\u4e0d\u901a\u8fc7\uff0c\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
            dto.setAuditUserName(this.context.userName());
            dto.setAuditUserId(this.context.userId());
            orderNos.add(orderNo);
        });
        return orderNos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditPassOrder(ShareGoodsOrderAuditReqDto auditReqDto, ShareGoodsOrderEo shareGoodsOrderEo, List<ShareGoodsOrderDetailEo> orderDetailEoList) {
        log.info("auditPassPlannedOrder==>\u5ba1\u6838\u901a\u8fc7,auditReqDto:{},ShareGoodsOrderEo:{}", (Object)JSON.toJSONString((Object)auditReqDto), (Object)JSON.toJSONString((Object)shareGoodsOrderEo));
        TransferDto transferParam = new TransferDto();
        transferParam.setInWarehouseCode(shareGoodsOrderEo.getReceiveWarehouseCode());
        transferParam.setOutWarehouseCode(shareGoodsOrderEo.getSupplyWarehouseCode());
        transferParam.setSourceNo(shareGoodsOrderEo.getOrderNo());
        transferParam.setSourceType(shareGoodsOrderEo.getBusinessType());
        ArrayList detailParams = Lists.newArrayList();
        for (ShareGoodsOrderDetailEo shareGoodsOrderDetailEo : orderDetailEoList) {
            OperationDetailDto detailParam = new OperationDetailDto();
            detailParam.setWarehouseCode(shareGoodsOrderEo.getSupplyWarehouseCode());
            detailParam.setNum(shareGoodsOrderDetailEo.getQuantity());
            detailParam.setSkuCode(shareGoodsOrderDetailEo.getSkuCode());
            detailParams.add(detailParam);
        }
        transferParam.setDetails((List)detailParams);
        this.calcInventoryService.transfer(transferParam);
        ShareGoodsOrderEo updateEo = new ShareGoodsOrderEo();
        updateEo.setId(shareGoodsOrderEo.getId());
        updateEo.setOrderStatus(ShareGoodsOrderStatusEnum.COMPLETED.getCode());
        updateEo.setRemark(auditReqDto.getRemark());
        this.shareGoodsOrderDomain.updateSelective((BaseEo)updateEo);
        this.auditOrderResult(auditReqDto, shareGoodsOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditFailedOrder(ShareGoodsOrderAuditReqDto auditReqDto, ShareGoodsOrderEo shareGoodsOrderEo) {
        log.info("auditPassFailedOrder==>\u5ba1\u6838\u4e0d\u901a\u8fc7,auditReqDto:{},ShareGoodsOrderEo:{}", (Object)JSON.toJSONString((Object)auditReqDto), (Object)JSON.toJSONString((Object)shareGoodsOrderEo));
        ShareGoodsOrderEo updateEo = new ShareGoodsOrderEo();
        updateEo.setId(shareGoodsOrderEo.getId());
        updateEo.setOrderStatus(ShareGoodsOrderStatusEnum.REJECT.getCode());
        updateEo.setRemark(auditReqDto.getRemark());
        this.shareGoodsOrderDomain.updateSelective((BaseEo)updateEo);
        this.auditOrderResult(auditReqDto, shareGoodsOrderEo);
    }

    private void auditOrderResult(ShareGoodsOrderAuditReqDto auditReqDto, ShareGoodsOrderEo shareGoodsOrderEo) {
        OrderAuditEo OrderAuditEo2 = new OrderAuditEo();
        OrderAuditEo2.setPlatformOrderNo(OrderAuditEo2.getPlatformOrderNo());
        OrderAuditEo2.setOrderNo(shareGoodsOrderEo.getOrderNo());
        OrderAuditEo2.setOrderType(SHARE_GOODS_ORDER);
        OrderAuditEo2.setBusinessType(shareGoodsOrderEo.getBusinessType());
        OrderAuditEo2.setAuditResult(auditReqDto.getAuditResult());
        OrderAuditEo2.setRemark(auditReqDto.getRemark());
        OrderAuditEo2.setAuditUserId(auditReqDto.getAuditUserId());
        OrderAuditEo2.setAuditUserName(auditReqDto.getAuditUserName());
        OrderAuditEo2.setUpdateTime(new Date());
        OrderAuditEo2.setCreateTime(new Date());
        OrderAuditEo2.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        OrderAuditEo2.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        OrderAuditEo2.setUpdatePerson(auditReqDto.getAuditUserName());
        OrderAuditEo2.setCreatePerson(auditReqDto.getAuditUserName());
        OrderAuditEo2.setExtension(shareGoodsOrderEo.getExtension());
        this.orderAuditDomain.insert((BaseEo)OrderAuditEo2);
    }

    @Override
    public void createAndAuditShareGoodsOrder(ShareGoodsAutoAuditReqDto auditReqDto) {
        List shareGoodsOrderEos;
        this.paramsValid(auditReqDto);
        if (StringUtils.isNotBlank((CharSequence)auditReqDto.getPlatformNo()) && CollectionUtils.isNotEmpty((Collection)(shareGoodsOrderEos = this.shareGoodsOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ShareGoodsOrderEo.class).eq(ShareGoodsOrderEo::getPlatformNo, (Object)auditReqDto.getPlatformNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO))))) {
            log.info("\u8be5\u8bf7\u6c42\u5df2\u751f\u6210\u8fc7\u5206\u8d27\u5355");
            return;
        }
        auditReqDto.setOrderNo(null);
        this.self.execCreate(auditReqDto);
        this.execAudit(auditReqDto);
    }

    @Override
    public void autoShareGoodsByDisableWarehouse(VirtualWarehouseEo virtualWarehouseEo) {
        if (!VirtualWarehouseTypeEnum.SUB.getCode().equals(virtualWarehouseEo.getWarehouseType())) {
            throw new BizException("\u4e0d\u662f\u4f9b\u8d27\u5b50\u4ed3\uff0c\u4e0d\u652f\u6301\u81ea\u52a8\u5206\u8d27");
        }
        AssertUtils.notNull((Object)virtualWarehouseEo.getGroupId(), (String)"\u8be5\u4f9b\u8d27\u5b50\u4ed3\u6ca1\u6709\u5206\u7ec4\uff0c\u65e0\u6cd5\u81ea\u52a8\u5206\u8d27");
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).eq(VirtualWarehouseEo::getGroupId, (Object)virtualWarehouseEo.getGroupId())).eq(VirtualWarehouseEo::getWarehouseType, (Object)VirtualWarehouseTypeEnum.OVERALL.getCode())).eq(VirtualWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)virtualWarehouseEos, (String)"\u627e\u4e0d\u5230\u6709\u6548\u5173\u8054\u7684\u4e3b\u4f9b\u8d27\u4ed3\u4fe1\u606f");
        if (virtualWarehouseEos.size() > 1) {
            throw new BizException("\u6548\u5173\u8054\u7684\u4e3b\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u552f\u4e00");
        }
        VirtualWarehouseEo masterVirtualWarehouseEo = (VirtualWarehouseEo)virtualWarehouseEos.get(0);
        List virtualInventoryEos = this.virtualInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualInventoryEo.class).eq(VirtualInventoryEo::getWarehouseCode, (Object)virtualWarehouseEo.getWarehouseCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)virtualInventoryEos)) {
            return;
        }
        ShareGoodsOrderEo shareGoodsOrderEo = new ShareGoodsOrderEo();
        String orderNo = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.SHARE_GOODS_ORDER.getCode()).getCode();
        shareGoodsOrderEo.setOrderNo(orderNo);
        shareGoodsOrderEo.setOrderStatus(ShareGoodsOrderStatusEnum.WAIT_AUDIT.getCode());
        shareGoodsOrderEo.setBusinessType(ShareGoodBusinessTypeEnum.AUTO.getCode());
        shareGoodsOrderEo.setReceiveWarehouseId(masterVirtualWarehouseEo.getId());
        shareGoodsOrderEo.setReceiveWarehouseCode(masterVirtualWarehouseEo.getWarehouseCode());
        shareGoodsOrderEo.setReceiveWarehouseName(masterVirtualWarehouseEo.getWarehouseName());
        shareGoodsOrderEo.setSupplyWarehouseId(virtualWarehouseEo.getId());
        shareGoodsOrderEo.setSupplyWarehouseCode(virtualWarehouseEo.getWarehouseCode());
        shareGoodsOrderEo.setSupplyWarehouseName(virtualWarehouseEo.getWarehouseName());
        shareGoodsOrderEo.setRemark("\u5b50\u4ed3\u7981\u7528\uff0c\u81ea\u52a8\u5206\u8d27");
        ArrayList detailEos = Lists.newArrayList();
        BigDecimal totalCount = BigDecimal.ZERO;
        for (VirtualInventoryEo virtualInventoryEo : virtualInventoryEos) {
            ShareGoodsOrderDetailEo detailEo = new ShareGoodsOrderDetailEo();
            detailEo.setOrderNo(orderNo);
            detailEo.setQuantity(virtualInventoryEo.getAvailable());
            if (BigDecimalUtils.eqZero((BigDecimal)detailEo.getQuantity()).booleanValue()) continue;
            detailEo.setSkuCode(virtualInventoryEo.getSkuCode());
            detailEo.setSkuName(virtualInventoryEo.getSkuName());
            totalCount = BigDecimalUtils.add((BigDecimal)totalCount, (BigDecimal)detailEo.getQuantity());
            detailEos.add(detailEo);
        }
        if (CollectionUtils.isEmpty((Collection)detailEos)) {
            return;
        }
        shareGoodsOrderEo.setTotalQuantity(totalCount);
        this.shareGoodsOrderDomain.insert((BaseEo)shareGoodsOrderEo);
        this.shareGoodsOrderDetailDomain.insertBatch((List)detailEos);
        ShareGoodsOrderAuditReqDto auditReqDto = new ShareGoodsOrderAuditReqDto();
        auditReqDto.setAuditResult(OrderAuditResultEnum.AUDIT_PASS.getCode());
        auditReqDto.setOrderNo(orderNo);
        auditReqDto.setRemark("\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        this.auditPassOrder(auditReqDto, shareGoodsOrderEo, detailEos);
    }

    private void paramsValid(ShareGoodsAutoAuditReqDto auditReqDto) {
        AssertUtils.notBlank((String)auditReqDto.getSupplyWarehouseCode(), (String)"\u4f9b\u8d27\u903b\u8f91\u4ed3\u4ed3\u5e93\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)auditReqDto.getPlatformNo(), (String)"\u5e73\u53f0\u8ba2\u5355/\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)auditReqDto.getLineType(), (String)"\u7ebf\u4e0a\u7ebf\u4e0b\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)auditReqDto.getDetailList(), (String)"\u5206\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void execCreate(ShareGoodsAutoAuditReqDto auditReqDto) {
        String logicWarehouseCode = auditReqDto.getSupplyWarehouseCode();
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).eq(InventorySharedWarehouseEo::getWarehouseCode, (Object)logicWarehouseCode)).eq(InventorySharedWarehouseEo::getStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inventorySharedWarehouseEos, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u5173\u7cfb");
        if (inventorySharedWarehouseEos.size() > 1) {
            log.info("\u4f9b\u8d27\u7b56\u7565\u4e0d\u552f\u4e00, \u4e0d\u652f\u6301\u81ea\u52a8\u5206\u8d27");
            return;
        }
        InventorySharedWarehouseEo inventorySharedWarehouseEo = (InventorySharedWarehouseEo)inventorySharedWarehouseEos.get(0);
        String sharedCode = inventorySharedWarehouseEo.getSharedCode();
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedEo.class).eq(InventorySharedEo::getSharedCode, (Object)sharedCode)).eq(InventorySharedEo::getSharedStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inventorySharedEos, (String)"\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u7b56\u7565");
        InventorySharedEo inventorySharedEo = (InventorySharedEo)inventorySharedEos.get(0);
        VirtualWarehouseRespDto virtualWarehouseRespDto = this.virtualWarehouseService.queryByCode(inventorySharedEo.getVirtualWarehouseCode());
        AssertUtils.notNull((Object)virtualWarehouseRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u903b\u8f91\u4ed3\u5bf9\u5e94\u4f9b\u8d27\u4e3b\u4ed3\u4ed3\u5e93\u4fe1\u606f");
        AssertUtils.notNull((Object)virtualWarehouseRespDto.getGroupId(), (String)"\u8be5\u4f9b\u8d27\u4e3b\u4ed3\u672a\u8bbe\u7f6e\u4f9b\u8d27\u5206\u7ec4");
        VirtualWarehousePageReqDto virtualWarehousePageReqDto = new VirtualWarehousePageReqDto();
        virtualWarehousePageReqDto.setGroupId(virtualWarehouseRespDto.getGroupId());
        virtualWarehousePageReqDto.setLineType(auditReqDto.getLineType());
        PageInfo<VirtualWarehouseRespDto> virtualWarehouseRespDtoPageInfo = this.virtualWarehouseService.queryByPage(virtualWarehousePageReqDto);
        log.info("\u67e5\u8be2\u7684\u5206\u8d27\u5355\u8bf7\u6c42\u7ebf\u4e0a/\u7ebf\u4e0b\u4f9b\u8d27\u4ed3\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)virtualWarehouseRespDtoPageInfo.getList()));
        AssertUtils.notEmpty((Collection)virtualWarehouseRespDtoPageInfo.getList(), (String)"\u83b7\u53d6\u4e0d\u5230\u5206\u7ec4\u5bf9\u5e94\u6307\u5b9a\u7ebf\u4e0a/\u7ebf\u4e0b\u4ed3");
        AssertUtils.isTrue((virtualWarehouseRespDtoPageInfo.getList().size() <= 1 ? 1 : 0) != 0, (String)"\u83b7\u53d6\u5230\u591a\u4e2a\u5206\u7ec4\u5bf9\u5e94\u7684\u6307\u5b9a\u7ebf\u4e0a/\u7ebf\u4e0b\u4ed3");
        ShareGoodsOrderReqDto addReqDto = new ShareGoodsOrderReqDto();
        BeanUtils.copyProperties((Object)auditReqDto, (Object)addReqDto);
        addReqDto.setSupplyWarehouseId(virtualWarehouseRespDto.getId());
        addReqDto.setSupplyWarehouseCode(virtualWarehouseRespDto.getWarehouseCode());
        addReqDto.setSupplyWarehouseName(virtualWarehouseRespDto.getWarehouseName());
        VirtualWarehouseRespDto receiveWarehouseRespDto = (VirtualWarehouseRespDto)virtualWarehouseRespDtoPageInfo.getList().get(0);
        addReqDto.setReceiveWarehouseCode(receiveWarehouseRespDto.getWarehouseCode());
        addReqDto.setReceiveWarehouseId(receiveWarehouseRespDto.getId());
        addReqDto.setReceiveWarehouseName(receiveWarehouseRespDto.getWarehouseName());
        addReqDto.setDetailList(auditReqDto.getDetailList());
        String orderNo = StringUtils.isNotBlank((CharSequence)addReqDto.getOrderNo()) ? addReqDto.getOrderNo() : GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.SHARE_GOODS_ORDER.getCode()).getCode();
        addReqDto.setOrderNo(orderNo);
        auditReqDto.setOrderNo(orderNo);
        this.generateShareGoodsOrder(addReqDto);
    }

    private void execAudit(ShareGoodsAutoAuditReqDto auditReqDto) {
        String orderNo = auditReqDto.getOrderNo();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        queryWrapper.eq((Object)"order_status", (Object)ShareGoodsOrderStatusEnum.WAIT_AUDIT.getCode());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List eos = this.shareGoodsOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)eos)) {
            return;
        }
        ShareGoodsOrderEo eo = (ShareGoodsOrderEo)eos.get(0);
        QueryWrapper detailEoQueryWrapper = new QueryWrapper();
        detailEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        detailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List orderDetailEoList = this.shareGoodsOrderDetailDomain.getMapper().selectList((Wrapper)detailEoQueryWrapper);
        ShareGoodsOrderAuditReqDto shareGoodsOrderEo = new ShareGoodsOrderAuditReqDto();
        shareGoodsOrderEo.setAuditResult(OrderAuditResultEnum.AUDIT_PASS.getCode());
        shareGoodsOrderEo.setOrderNo(auditReqDto.getOrderNo());
        shareGoodsOrderEo.setRemark("\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
        this.self.auditPassOrder(shareGoodsOrderEo, eo, orderDetailEoList);
    }

    @Override
    public ShareGoodsOrderEo selectByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        return (ShareGoodsOrderEo)this.shareGoodsOrderDomain.selectByPrimaryKey(id);
    }

    @Override
    public PageInfo<ShareGoodsOrderRespDto> queryByPage(ShareGoodsOrderQueryDto queryDto) {
        log.info("queryByPage==>\u5206\u9875\u67e5\u8be2,queryDto:{}", (Object)JSON.toJSONString((Object)queryDto));
        this.checkParams(queryDto);
        QueryWrapper<ShareGoodsOrderEo> queryWrapper = this.buildQueryWrapper(queryDto);
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List list = this.shareGoodsOrderDomain.getMapper().selectList(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(list);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, ShareGoodsOrderRespDto.class);
        pageInfo.setList(dtoList);
        return pageInfo;
    }

    @Override
    public ShareGoodsOrderCountRespDto shareGoodsOrderCount(ShareGoodsOrderQueryDto queryDto) {
        ShareGoodsOrderCountRespDto shareDto = new ShareGoodsOrderCountRespDto();
        QueryWrapper<ShareGoodsOrderEo> queryWrapper = this.buildQueryWrapper(queryDto);
        QueryWrapper<ShareGoodsOrderEo> queryWrapperWaitAudit = this.buildQueryWrapper(queryDto);
        QueryWrapper<ShareGoodsOrderEo> queryWrapperCancel = this.buildQueryWrapper(queryDto);
        QueryWrapper<ShareGoodsOrderEo> queryWrapperCompleted = this.buildQueryWrapper(queryDto);
        QueryWrapper<ShareGoodsOrderEo> queryWrapperReject = this.buildQueryWrapper(queryDto);
        QueryWrapper<ShareGoodsOrderEo> queryWrapperFailed = this.buildQueryWrapper(queryDto);
        shareDto.setTotal(Integer.valueOf(this.shareGoodsOrderDomain.getMapper().count(queryWrapper)));
        shareDto.setWaitAudit(Integer.valueOf(this.shareGoodsOrderDomain.getMapper().count((QueryWrapper)queryWrapperWaitAudit.eq((Object)"order_status", (Object)"wait_audit"))));
        shareDto.setCancel(Integer.valueOf(this.shareGoodsOrderDomain.getMapper().count((QueryWrapper)queryWrapperCancel.eq((Object)"order_status", (Object)"cancel"))));
        shareDto.setCompleted(Integer.valueOf(this.shareGoodsOrderDomain.getMapper().count((QueryWrapper)queryWrapperCompleted.eq((Object)"order_status", (Object)"completed"))));
        shareDto.setReject(Integer.valueOf(this.shareGoodsOrderDomain.getMapper().count((QueryWrapper)queryWrapperReject.eq((Object)"order_status", (Object)"reject"))));
        shareDto.setAuditPassOperationFailed(Integer.valueOf(this.shareGoodsOrderDomain.getMapper().count((QueryWrapper)queryWrapperFailed.eq((Object)"order_status", (Object)"audit_pass_operation_failed"))));
        return shareDto;
    }

    @Override
    public List<ShareGoodsOrderRespDto> queryByParam(ShareGoodsOrderQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        AssertUtils.isTrue((null != queryDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper<ShareGoodsOrderEo> queryWrapper = this.buildQueryWrapper(queryDto);
        List list = this.shareGoodsOrderDomain.getMapper().selectList(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<ShareGoodsOrderRespDto>();
        }
        ArrayList<ShareGoodsOrderRespDto> dtoList = new ArrayList<ShareGoodsOrderRespDto>();
        CubeBeanUtils.copyCollection(dtoList, (Collection)list, ShareGoodsOrderRespDto.class);
        return dtoList;
    }

    @Override
    public ShareGoodsOrderRespDto queryByOrderNo(String orderNo) {
        log.info("\u6839\u636e\u5206\u8d27\u5355\u53f7\u67e5\u8be2\u8be6\u60c5\uff1a[{}]", (Object)orderNo);
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5206\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_no", (Object)orderNo);
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.shareGoodsOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ShareGoodsOrderRespDto respDto = new ShareGoodsOrderRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, list.get(0), (String[])new String[0]);
        QueryWrapper auditEoQueryWrapper = new QueryWrapper();
        auditEoQueryWrapper.eq((Object)"order_no", (Object)orderNo);
        auditEoQueryWrapper.eq((Object)"dr", (Object)0);
        List auditEos = this.orderAuditDomain.getMapper().selectList((Wrapper)auditEoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)auditEos)) {
            ArrayList auditRespDtos = new ArrayList();
            CubeBeanUtils.copyCollection(auditRespDtos, (Collection)auditEos, OrderAuditRespDto.class);
            respDto.setOrderAuditList(auditRespDtos);
        }
        return respDto;
    }

    private void checkParams(ShareGoodsOrderQueryDto queryDto) {
        AssertUtils.isTrue((null != queryDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((null != queryDto.getPageNum() && queryDto.getPageNum() > 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtils.isTrue((null != queryDto.getPageSize() && queryDto.getPageSize() > 0 ? 1 : 0) != 0, (String)"\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
    }

    private QueryWrapper<ShareGoodsOrderEo> buildQueryWrapper(ShareGoodsOrderQueryDto queryDto) {
        String supplyWarehouseName;
        String supplyWarehouseCode;
        String receiveWarehouseName;
        String receiveWarehouseCode;
        String orderStatus;
        String platformNo;
        String orderNo;
        List<String> strings;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getOrderNo()) && (strings = Arrays.asList(queryDto.getOrderNo().replace("\uff0c", ",").split(","))).size() > 1) {
            queryDto.setOrderNoList(strings);
            queryDto.setOrderNo(null);
        }
        if (StringUtils.isNotBlank((CharSequence)(orderNo = queryDto.getOrderNo()))) {
            queryWrapper.like((Object)"order_no", (Object)orderNo);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryDto.getOrderNoList())) {
            queryWrapper.in((Object)"order_no", (Collection)queryDto.getOrderNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)(platformNo = queryDto.getPlatformNo()))) {
            queryWrapper.like((Object)"platform_no", (Object)platformNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(orderStatus = queryDto.getOrderStatus()))) {
            queryWrapper.eq((Object)"order_status", (Object)orderStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)(receiveWarehouseCode = queryDto.getReceiveWarehouseCode()))) {
            queryWrapper.like((Object)"receive_warehouse_code", (Object)receiveWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(receiveWarehouseName = queryDto.getReceiveWarehouseName()))) {
            queryWrapper.like((Object)"receive_warehouse_name", (Object)receiveWarehouseName);
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getBusinessType())) {
            queryWrapper.eq((Object)"business_type", (Object)queryDto.getBusinessType());
        }
        if (StringUtils.isNotBlank((CharSequence)(supplyWarehouseCode = queryDto.getSupplyWarehouseCode()))) {
            queryWrapper.like((Object)"supply_warehouse_code", (Object)supplyWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)(supplyWarehouseName = queryDto.getSupplyWarehouseName()))) {
            queryWrapper.like((Object)"supply_warehouse_name", (Object)supplyWarehouseName);
        }
        String createTimeStart = queryDto.getCreateTimeStart();
        String createTimeEnd = queryDto.getCreateTimeEnd();
        if (StringUtils.isNotBlank((CharSequence)createTimeStart) && StringUtils.isNotBlank((CharSequence)createTimeEnd)) {
            queryWrapper.ge((Object)"create_time", (Object)(createTimeStart + " 00:00:00"));
            queryWrapper.le((Object)"create_time", (Object)(createTimeEnd + " 23:59:59"));
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        return queryWrapper;
    }
}

