/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.adapter;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryTotalQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryTotalQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualInventoryApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualInventoryService;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirtualInventoryApiImpl
implements IVirtualInventoryApi {
    @Resource
    IVirtualInventoryService virtualInventoryService;
    @Resource
    ICsLogicInventoryTotalQueryApi csLogicInventoryTotalQueryApi;
    @Autowired
    ICalcInventoryService calcInventoryService;

    public RestResponse<Void> initByLogicInventory() {
        RestResponseHelper.extractData((RestResponse)this.csLogicInventoryTotalQueryApi.queryAndSendChangeLog(new CsInventoryTotalQueryReqDto()));
        return RestResponse.VOID;
    }

    public RestResponse<Void> preemptVirtualByLogic(PreemptDto param) {
        this.calcInventoryService.preemptVirtual(param);
        return RestResponse.VOID;
    }

    public RestResponse<VirtualInventoryRespDto> queryById(Long id) {
        return new RestResponse((Object)this.virtualInventoryService.queryById(id));
    }

    public RestResponse<VirtualInventoryRespDto> queryByCargoCode(String cargoCode, String warehouseCode) {
        return new RestResponse((Object)this.virtualInventoryService.queryByCargoCode(cargoCode, warehouseCode));
    }

    public RestResponse<List<VirtualInventoryRespDto>> queryByCargoCodes(List<String> cargoCodes, String warehouseCode) {
        return new RestResponse(this.virtualInventoryService.queryByCargoCodes(cargoCodes, warehouseCode));
    }

    public RestResponse<PageInfo<VirtualInventoryRespDto>> queryByPage(InventoryQueryReqDto virtualInventoryQueryReqDto) {
        return new RestResponse(this.virtualInventoryService.queryByPage(virtualInventoryQueryReqDto));
    }

    public RestResponse<InventorySummaryRespDto> querySummary(InventoryQueryReqDto virtualInventoryQueryReqDto) {
        return new RestResponse((Object)this.virtualInventoryService.querySummary(virtualInventoryQueryReqDto));
    }
}

