/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.WarehouseRelationReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.WarehouseRelationRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelWarehouseService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.share.dao.das.IChannelInventoryDas;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseItemDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.domain.entity.IRelWarehouseChannelDomain;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualWarehouseDomain;
import com.yunxi.dg.base.center.share.dto.entity.ChannelVirtualConfigDto;
import com.yunxi.dg.base.center.share.dto.entity.ShareConfigDto;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelVirtualWarehouseEo;
import com.yunxi.dg.base.center.share.eo.RelWarehouseChannelEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizChannelWarehouseService")
public class ChannelWarehouseServiceImpl
implements IChannelWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(ChannelWarehouseServiceImpl.class);
    @Autowired
    IChannelWarehouseDomain channelWarehouseDomain;
    @Autowired
    IChannelInventoryDas channelInventoryDas;
    @Autowired
    IVirtualWarehouseDomain virtualWarehouseDomain;
    @Autowired
    IRelWarehouseChannelDomain relWarehouseChannelDomain;
    @Autowired
    ICacheService cacheService;
    @Autowired
    IRelVirtualWarehouseDomain relVirtualWarehouseDomain;
    @Autowired
    IInventorySharedDomain inventorySharedDomain;
    @Autowired
    IInventorySharedWarehouseDomain inventorySharedWarehouseDomain;
    @Autowired
    ICsLogicWarehouseQueryApi csLogicWarehouseQueryApi;
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    IChannelWarehouseItemDomain channelWarehouseItemDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(ChannelWarehouseAddReqDto addReqDto) {
        log.info("\u65b0\u589e\u6e20\u9053\u4ed3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        return this.channelWarehouseAdd(addReqDto);
    }

    private Long channelWarehouseAdd(ChannelWarehouseAddReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getWarehouseCode(), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getWarehouseCode(), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Integer selectCount = this.channelWarehouseDomain.getMapper().selectCount((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)addReqDto.getWarehouseCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (selectCount > 0) {
            throw new CsInventoryException("\u6e20\u9053\u4ed3\u7f16\u7801: %s, \u5df2\u5b58\u5728", addReqDto.getWarehouseCode(), new Object[0]);
        }
        ChannelWarehouseEo insertEo = new ChannelWarehouseEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.channelWarehouseDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateByWarehouseCode(String warehouseCode, ChannelWarehouseUpdateReqDto updateReqDto) {
        AssertUtils.notBlank((String)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)updateReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List channelWarehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)warehouseCode)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtil.isEmpty((Collection)channelWarehouseEos) || CollectionUtil.size((Object)channelWarehouseEos) > 1) {
            throw new BizException("\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u552f\u4e00");
        }
        ChannelWarehouseEo channelWarehouseEo = (ChannelWarehouseEo)channelWarehouseEos.get(0);
        ChannelWarehouseEo updateChannelWarehouseEo = new ChannelWarehouseEo();
        updateChannelWarehouseEo.setId(channelWarehouseEo.getId());
        updateChannelWarehouseEo.setWarehouseName(updateReqDto.getWarehouseName());
        updateChannelWarehouseEo.setContact(updateReqDto.getContact());
        updateChannelWarehouseEo.setLineType(updateReqDto.getLineType());
        updateChannelWarehouseEo.setPhone(updateReqDto.getPhone());
        updateChannelWarehouseEo.setRemark(updateReqDto.getRemark());
        updateChannelWarehouseEo.setWarehouseStatus(updateReqDto.getWarehouseStatus());
        this.channelWarehouseDomain.updateSelective((BaseEo)updateChannelWarehouseEo);
        this.cacheService.hdel("sh_inventory_able_group_channel_warehouse_code", new String[]{warehouseCode});
        if (StringUtils.equals((CharSequence)channelWarehouseEo.getWarehouseStatus(), (CharSequence)updateReqDto.getWarehouseStatus())) {
            return updateChannelWarehouseEo.getId();
        }
        if (EnableDisableEnum.ENABLE.getCode().equals(updateReqDto.getWarehouseStatus())) {
            this.calcInventoryService.refreshChannelInventory((List)Lists.newArrayList((Object[])new String[]{warehouseCode}), (List)Lists.newArrayList());
        }
        return updateChannelWarehouseEo.getId();
    }

    @Override
    public void delete(Long id) {
        AssertUtils.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"ID\u9519\u8bef");
        ChannelWarehouseEo eo = (ChannelWarehouseEo)this.channelWarehouseDomain.selectByPrimaryKey(id);
        AssertUtils.isTrue((eo != null ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.channelWarehouseDomain.logicDeleteById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void rebuildShareInventory(String warehouseCode) {
        this.calcInventoryService.refreshChannelInventory((List)Lists.newArrayList((Object[])new String[]{warehouseCode}), (List)Lists.newArrayList());
    }

    @Override
    public ChannelWarehouseRespDto selectByPrimaryKey(Long id) {
        AssertUtils.notNull((Object)id, (String)"id\u9519\u8bef");
        ChannelWarehouseEo channelWarehouseEo = (ChannelWarehouseEo)this.channelWarehouseDomain.selectByPrimaryKey(id);
        AssertUtils.notNull((Object)channelWarehouseEo, (String)"\u8bb0\u5f55\u67e5\u8be2\u4e0d\u5230");
        ChannelWarehouseRespDto dto = new ChannelWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)channelWarehouseEo, (String[])new String[0]);
        return dto;
    }

    @Override
    public ChannelWarehouseRespDto queryByChannelCode(String channelCode) {
        AssertUtils.notNull((Object)channelCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
        List relWarehouseChannelEo = ((ExtQueryChainWrapper)this.relWarehouseChannelDomain.filter().eq((Object)"channel_code", (Object)channelCode)).list();
        if (ObjectUtils.isEmpty((Object)relWarehouseChannelEo)) {
            return null;
        }
        ChannelWarehouseEo channelWarehouseEo = (ChannelWarehouseEo)this.channelWarehouseDomain.selectByPrimaryKey(((RelWarehouseChannelEo)relWarehouseChannelEo.get(0)).getWarehouseId());
        if (ObjectUtils.isEmpty((Object)channelWarehouseEo)) {
            return null;
        }
        ChannelWarehouseRespDto dto = new ChannelWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)channelWarehouseEo, (String[])new String[0]);
        return dto;
    }

    @Override
    public ChannelWarehouseRespDto queryByWarehouseCode(String warehouseCode) {
        AssertUtils.notNull((Object)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
        ChannelWarehouseEo channelWarehouseEo = (ChannelWarehouseEo)((ExtQueryChainWrapper)this.channelWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)warehouseCode)).one();
        if (ObjectUtils.isEmpty((Object)channelWarehouseEo)) {
            return null;
        }
        ChannelWarehouseRespDto dto = new ChannelWarehouseRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)channelWarehouseEo, (String[])new String[0]);
        return dto;
    }

    @Override
    public Map<String, ChannelWarehouseRespDto> queryByWarehouseCodes(List<String> warehouseCodes) {
        AssertUtils.notNull(warehouseCodes, (String)"\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a");
        List channelWarehouseEos = ((ExtQueryChainWrapper)this.channelWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list();
        if (CollectionUtils.isEmpty((Collection)channelWarehouseEos)) {
            return new HashMap<String, ChannelWarehouseRespDto>();
        }
        ArrayList dtos = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)channelWarehouseEos, dtos, ChannelWarehouseRespDto.class);
        return dtos.stream().collect(Collectors.toMap(ChannelWarehouseRespDto::getWarehouseCode, a -> a));
    }

    @Override
    public Boolean checkChannelWarehouseOverall(Long groupId) {
        ChannelWarehouseEo channelWarehouseEo;
        ExtQueryChainWrapper extQueryChainWrapper = (ExtQueryChainWrapper)this.channelWarehouseDomain.filter().in((Object)"warehouse_type", new Object[]{VirtualWarehouseTypeEnum.OVERALL.getCode()});
        if (groupId != null) {
            extQueryChainWrapper = (ExtQueryChainWrapper)extQueryChainWrapper.eq((Object)"groupId", (Object)groupId);
        }
        return (channelWarehouseEo = (ChannelWarehouseEo)extQueryChainWrapper.one()) != null;
    }

    @Override
    public PageInfo<ChannelWarehousePageRespDto> queryByPage(ChannelWarehouseQueryDto queryDto) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryDto.getWarehouseStatus())) {
            wrapper.like((Object)"warehouse_status", (Object)queryDto.getWarehouseStatus());
        }
        Map<String, List<ShareConfigDto>> configDtoMap = null;
        if (StringUtils.isNotEmpty((CharSequence)queryDto.getSubWarehouseCode()) || StringUtils.isNotEmpty((CharSequence)queryDto.getSubWarehouseName())) {
            ChannelVirtualConfigDto channelVirtualConfigDto = new ChannelVirtualConfigDto(null, null, queryDto.getSubWarehouseCode(), queryDto.getSubWarehouseName());
            List configDtos = this.channelWarehouseItemDomain.queryRelConfigByWarehouse(channelVirtualConfigDto);
            List channelWarehouseCodes = configDtos.stream().map(ShareConfigDto::getReceiveWarehouseCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(channelWarehouseCodes)) {
                return new PageInfo();
            }
            configDtoMap = configDtos.stream().collect(Collectors.groupingBy(ShareConfigDto::getReceiveWarehouseCode));
            wrapper.in((Object)"warehouse_code", channelWarehouseCodes);
        }
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)queryDto.getPageNum(), (int)queryDto.getPageSize());
        List eoList = this.channelWarehouseDomain.getMapper().selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return new PageInfo();
        }
        PageInfo selectPage = new PageInfo(eoList);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)selectPage, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList csChannelWarehouseRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)csChannelWarehouseRespDtos, ChannelWarehousePageRespDto.class);
        if (ObjectUtils.isNotEmpty(configDtoMap)) {
            Map<String, List<ShareConfigDto>> finalConfigDtoMap = configDtoMap;
            csChannelWarehouseRespDtos.forEach(a -> a.setSubWarehouseName(((List)finalConfigDtoMap.get(a.getWarehouseCode())).stream().map(ShareConfigDto::getShareWarehouseName).toString()));
        }
        pageInfo.setList((List)csChannelWarehouseRespDtos);
        List channelWarehouseIds = eoList.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RelVirtualWarehouseEo.class).in(RelVirtualWarehouseEo::getChannelWarehouseId, channelWarehouseIds)).eq(RelVirtualWarehouseEo::getValidFlag, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)relVirtualWarehouseEos)) {
            return pageInfo;
        }
        Map<Long, List<RelVirtualWarehouseEo>> relVirtualWarehouseMap = relVirtualWarehouseEos.stream().collect(Collectors.groupingBy(RelVirtualWarehouseEo::getChannelWarehouseId));
        List virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).distinct().collect(Collectors.toList());
        List virtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectBatchIds(virtualWarehouseIds);
        for (ChannelWarehousePageRespDto dto : pageInfo.getList()) {
            Long channelWarehouseId = dto.getId();
            List<RelVirtualWarehouseEo> relVirtualEos = relVirtualWarehouseMap.get(channelWarehouseId);
            if (!CollectionUtils.isNotEmpty(relVirtualEos)) continue;
            List refIds = relVirtualEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).collect(Collectors.toList());
            List refWarehouseEos = virtualWarehouseEos.stream().filter(o -> refIds.contains(o.getId())).collect(Collectors.toList());
            List relWarehouseNames = refWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseName).collect(Collectors.toList());
            dto.setSubWarehouseName(StringUtils.join(relWarehouseNames, (String)","));
        }
        return pageInfo;
    }

    @Override
    public List<ChannelWarehouseRespDto> queryByCodes(Set<String> channelWarehouseCodes) {
        AssertUtils.notEmpty(channelWarehouseCodes, (String)"\u6e20\u9053\u4ed3\u7f16\u7801\u4e3a\u7a7a");
        List channelWarehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", channelWarehouseCodes)).eq((Object)"dr", (Object)YesNoEnum.NO));
        AssertUtils.notEmpty((Collection)channelWarehouseEos, (String)"\u6e20\u9053\u4ed3\u7f16\u7801\u67e5\u8be2\u4e0d\u5b58\u5728, \u6e20\u9053\u4ed3\u7f16\u7801: %s", (Object[])new Object[]{channelWarehouseCodes});
        Map channelWarehouseMap = channelWarehouseEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Set<Long> channelWarehouseIds = channelWarehouseMap.keySet();
        List relWarehouseChannelEos = this.relWarehouseChannelDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_id", channelWarehouseIds)).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (null == relWarehouseChannelEos) {
            relWarehouseChannelEos = Lists.newArrayList();
        }
        HashMap channelWarehouseIdToChannelMap = Maps.newHashMap();
        for (RelWarehouseChannelEo relWarehouseChannelEo : relWarehouseChannelEos) {
            Set channelCodeSet = (Set)channelWarehouseIdToChannelMap.get(relWarehouseChannelEo.getWarehouseId());
            if (null == channelCodeSet) {
                channelCodeSet = Sets.newHashSet();
            }
            channelCodeSet.add(relWarehouseChannelEo.getChannelCode());
            channelWarehouseIdToChannelMap.put(relWarehouseChannelEo.getWarehouseId(), channelCodeSet);
        }
        HashMap channelToVirtualCodeMap = Maps.newHashMap();
        List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"channel_warehouse_id", channelWarehouseIds)).eq((Object)"valid_flag", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)relVirtualWarehouseEos, (String)"\u6e20\u9053\u4ed3\u5173\u8054\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728, \u6e20\u9053\u4ed3\u7f16\u7801: %s", (Object[])new Object[]{channelWarehouseCodes});
        Set virtualWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getVirtualWarehouseId).filter(Objects::nonNull).collect(Collectors.toSet());
        AssertUtils.notEmpty(virtualWarehouseIds, (String)"\u6e20\u9053\u4ed3\u5173\u8054\u4fe1\u606f\u4e2d\u6ca1\u6709\u6709\u6548\u865a\u4ed3ID, \u6e20\u9053\u4ed3\u7f16\u7801: %s", (Object[])new Object[]{channelWarehouseCodes});
        List allVirtualWarehouseEos = this.virtualWarehouseDomain.selectByIds((List)Lists.newArrayList(virtualWarehouseIds));
        List virtualWarehouseEos = allVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getWarehouseType(), VirtualWarehouseTypeEnum.OVERALL.getCode())).collect(Collectors.toList());
        Set childVirtualWarehouseGroupIds = allVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getWarehouseType(), VirtualWarehouseTypeEnum.SUB.getCode())).map(VirtualWarehouseEo::getGroupId).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(childVirtualWarehouseGroupIds)) {
            virtualWarehouseEos.addAll(this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"group_id", childVirtualWarehouseGroupIds)).eq((Object)"warehouse_type", (Object)VirtualWarehouseTypeEnum.OVERALL.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO)));
        }
        virtualWarehouseEos.removeIf(o -> EnableDisableEnum.DISABLE.getCode().equals(o.getWarehouseStatus()));
        AssertUtils.notEmpty(virtualWarehouseEos, (String)"\u627e\u4e0d\u5230\u5173\u8054\u4e3b\u865a\u4ed3\u4fe1\u606f, \u6e20\u9053\u4ed3\u7f16\u7801: %s", (Object[])new Object[]{channelWarehouseCodes});
        Set virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        for (RelVirtualWarehouseEo relVirtualWarehouseEo : relVirtualWarehouseEos) {
            Long channelWarehouseId = relVirtualWarehouseEo.getChannelWarehouseId();
            ChannelWarehouseEo channelWarehouseEo = (ChannelWarehouseEo)channelWarehouseMap.get(channelWarehouseId);
            AssertUtils.notNull((Object)channelWarehouseEo, (String)"\u6e20\u9053\u4ed3 \u68c0\u7d22\u4e0d\u5230\u6709\u6548\u6e20\u9053\u4ed3\u4fe1\u606f, \u6e20\u9053\u4ed3ID\uff1a%s", (Object[])new Object[]{channelWarehouseId});
            Long virtualWarehouseId = relVirtualWarehouseEo.getVirtualWarehouseId();
            VirtualWarehouseEo virtualWarehouseEo = allVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getId(), virtualWarehouseId)).findFirst().orElse(null);
            AssertUtils.notNull((Object)virtualWarehouseEo, (String)"\u4f9b\u8d27\u4ed3 \u68c0\u7d22\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u4ed3\u4fe1\u606f, \u4f9b\u8d27\u4ed3ID\uff1a%s", (Object[])new Object[]{virtualWarehouseId});
            Object virtualWarehouseSet = (Set)channelToVirtualCodeMap.get(channelWarehouseEo.getWarehouseCode());
            if (null == virtualWarehouseSet) {
                virtualWarehouseSet = Sets.newHashSet();
            }
            virtualWarehouseSet.add(virtualWarehouseEo.getWarehouseCode());
            channelToVirtualCodeMap.put(channelWarehouseEo.getWarehouseCode(), virtualWarehouseSet);
        }
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedEo.class).in(InventorySharedEo::getVirtualWarehouseCode, virtualWarehouseCodes)).eq(InventorySharedEo::getSharedStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO));
        AssertUtils.notEmpty((Collection)inventorySharedEos, (String)"\u4f9b\u8d27\u4ed3\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u5171\u4eab\u7b56\u7565");
        Set sharedCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        AssertUtils.notEmpty((Collection)inventorySharedEos, (String)"\u4f9b\u8d27\u4ed3\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u5171\u4eab\u7b56\u7565\u7f16\u7801");
        HashMap<String, Set> virtualToSharedCodeMap = new HashMap<String, Set>();
        for (InventorySharedEo inventorySharedEo : inventorySharedEos) {
            Set sharedCodeSet = (Set)virtualToSharedCodeMap.get(inventorySharedEo.getVirtualWarehouseCode());
            if (null == sharedCodeSet) {
                sharedCodeSet = Sets.newHashSet();
            }
            sharedCodeSet.add(inventorySharedEo.getSharedCode());
            virtualToSharedCodeMap.put(inventorySharedEo.getVirtualWarehouseCode(), sharedCodeSet);
        }
        List inventorySharedWarehouseEoList = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).in(InventorySharedWarehouseEo::getSharedCode, sharedCodes)).eq(InventorySharedWarehouseEo::getStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtils.notEmpty((Collection)inventorySharedWarehouseEoList, (String)"\u4f9b\u8d27\u4ed3\u5171\u4eab\u7b56\u7565\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u903b\u8f91\u4ed3\u914d\u7f6e");
        Set logicWarehouseCodes = inventorySharedWarehouseEoList.stream().map(InventorySharedWarehouseEo::getWarehouseCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        AssertUtils.notEmpty(logicWarehouseCodes, (String)"\u4f9b\u8d27\u4ed3\u5171\u4eab\u7b56\u7565\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u903b\u8f91\u7f16\u7801");
        HashMap sharedToLogicWarehouseMap = Maps.newHashMap();
        for (InventorySharedWarehouseEo inventorySharedWarehouseEo : inventorySharedWarehouseEoList) {
            Set logicWarehouseCodeSet = (Set)sharedToLogicWarehouseMap.get(inventorySharedWarehouseEo.getSharedCode());
            if (null == logicWarehouseCodeSet) {
                logicWarehouseCodeSet = Sets.newHashSet();
            }
            logicWarehouseCodeSet.add(inventorySharedWarehouseEo.getWarehouseCode());
            sharedToLogicWarehouseMap.put(inventorySharedWarehouseEo.getSharedCode(), logicWarehouseCodeSet);
        }
        CsLogicWarehouseQueryDto csLogicWarehouseQueryDto = new CsLogicWarehouseQueryDto();
        csLogicWarehouseQueryDto.setWarehouseCodeList((List)Lists.newArrayList(logicWarehouseCodes));
        List csLogicWarehouseRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseQueryApi.queryByParam(csLogicWarehouseQueryDto));
        AssertUtils.notEmpty((Collection)csLogicWarehouseRespDtoList, (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u67e5\u8be2\u4e0d\u5230\u6709\u6548\u903b\u8f91\u4ed3");
        Map logicWarehouseRespDtoMap = csLogicWarehouseRespDtoList.stream().collect(Collectors.toMap(CsLogicWarehouseRespDto::getWarehouseCode, Function.identity()));
        ArrayList resultList = Lists.newArrayList();
        for (ChannelWarehouseEo channelWarehouseEo : channelWarehouseEos) {
            ChannelWarehouseRespDto channelWarehouseRespDto = new ChannelWarehouseRespDto();
            BeanUtils.copyProperties((Object)channelWarehouseEo, (Object)channelWarehouseRespDto);
            HashSet logicWarehouseRespDtoSet = Sets.newHashSet();
            Set virtualWarehouseCodeSet = (Set)channelToVirtualCodeMap.get(channelWarehouseEo.getWarehouseCode());
            if (null == virtualWarehouseCodeSet) {
                virtualWarehouseCodeSet = Sets.newHashSet();
            }
            for (String virtualWarehouseCode : virtualWarehouseCodeSet) {
                Set sharedCodeSet;
                VirtualWarehouseEo virtualWarehouseEo = allVirtualWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)virtualWarehouseCode)).findFirst().orElse(null);
                if (null == virtualWarehouseEo) continue;
                if (Objects.equals(virtualWarehouseEo.getWarehouseType(), VirtualWarehouseTypeEnum.SUB.getCode())) {
                    Long groupId = virtualWarehouseEo.getGroupId();
                    VirtualWarehouseEo mainVirtualWarehouseEo = virtualWarehouseEos.stream().filter(o -> Objects.equals(o.getGroupId(), groupId)).findFirst().orElse(null);
                    if (null == mainVirtualWarehouseEo) continue;
                    sharedCodeSet = (Set)virtualToSharedCodeMap.get(mainVirtualWarehouseEo.getWarehouseCode());
                } else {
                    sharedCodeSet = (Set)virtualToSharedCodeMap.get(virtualWarehouseCode);
                }
                if (null == sharedCodeSet) {
                    sharedCodeSet = Sets.newHashSet();
                }
                for (String sharedCode : sharedCodeSet) {
                    Set logicWarehouseCodeSet = (Set)sharedToLogicWarehouseMap.get(sharedCode);
                    if (null == logicWarehouseCodeSet) {
                        logicWarehouseCodeSet = Sets.newHashSet();
                    }
                    for (String logicWarehouseCode : logicWarehouseCodeSet) {
                        CsLogicWarehouseRespDto csLogicWarehouseRespDto = (CsLogicWarehouseRespDto)logicWarehouseRespDtoMap.get(logicWarehouseCode);
                        if (null == csLogicWarehouseRespDto) continue;
                        logicWarehouseRespDtoSet.add(csLogicWarehouseRespDto);
                    }
                }
            }
            channelWarehouseRespDto.setLogicWarehouseList((List)Lists.newArrayList((Iterable)logicWarehouseRespDtoSet));
            channelWarehouseRespDto.setOrderChannelCodes((Set)channelWarehouseIdToChannelMap.get(channelWarehouseEo.getId()));
            resultList.add(channelWarehouseRespDto);
        }
        return resultList;
    }

    @Override
    public Map<String, List<ChannelWarehouseRespDto>> queryByLogicWarehouseCodes(Set<String> logicWarehouseCodes) {
        HashMap retMap = Maps.newHashMap();
        AssertUtils.notEmpty(logicWarehouseCodes, (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        logicWarehouseCodes.forEach(logicWarehouseCode -> {
            List<ChannelWarehouseRespDto> tempList = this.queryByLogicWarehouseCode((String)logicWarehouseCode);
            retMap.put(logicWarehouseCode, tempList);
        });
        return retMap;
    }

    @Override
    public PageInfo<WarehouseRelationRespDto> queryWarehouseRelation(WarehouseRelationReqDto queryDto) {
        return this.channelInventoryDas.queryWarehouseRelation(queryDto);
    }

    private List<ChannelWarehouseRespDto> queryByLogicWarehouseCode(String logicWarehouseCode) {
        ArrayList retList = Lists.newArrayList();
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)logicWarehouseCode)).eq((Object)"status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)inventorySharedWarehouseEos)) {
            Set sharedCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).collect(Collectors.toSet());
            List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", sharedCodes)).eq((Object)"shared_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
            if (CollectionUtils.isNotEmpty((Collection)inventorySharedEos)) {
                Set masterVirtualWarehouseCodes = inventorySharedEos.stream().map(InventorySharedEo::getVirtualWarehouseCode).collect(Collectors.toSet());
                List masterVirtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"warehouse_code", masterVirtualWarehouseCodes)).eq((Object)"warehouse_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"warehouse_type", (Object)VirtualWarehouseTypeEnum.OVERALL.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
                if (CollectionUtils.isNotEmpty((Collection)masterVirtualWarehouseEos)) {
                    Set groupIds = masterVirtualWarehouseEos.stream().map(VirtualWarehouseEo::getGroupId).collect(Collectors.toSet());
                    List allVirtualWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"group_id", groupIds)).eq((Object)"warehouse_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
                    Set virtualWarehouseIds = allVirtualWarehouseEos.stream().map(BaseEo::getId).collect(Collectors.toSet());
                    List relVirtualWarehouseEos = this.relVirtualWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"virtual_warehouse_id", virtualWarehouseIds)).eq((Object)"valid_flag", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
                    if (CollectionUtils.isNotEmpty((Collection)relVirtualWarehouseEos)) {
                        Set channelWarehouseIds = relVirtualWarehouseEos.stream().map(RelVirtualWarehouseEo::getChannelWarehouseId).collect(Collectors.toSet());
                        List channelWarehouseEos = this.channelWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"id", channelWarehouseIds)).eq((Object)"warehouse_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
                        if (CollectionUtils.isNotEmpty((Collection)channelWarehouseEos)) {
                            channelWarehouseEos.forEach(eo -> {
                                ChannelWarehouseRespDto dto = new ChannelWarehouseRespDto();
                                dto.setId(eo.getId());
                                dto.setWarehouseCode(eo.getWarehouseCode());
                                dto.setWarehouseName(eo.getWarehouseName());
                                retList.add(dto);
                            });
                        } else {
                            log.error("queryByLogicWarehouseCode channelWarehouseEos is null channelWarehouseIds={}", channelWarehouseIds);
                        }
                    } else {
                        log.error("queryByLogicWarehouseCode relVirtualWarehouseEos is null virtualWarehouseIds={}", virtualWarehouseIds);
                    }
                } else {
                    log.error("queryByLogicWarehouseCode masterVirtualWarehouseEos is null masterVirtualWarehouseCodes={}", masterVirtualWarehouseCodes);
                }
            } else {
                log.error("queryByLogicWarehouseCode inventorySharedWarehouseEos is null sharedCodes={}", sharedCodes);
            }
        } else {
            log.error("queryByLogicWarehouseCode inventorySharedWarehouseEos is null logicWarehouseCodes={}", (Object)logicWarehouseCode);
        }
        return retList;
    }
}

