/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.mq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.PcpBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptAndOutDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="INVENTORY_CHANGE_TAG")
public class InventoryChangeProcess
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(InventoryChangeProcess.class);
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    private ICsTransferOrderApi csTransferOrderApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        log.info("INVENTORY_CHANGE_TAG:[\u63a5\u6536\u5230\u5e93\u5b58\u5f02\u52a8\u7ed3\u679c\u56de\u4f20]\u6d88\u606f={}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        try {
            String jsonStr = (String)messageData;
            Object obj = JSON.parse((String)jsonStr);
            ArrayList logs = Lists.newArrayList();
            if (obj instanceof JSONObject) {
                CsInventoryLogRespDto csInventoryLogDto = (CsInventoryLogRespDto)JSONObject.toJavaObject((JSON)((JSONObject)obj), CsInventoryLogRespDto.class);
                logs.add(csInventoryLogDto);
            } else {
                logs.addAll(JSONArray.parseArray((String)jsonStr, CsInventoryLogRespDto.class));
            }
            if (CollectionUtils.isEmpty((Collection)logs)) {
                log.error("INVENTORY_CHANGE_TAG:List<CsInventoryLogRespDto> logs is Empty");
                return MessageResponse.SUCCESS;
            }
            String warehouseType = ((CsInventoryLogRespDto)logs.get(0)).getWarehouseType();
            String sourceNo = ((CsInventoryLogRespDto)logs.get(0)).getSourceNo();
            String sourceType = ((CsInventoryLogRespDto)logs.get(0)).getSourceType();
            Map<String, List<CsInventoryLogRespDto>> sourceNoMap = logs.stream().collect(Collectors.groupingBy(CsInventoryLogRespDto::getSourceNo));
            for (List<CsInventoryLogRespDto> sLogs : sourceNoMap.values()) {
                Map<String, List<CsInventoryLogRespDto>> rLogMap = sLogs.stream().collect(Collectors.groupingBy(CsInventoryLogRespDto::getRemark));
                for (List<CsInventoryLogRespDto> gLogs : rLogMap.values()) {
                    log.info("InventoryChangeProcess logs: {}", (Object)LogUtils.buildLogContent(gLogs));
                    Boolean hasSubBalance = false;
                    for (CsInventoryLogRespDto log : gLogs) {
                        if (!BigDecimalUtils.ltZero((BigDecimal)log.getChangeBalance()).booleanValue()) continue;
                        hasSubBalance = true;
                        break;
                    }
                    log.info("InventoryChangeProcess hasSubBalance: {}", (Object)hasSubBalance);
                    Boolean isSaleOrder = StringUtils.contains((CharSequence)gLogs.get(0).getSourceNo(), (CharSequence)"DD");
                    log.info("InventoryChangeProcess DD: {}", (Object)isSaleOrder);
                    Boolean isSaleAllot = PcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(gLogs.get(0).getSourceType()) || CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(gLogs.get(0).getSourceType());
                    if (hasSubBalance.booleanValue() && isSaleOrder.booleanValue()) {
                        this.releasePreemptAndOut(gLogs);
                        continue;
                    }
                    if (hasSubBalance != false && CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(gLogs.get(0).getSourceType()) || hasSubBalance != false && CsPcpBusinessTypeEnum.BC_EQUAL_ALLOT.getCode().equals(gLogs.get(0).getSourceType()) || hasSubBalance.booleanValue() && CsPcpBusinessTypeEnum.CB_EQUAL_ALLOT.getCode().equals(gLogs.get(0).getSourceType())) {
                        String saleOrderNo;
                        CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(sourceNo));
                        log.info("\u67e5\u8be2\u8c03\u62e8\u5355\u4fe1\u606f-{}", JSON.toJSON((Object)csTransferOrderRespDto));
                        if (Objects.nonNull(csTransferOrderRespDto) && StringUtils.isNotBlank((CharSequence)(saleOrderNo = csTransferOrderRespDto.getSaleOrderNo()))) {
                            ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
                            releasePreemptDto.setSourceNo(saleOrderNo);
                            releasePreemptDto.setSourceType("maiyou_allot");
                            log.info("\u9ea6\u4f18\u9500\u552e\u8ba2\u5355\u91ca\u653e\u6e20\u9053\u4ed3\u5e93\u5b58-{}", JSON.toJSON((Object)releasePreemptDto));
                            this.calcInventoryService.releasePreempt(releasePreemptDto);
                        }
                        if (isSaleAllot.booleanValue() && StringUtils.contains((CharSequence)gLogs.get(0).getRemark(), (CharSequence)"\u9884\u5360") || isSaleOrder.booleanValue()) continue;
                        this.supply(gLogs);
                        continue;
                    }
                    if (isSaleAllot.booleanValue() && StringUtils.contains((CharSequence)gLogs.get(0).getRemark(), (CharSequence)"\u9884\u5360") || isSaleOrder.booleanValue()) continue;
                    this.supply(gLogs);
                }
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }

    public void supply(List<CsInventoryLogRespDto> logs) {
        if (CollectionUtils.isEmpty(logs)) {
            return;
        }
        Map<String, List<CsInventoryLogRespDto>> map = logs.stream().collect(Collectors.groupingBy(CsInventoryLogRespDto::getRemark));
        for (Map.Entry<String, List<CsInventoryLogRespDto>> targetEntry : map.entrySet()) {
            try {
                this.calcInventoryService.supplyByLogicLogs(targetEntry.getValue());
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f9b\u5f02\u5e38: {}", (Object)e.getMessage());
                throw e;
            }
        }
    }

    public void releasePreemptAndOut(List<CsInventoryLogRespDto> logs) {
        ReleasePreemptAndOutDto param = new ReleasePreemptAndOutDto();
        CsInventoryLogRespDto csInventoryLogRespDto = logs.get(0);
        param.setSourceType(csInventoryLogRespDto.getSourceType());
        param.setSourceNo(csInventoryLogRespDto.getSourceNo());
        param.setExternalOrderNo(csInventoryLogRespDto.getExternalSourceNo());
        param.setLogicWarehouseCode(csInventoryLogRespDto.getWarehouseCode());
        ArrayList detailParamList = Lists.newArrayList();
        for (CsInventoryLogRespDto log : logs) {
            if (!BigDecimalUtils.ltZero((BigDecimal)log.getChangeBalance()).booleanValue()) continue;
            OperationDetailDto detailParam = new OperationDetailDto();
            detailParam.setWarehouseCode(log.getWarehouseCode());
            detailParam.setSkuCode(log.getCargoCode());
            detailParam.setNum(BigDecimalUtils.abs((BigDecimal)log.getChangeBalance()));
            detailParamList.add(detailParam);
        }
        param.setDetails((List)detailParamList);
        this.calcInventoryService.releasePreemptAndOut(param);
    }
}

