package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
* 平台订单表Eo对象
*
* @author zimu
* @since 2022-05-17
*/
@Data
@ApiModel(value = "PlatformOrderReqDto", description = "平台订单表Eo对象")
public class PlatformOrderQueryReqDto extends BaseRequestDto{
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    /**
     *  主键
     */
    @ApiModelProperty(name = "idList", value = "主键")
    private List<Long> idList;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  组织code
    */
    @ApiModelProperty(name = "organizationCode", value = "组织code")
    private String organizationCode;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  平台订单号
    */
    @ApiModelProperty(name = "platformOrderNo", value = "平台订单号")
    private String platformOrderNo;
    /**
     *  平台订单号
     */
    @ApiModelProperty(name = "platformOrderNoList", value = "平台订单号集合")
    private List<String> platformOrderNoList;
    /**
    *  平台父订单号
    */
    @ApiModelProperty(name = "platformParentOrderNo", value = "平台父订单号")
    private String platformParentOrderNo;
    /**
    *  平台下单时间
    */
    @ApiModelProperty(name = "platformCreateTime", value = "平台下单时间")
    private Date platformCreateTime;
    /**
    *  订单类型，common_order: '普通订单',agency_order: '经销订单',shoppe_order: '专柜订单', integral_order: '积分订单',replenishment_order: '货补订单',activity_order: '活动订单',customer_refunding_order: '消费者退换货',compensation_order: '索赔订单',quality_refunding_order: '质量退换货',replenish_order: '少货补发'
    */
    @ApiModelProperty(name = "orderType", value = "订单类型，common_order: '普通订单',agency_order: '经销订单',shoppe_order: '专柜订单', integral_order: '积分订单',replenishment_order: '货补订单',activity_order: '活动订单',customer_refunding_order: '消费者退换货',compensation_order: '索赔订单',quality_refunding_order: '质量退换货',replenish_order: '少货补发'")
    private String orderType;
    /**
    *  内部订单号
    */
    @ApiModelProperty(name = "saleOrderNo", value = "内部订单号")
    private String saleOrderNo;
    @ApiModelProperty(name = "saleOrderNoList", value = "内部订单号集合")
    private List<String> saleOrderNoList;
    /**
    *  转单状态 0-正常 1-异常 2-作废
    */
    @ApiModelProperty(name = "transferOrderStatus", value = "转单状态 0-正常 1-异常 2-作废")
    private Integer transferOrderStatus;
    @ApiModelProperty(name = "transferOrderStatusList", value = "转单状态 0-正常 1-异常 2-作废")
    private List<Integer> transferOrderStatusList;
    @ApiModelProperty(name = "notInTransferOrderStatusList", value = "转单状态 0-正常 1-异常 2-作废")
    private List<Integer> notInTransferOrderStatusList;
    /**
    *  转单时间
    */
    @ApiModelProperty(name = "transferOrderTime", value = "转单时间")
    private Date transferOrderTime;
    /**
    *  异常原因
    */
    @ApiModelProperty(name = "exceptionReason", value = "异常原因")
    private String exceptionReason;
    /**
    *  店铺id
    */
    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;
    /**
    *  店铺编号
    */
    @ApiModelProperty(name = "shopCode", value = "店铺编号")
    private String shopCode;
    /**
    *  店铺名称
    */
    @ApiModelProperty(name = "shopName", value = "店铺名称")
    private String shopName;
    /**
    *  店铺渠道ID
    */
    @ApiModelProperty(name = "shopChannelId", value = "店铺渠道ID")
    private Long shopChannelId;
    /**
    *  店铺渠道code
    */
    @ApiModelProperty(name = "shopChannelCode", value = "店铺渠道code")
    private String shopChannelCode;
    /**
    *  店铺渠道
    */
    @ApiModelProperty(name = "shopChannel", value = "店铺渠道")
    private String shopChannel;
    /**
    *  订单渠道id
    */
    @ApiModelProperty(name = "orderChannelId", value = "订单渠道id")
    private Long orderChannelId;
    /**
    *  订单渠道code
    */
    @ApiModelProperty(name = "orderChannelCode", value = "订单渠道code")
    private String orderChannelCode;
    /**
    *  订单渠道名称
    */
    @ApiModelProperty(name = "orderChannelName", value = "订单渠道名称")
    private String orderChannelName;
    /**
    *   订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入
    */
    @ApiModelProperty(name = "orderSource", value = " 订单来源 订单来源 0-手工创建 1-CSP推送 2-员工购 3-营养家 4-拆单 5-导入")
    private Integer orderSource;
    /**
    *  销售订单创建时间
    */
    @ApiModelProperty(name = "saleCreateTime", value = "销售订单创建时间")
    private Date saleCreateTime;
    /**
    *  订单来源：0：线下 1: 线上
    */
    @ApiModelProperty(name = "isOnline", value = "订单来源：0：线下 1: 线上")
    private Integer isOnline;
    /**
    *  是否允许拆单标识：0-否 1-是
    */
    @ApiModelProperty(name = "canSplitFlag", value = "是否允许拆单标识 0-否 1-是")
    private Integer canSplitFlag;
    /**
    *  经销渠道
    */
    @ApiModelProperty(name = "saleChannel", value = "经销渠道")
    private String saleChannel;
    /**
    *  客户编码
    */
    @ApiModelProperty(name = "customerCode", value = "客户编码")
    private String customerCode;
    /**
    *  客户名称
    */
    @ApiModelProperty(name = "customerName", value = "客户名称")
    private String customerName;
    /**
    *  客户id
    */
    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;
    /**
    *  作废人
    */
    @ApiModelProperty(name = "obsoletePerson", value = "作废人")
    private String obsoletePerson;
    /**
    *  作废时间
    */
    @ApiModelProperty(name = "obsoleteTime", value = "作废时间")
    private Date obsoleteTime;
    /**
    *  作废原因
    */
    @ApiModelProperty(name = "obsoleteReason", value = "作废原因")
    private String obsoleteReason;
    /**
    *  商品总数量
    */
    @ApiModelProperty(name = "goodsTotalNum", value = "商品总数量")
    private BigDecimal goodsTotalNum;
    /**
    *  商品sku总数量
    */
    @ApiModelProperty(name = "goodsSkuTotalNum", value = "商品sku总数量")
    private BigDecimal goodsSkuTotalNum;
    /**
    *  商品总金额
    */
    @ApiModelProperty(name = "goodsTotalAmount", value = "商品总金额")
    private BigDecimal goodsTotalAmount;
    /**
    *  应付金额
    */
    @ApiModelProperty(name = "orderTotalAmount", value = "应付金额")
    private BigDecimal orderTotalAmount;
    /**
    *  实付金额
    */
    @ApiModelProperty(name = "payAmount", value = "实付金额")
    private BigDecimal payAmount;
    /**
    *  支付时间
    */
    @ApiModelProperty(name = "payTime", value = "支付时间")
    private Date payTime;
    /**
    *  支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付
    */
    @ApiModelProperty(name = "payWay", value = "支付方式，alipay-支付宝-,wechat-微信,cash-现金,other-银联,union_pay-其他,sign_pay-标记支付")
    private String payWay;
    /**
    *  支付状态（0-未支付、1-已支付）
    */
    @ApiModelProperty(name = "payStatus", value = "支付状态（0-未支付、1-已支付）")
    private Integer payStatus;
    /**
    *  渠道仓库id
    */
    @ApiModelProperty(name = "channelWarehouseId", value = "渠道仓库id")
    private Long channelWarehouseId;
    /**
    *  渠道仓库编码
    */
    @ApiModelProperty(name = "channelWarehouseCode", value = "渠道仓库编码")
    private String channelWarehouseCode;
    /**
    *  渠道仓库名称
    */
    @ApiModelProperty(name = "channelWarehouseName", value = "渠道仓库名称")
    private String channelWarehouseName;
    /**
    *  默认发货仓id
    */
    @ApiModelProperty(name = "defaultWarehouseId", value = "默认发货仓id")
    private Long defaultWarehouseId;
    /**
    *  默认发货仓编码
    */
    @ApiModelProperty(name = "defaultWarehouseCode", value = "默认发货仓编码")
    private String defaultWarehouseCode;
    /**
    *  默认发货仓编码名称
    */
    @ApiModelProperty(name = "defaultWarehouseName", value = "默认发货仓编码名称")
    private String defaultWarehouseName;
    /**
    *  订单备注 
    */
    @ApiModelProperty(name = "remark", value = "订单备注 ")
    private String remark;
    /**
    *  商家备注
    */
    @ApiModelProperty(name = "sellerRemark", value = "商家备注")
    private String sellerRemark;
    /**
    *  第三方客户租户id
    */
    @ApiModelProperty(name = "thirdPartyId", value = "第三方客户租户id")
    private String thirdPartyId;


    @ApiModelProperty(name = "rdc", value = "来发货仓库标识, 珠海:RDC_ZH,天津:RDC_TJ")
    private String rdc;

    @ApiModelProperty(name = "ifEas", value = "是否财务后置单 0是1 否；默认0")
    private Integer ifEas;

    @ApiModelProperty(name = "orderBizType", value = "订单业务类型 0:普通订单,1:非药业-财务前置")
    private Integer orderBizType;


    @ApiModelProperty(name = "easOrgId", value = "EAS必须-组织编码")
    private String easOrgId;

    @ApiModelProperty(name = "deliveryDate", value = "交货日期")
    private String deliveryDate;
    @ApiModelProperty(name = "sendDate", value = "发货日期")
    private String sendDate;

    @ApiModelProperty(name = "oldOrderId", value = "合单前的旧订单id")
    private String oldOrderId;

    /**
     * 第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)
     */
    @ApiModelProperty(name = "sourceOrderNo",value = "第三方来源订单号(csp经销订单传平台订单号和积分订单平台订单号)")
    private String sourceOrderNo;


    /**
     * 转单号
     */
    @ApiModelProperty(name = "transformOrderNo",value = "转单号")
    private String transformOrderNo;

    /**
     * 关联转单号
     */
    @ApiModelProperty(name = "reTransformOrderNo",value = "关联转单号")
    private String reTransformOrderNo;

    /**
     * 是否预占库存 0否，1是,默认1
     */
    @ApiModelProperty(name = "releaseState",value = "是否预占库存 0否，1是,默认1")
    private Integer releaseState;

    /**
     * 客户表easCode
     */
    @ApiModelProperty(name = "easCode",value = "客户表easCode")
    private String easCode;


}
