package com.dtyunxi.yundt.cube.center.transform.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 平台订单地址服务接口
*
* @author zimu
* @since 2022-03-08
*/
@Api(tags = {"平台订单地址服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-query-IPlatformOrderAddrQueryApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/platform/orderAddr",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IPlatformOrderAddrQueryApi {

    /**
    * 根据id查询平台订单地址
    *
    * @param id 平台订单地址id
    * @return   平台订单地址数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询平台订单地址", notes = "根据id查询平台订单地址")
    RestResponse<PlatformOrderAddrRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 根据平台订单号id查询平台订单收货地址信息
     *
     * @param orderId 平台订单号
     * @return   平台订单表数据
     */
    @GetMapping("/orderId/{orderId}")
    @ApiOperation(value = "根据平台订单号id查询平台订单收货地址信息", notes = "根据平台订单号id查询平台订单收货地址信息")
    RestResponse<PlatformOrderAddrRespDto> queryByOrderId(@PathVariable("orderId") Long orderId);

    /**
    * 平台订单地址分页数据
    *
    * @param filter   平台订单地址查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 平台订单地址分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "平台订单地址分页数据", notes = "根据filter查询条件查询平台订单地址数据，filter=PlatformOrderAddrReqDto")
    RestResponse<PageInfo<PlatformOrderAddrRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
