/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderChannelReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPcpOrderChannelService;
import com.dtyunxi.yundt.cube.center.transform.biz.utils.NoGenerateUtil;
import com.dtyunxi.yundt.cube.center.transform.dao.das.PcpOrderChannelDas;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.PcpOrderChannelEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PcpOrderChannelServiceImpl
implements IPcpOrderChannelService {
    @Resource
    private PcpOrderChannelDas pcpOrderChannelDas;
    @Resource
    private NoGenerateUtil orderNoGreateUtil;

    @Override
    public Long addPcpOrderChannel(PcpOrderChannelReqDto addReqDto) {
        PcpOrderChannelEo pcpOrderChannelEo = new PcpOrderChannelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pcpOrderChannelEo);
        pcpOrderChannelEo.setChannelCode(this.orderNoGreateUtil.generateNo("OC"));
        this.pcpOrderChannelDas.insert((BaseEo)pcpOrderChannelEo);
        return pcpOrderChannelEo.getId();
    }

    @Override
    public void modifyPcpOrderChannel(PcpOrderChannelReqDto modifyReqDto) {
        PcpOrderChannelEo pcpOrderChannelEo = new PcpOrderChannelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)pcpOrderChannelEo);
        this.pcpOrderChannelDas.updateSelective((BaseEo)pcpOrderChannelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePcpOrderChannel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.pcpOrderChannelDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PcpOrderChannelRespDto queryById(Long id) {
        PcpOrderChannelEo pcpOrderChannelEo = (PcpOrderChannelEo)this.pcpOrderChannelDas.selectByPrimaryKey(id);
        if (pcpOrderChannelEo == null) {
            return null;
        }
        PcpOrderChannelRespDto pcpOrderChannelRespDto = new PcpOrderChannelRespDto();
        DtoHelper.eo2Dto((BaseEo)pcpOrderChannelEo, (BaseVo)pcpOrderChannelRespDto);
        return pcpOrderChannelRespDto;
    }

    @Override
    public PageInfo<PcpOrderChannelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PcpOrderChannelReqDto pcpOrderChannelReqDto = (PcpOrderChannelReqDto)JSON.parseObject((String)filter, PcpOrderChannelReqDto.class);
        LambdaQueryWrapper<PcpOrderChannelEo> wrapper = this.queryWrapper(pcpOrderChannelReqDto);
        IPage page = this.pcpOrderChannelDas.getMapper().selectPage((IPage)new Page((long)pageNum.intValue(), (long)pageSize.intValue()), wrapper);
        PageInfo eoPageInfo = new PageInfo(page.getRecords());
        eoPageInfo.setPageNum(pageNum.intValue());
        eoPageInfo.setPageSize(pageSize.intValue());
        eoPageInfo.setPages((int)page.getPages());
        eoPageInfo.setTotal(page.getTotal());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PcpOrderChannelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<PcpOrderChannelRespDto> queryByShopChannel(PcpOrderChannelReqDto reqDto) {
        LambdaQueryWrapper<PcpOrderChannelEo> wrapper = this.queryWrapper(reqDto);
        List list = this.pcpOrderChannelDas.getMapper().selectList(wrapper);
        ArrayList<PcpOrderChannelRespDto> dtoList = new ArrayList<PcpOrderChannelRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, PcpOrderChannelRespDto.class);
        return dtoList;
    }

    private LambdaQueryWrapper<PcpOrderChannelEo> queryWrapper(PcpOrderChannelReqDto reqDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getChannelName())) {
            wrapper.like(PcpOrderChannelEo::getChannelName, (Object)("%" + reqDto.getChannelName() + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getChannelCode())) {
            wrapper.like(PcpOrderChannelEo::getChannelCode, (Object)("%" + reqDto.getChannelCode() + "%"));
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getChannelCodes())) {
            wrapper.in(PcpOrderChannelEo::getChannelCode, (Collection)reqDto.getChannelCodes());
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getIds())) {
            wrapper.in(BaseEo::getId, (Collection)reqDto.getIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqDto.getOutIds())) {
            wrapper.notIn(BaseEo::getId, (Collection)reqDto.getOutIds());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getStatus())) {
            wrapper.eq(PcpOrderChannelEo::getStatus, (Object)reqDto.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getCreateTimeStart()) && StringUtils.isNotEmpty((CharSequence)reqDto.getCreateTimeEnd())) {
            Date begin = DateUtil.getDayBegin((Date)DateUtil.parseDate((String)reqDto.getCreateTimeStart(), (String)"yyyy-MM-dd"));
            Date end = DateUtil.getDayEnd((Date)DateUtil.parseDate((String)reqDto.getCreateTimeEnd(), (String)"yyyy-MM-dd"));
            wrapper.between(BaseEo::getCreateTime, (Object)DateUtil.getDateToString((Date)begin), (Object)DateUtil.getDateToString((Date)end));
        }
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.orderByDesc(BaseEo::getCreateTime);
        return wrapper;
    }

    @Override
    public PcpOrderChannelRespDto queryByShopChannelByCode(String channelCode) {
        PcpOrderChannelEo queryEo = new PcpOrderChannelEo();
        queryEo.setChannelCode(channelCode);
        PcpOrderChannelEo pcpOrderChannelEo = (PcpOrderChannelEo)this.pcpOrderChannelDas.selectOne((BaseEo)queryEo);
        if (pcpOrderChannelEo == null) {
            return null;
        }
        PcpOrderChannelRespDto pcpOrderChannelRespDto = new PcpOrderChannelRespDto();
        DtoHelper.eo2Dto((BaseEo)pcpOrderChannelEo, (BaseVo)pcpOrderChannelRespDto);
        return pcpOrderChannelRespDto;
    }
}

