/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.transform.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformTransformOrderStatus;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.exception.PlatformExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.biz.service.IPlatformOrderService;
import com.dtyunxi.yundt.cube.center.transform.dao.das.PlatformOrderDas;
import com.dtyunxi.yundt.cube.center.transform.dao.eo.PlatformOrderEo;
import com.dtyunxi.yundt.cube.center.transform.dao.mapper.PlatformOrderMapper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlatformOrderServiceImpl
implements IPlatformOrderService {
    private static final Logger logger = LoggerFactory.getLogger(PlatformOrderServiceImpl.class);
    @Resource
    private PlatformOrderDas platformOrderDas;
    @Resource
    private PlatformOrderMapper platformOrderMapper;
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private IChannelInventoryExposedApi channelInventoryExposedApi;

    @Override
    public Long addPlatformOrder(PlatformOrderReqDto addReqDto) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)platformOrderEo);
        this.platformOrderDas.insert((BaseEo)platformOrderEo);
        return platformOrderEo.getId();
    }

    @Override
    public void modifyPlatformOrder(PlatformOrderReqDto modifyReqDto) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)platformOrderEo);
        this.platformOrderDas.updateSelective((BaseEo)platformOrderEo);
    }

    @Override
    public int optimisticModifyPlatformOrder(PlatformOrderEo platformOrderEo, UpdateWrapper<PlatformOrderEo> updateWrapper, int idealCount, boolean needThrow) {
        logger.info("optimisticModifyPlatformOrder\u5165\u53c2platformOrderEo={}\uff0cupdateWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)platformOrderEo), JSON.toJSONString(updateWrapper), idealCount, needThrow});
        if (updateWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.platformOrderDas.setUpdateSystemFields((BaseEo)platformOrderEo);
        int optCount = this.platformOrderDas.getMapper().update((Object)platformOrderEo, updateWrapper);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
        }
        return optCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePlatformOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.platformOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PlatformOrderRespDto queryById(Long id) {
        PlatformOrderEo selectEo = new PlatformOrderEo();
        selectEo.setId(id);
        PlatformOrderEo platformOrderEo = (PlatformOrderEo)this.platformOrderDas.selectOne((BaseEo)selectEo);
        if (platformOrderEo == null) {
            return null;
        }
        PlatformOrderRespDto platformOrderRespDto = new PlatformOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderEo, (BaseVo)platformOrderRespDto);
        return platformOrderRespDto;
    }

    @Override
    public List<PlatformOrderEo> queryListByPlatformOrderNo(Long orderId, String platformOrderNo) {
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setPlatformOrderNo(platformOrderNo);
        return this.platformOrderDas.select((BaseEo)queryEo);
    }

    @Override
    public PageInfo<PlatformOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PlatformOrderReqDto platformOrderReqDto = (PlatformOrderReqDto)JSON.parseObject((String)filter, PlatformOrderReqDto.class);
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        DtoHelper.dto2Eo((BaseVo)platformOrderReqDto, (BaseEo)platformOrderEo);
        PageInfo eoPageInfo = this.platformOrderDas.selectPage((BaseEo)platformOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, PlatformOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PlatformOrderRespDto queryNormalByPlatformNo(String platformNo) {
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setPlatformOrderNo(platformNo);
        List platformOrderEoList = this.platformOrderDas.selectList((BaseEo)queryEo);
        if (CollectionUtils.isEmpty((Collection)platformOrderEoList)) {
            return null;
        }
        if (platformOrderEoList.size() > 1) {
            if (CollectionUtils.isEmpty(platformOrderEoList = platformOrderEoList.stream().filter(eo -> !eo.getTransferOrderStatus().equals(PlatformTransformOrderStatus.STATUS_2.getCode()) && !eo.getTransferOrderStatus().equals(PlatformTransformOrderStatus.STATUS_3.getCode())).collect(Collectors.toList()))) {
                return null;
            }
            if (platformOrderEoList.size() > 1) {
                throw PlatformExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u5e73\u53f0\u5355\u6570\u636e\u91cd\u590d"});
            }
        }
        PlatformOrderRespDto platformOrderRespDto = new PlatformOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)platformOrderEoList.get(0)), (BaseVo)platformOrderRespDto);
        return platformOrderRespDto;
    }

    @Override
    public List<PlatformOrderRespDto> queryListNormalByPlatformNo(String platformNo) {
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setPlatformOrderNo(platformNo);
        List platformOrderEos = this.platformOrderDas.selectList((BaseEo)queryEo);
        ArrayList<PlatformOrderRespDto> dtoList = new ArrayList<PlatformOrderRespDto>();
        DtoHelper.eoList2DtoList((Collection)platformOrderEos, dtoList, PlatformOrderRespDto.class);
        return dtoList;
    }

    @Override
    public PlatformOrderRespDto queryBySaleNo(String saleNo) {
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setSaleOrderNo(saleNo);
        PlatformOrderEo platformOrderEo = (PlatformOrderEo)this.platformOrderDas.selectOne((BaseEo)queryEo);
        if (platformOrderEo == null) {
            return null;
        }
        PlatformOrderRespDto platformOrderRespDto = new PlatformOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)platformOrderEo, (BaseVo)platformOrderRespDto);
        return platformOrderRespDto;
    }

    @Override
    public List<PlatformOrderRespDto> queryListByParam(PlatformOrderQueryReqDto queryDto) {
        LambdaQueryWrapper<PlatformOrderEo> queryEo = this.queryWrapper(queryDto);
        List platformOrderEos = this.platformOrderMapper.selectList(queryEo);
        ArrayList<PlatformOrderRespDto> dtoList = new ArrayList<PlatformOrderRespDto>();
        if (CollectionUtils.isEmpty((Collection)platformOrderEos)) {
            return dtoList;
        }
        DtoHelper.eoList2DtoList((Collection)platformOrderEos, dtoList, PlatformOrderRespDto.class);
        return dtoList;
    }

    private LambdaQueryWrapper<PlatformOrderEo> queryWrapper(PlatformOrderQueryReqDto queryReqDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (Objects.nonNull(queryReqDto.getOrganizationId())) {
            wrapper.eq(PlatformOrderEo::getOrganizationId, (Object)queryReqDto.getOrganizationId());
        }
        if (Objects.nonNull(queryReqDto.getShopId())) {
            wrapper.eq(PlatformOrderEo::getShopId, (Object)queryReqDto.getShopId());
        }
        if (Objects.nonNull(queryReqDto.getShopChannelId())) {
            wrapper.eq(PlatformOrderEo::getShopChannelId, (Object)queryReqDto.getShopChannelId());
        }
        if (Objects.nonNull(queryReqDto.getIsOnline())) {
            wrapper.eq(PlatformOrderEo::getIsOnline, (Object)queryReqDto.getIsOnline());
        }
        if (Objects.nonNull(queryReqDto.getCustomerId())) {
            wrapper.eq(PlatformOrderEo::getCustomerId, (Object)queryReqDto.getCustomerId());
        }
        if (Objects.nonNull(queryReqDto.getOrderSource())) {
            wrapper.eq(PlatformOrderEo::getOrderSource, (Object)queryReqDto.getOrderSource());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getPlatformOrderNo())) {
            wrapper.eq(PlatformOrderEo::getPlatformOrderNo, (Object)queryReqDto.getPlatformOrderNo());
        }
        if (Objects.nonNull(queryReqDto.getTransferOrderStatus())) {
            wrapper.eq(PlatformOrderEo::getTransferOrderStatus, (Object)queryReqDto.getTransferOrderStatus());
        }
        if (Objects.nonNull(queryReqDto.getId())) {
            wrapper.eq(BaseEo::getId, (Object)queryReqDto.getId());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getSaleOrderNo())) {
            wrapper.eq(PlatformOrderEo::getSaleOrderNo, (Object)queryReqDto.getSaleOrderNo());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getCustomerCode())) {
            wrapper.eq(PlatformOrderEo::getCustomerCode, (Object)queryReqDto.getCustomerCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getSaleOrderNoList())) {
            wrapper.in(PlatformOrderEo::getSaleOrderNo, (Collection)queryReqDto.getSaleOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getIdList())) {
            wrapper.in(BaseEo::getId, (Collection)queryReqDto.getIdList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getPlatformOrderNoList())) {
            wrapper.in(PlatformOrderEo::getPlatformOrderNo, (Collection)queryReqDto.getPlatformOrderNoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getTransferOrderStatusList())) {
            wrapper.in(PlatformOrderEo::getTransferOrderStatus, (Collection)queryReqDto.getTransferOrderStatusList());
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getNotInTransferOrderStatusList())) {
            wrapper.notIn(PlatformOrderEo::getTransferOrderStatus, (Collection)queryReqDto.getNotInTransferOrderStatusList());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getOrderType())) {
            wrapper.eq(PlatformOrderEo::getOrderType, (Object)queryReqDto.getOrderType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getPlatformParentOrderNo())) {
            wrapper.eq(PlatformOrderEo::getPlatformParentOrderNo, (Object)queryReqDto.getPlatformParentOrderNo());
        }
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.orderByDesc(BaseEo::getCreateTime);
        return wrapper;
    }

    @Override
    public RestResponse<Void> goBackCancelPlatformOrder(Long id) {
        PlatformOrderEo platformOrderEo = new PlatformOrderEo();
        platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_0.getCode()));
        PlatformOrderEo queryEo = new PlatformOrderEo();
        queryEo.setId(id);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.eq((Object)"transfer_order_status", (Object)PlatformTransformOrderStatus.STATUS_INIT_1.getCode());
        this.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> invalidPlatformOrderByPlatform(String platformOrderNo) {
        logger.info("invalidPlatformOrderByPlatform==>{}", (Object)platformOrderNo);
        List<PlatformOrderRespDto> platformOrderRespDtos = this.queryListNormalByPlatformNo(platformOrderNo);
        if (CollectionUtils.isNotEmpty(platformOrderRespDtos)) {
            for (PlatformOrderRespDto platformOrderRespDto : platformOrderRespDtos) {
                if (Objects.equals(platformOrderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_2.getCode())) {
                    logger.info("\u5df2\u4f5c\u5e9f\u72b6\u6001\u4e0d\u4f5c\u5e9f\u5355\u636e");
                    continue;
                }
                PlatformOrderEo platformOrderEo = new PlatformOrderEo();
                platformOrderEo.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_2.getCode()));
                platformOrderEo.setObsoleteReason("\u5916\u90e8\u4f5c\u5e9f");
                PlatformOrderEo queryEo = new PlatformOrderEo();
                queryEo.setId(platformOrderRespDto.getId());
                UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
                updateWrapper.eq((Object)"transfer_order_status", (Object)platformOrderRespDto.getTransferOrderStatus());
                this.optimisticModifyPlatformOrder(platformOrderEo, (UpdateWrapper<PlatformOrderEo>)updateWrapper, 1, true);
                if (!Objects.equals(platformOrderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_INIT_1.getCode()) && !Objects.equals(platformOrderRespDto.getTransferOrderStatus(), PlatformTransformOrderStatus.STATUS_4.getCode()) || !StringUtils.isNotEmpty((CharSequence)platformOrderRespDto.getSaleOrderNo())) continue;
                try {
                    logger.info("\u5e73\u53f0\u5355\u5f85\u8f6c\u5355\u72b6\u6001\u4f5c\u5e9f\u91ca\u653e\u5e93\u5b58");
                    this.releaseInventory(platformOrderRespDto.getSaleOrderNo(), platformOrderRespDto.getOrderType(), platformOrderRespDto.getCanSplitFlag(), platformOrderRespDto.getPlatformOrderNo());
                    logger.info("\u5e73\u53f0\u5355\u5f85\u8f6c\u5355\u72b6\u6001\u4f5c\u5e9f\u91ca\u653e\u5e93\u5b58\u6210\u529f");
                }
                catch (Exception e) {
                    logger.info("\u5e73\u53f0\u5355\u5f85\u8f6c\u5355\u72b6\u6001\u4f5c\u5e9f\u91ca\u653e\u5e93\u5b58\u5f02\u5e38:{}", (Object)e.getMessage());
                    logger.error("{},{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        logger.info("\u4f5c\u5e9f\u9500\u552e\u8ba2\u5355");
        RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.invalidOrderByPlatformOrderNo(platformOrderNo));
        logger.info("\u91ca\u653e\u5f85\u8f6c\u5355\u72b6\u6001\u5e93\u5b58");
        return RestResponse.VOID;
    }

    private void releaseInventory(String saleOrderNo, String orderType, Integer canSplitFlag, String platformOrderNo) {
        ReleasePreemptDto csInventoryOperateReqDto = new ReleasePreemptDto();
        csInventoryOperateReqDto.setSourceNo(saleOrderNo);
        csInventoryOperateReqDto.setSourceType(orderType);
        csInventoryOperateReqDto.setExternalOrderNo(platformOrderNo);
        logger.info("\u4f5c\u5e9f\u6e20\u9053\u5355\u91ca\u653e\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApi.releasePreempt(csInventoryOperateReqDto));
    }
}

