/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.apiimpl;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ExportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="customerApi")
public class CustomerApiImpl
implements ICustomerApi {
    @Autowired
    private ICustomerService customerService;

    public RestResponse<Long> add(@Valid CustomerReqDto reqDto) {
        return new RestResponse((Object)this.customerService.add(reqDto));
    }

    public RestResponse<Void> update(@Valid CustomerReqDto reqDto) {
        this.customerService.update(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateAccountStatus(@Valid CustomerReqDto customerReqDto) {
        this.customerService.updateAccountStatus(customerReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> moveCustomerToRegion(String sourceRegionCode, String targetRegionCode) {
        this.customerService.moveCustomerToRegion(sourceRegionCode, targetRegionCode);
        return RestResponse.VOID;
    }

    public RestResponse<Void> saveCustomerExportRecord(@Valid ExportRecordReqDto reqDto) {
        this.customerService.saveCustomerExportRecord(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<CustomerRespDto>> queryByExcel(MultipartFile file) {
        return new RestResponse(this.customerService.queryByExcel(file));
    }

    public RestResponse<Void> modifyCustomerUserIdByThirdPartyId(List<CustomerReqDto> reqDtos) {
        this.customerService.modifyCustomerUserIdByThirdPartyId(reqDtos);
        return RestResponse.VOID;
    }
}

