/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.apiimpl.query;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.VerifyCertificationDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.VerifyCertificationResultDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchBaseReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customerQueryApi")
public class CustomerQueryApiImpl
implements ICustomerQueryApi {
    private static Logger logger = LoggerFactory.getLogger(CustomerQueryApiImpl.class);
    @Autowired
    private ICustomerService customerService;
    @Resource
    private IContext iContext;
    @Resource
    private ICustomerExtService customerExtService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerQueryApi sellerQueryApi;

    public RestResponse<CustomerRespDto> queryByCode(String code) {
        return new RestResponse((Object)this.customerService.queryByCode(code));
    }

    public RestResponse<CustomerRespDto> queryById(Long id) {
        return new RestResponse((Object)this.customerService.queryById(id));
    }

    public RestResponse<List<CustomerNameSimpleRespDto>> queryListByIds(List<Long> ids) {
        return new RestResponse(this.customerService.queryListByIds(ids));
    }

    public RestResponse<PageInfo<CustomerRespDto>> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.customerService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<PageInfo<CustomerRespDto>> queryByPageOnPost(CustomerSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.customerService.queryByPageOnPost(searchReqDto, pageNum, pageSize));
    }

    public RestResponse<List<CustomerRespDto>> queryByList(String filter) {
        return new RestResponse(this.customerService.queryByList(filter));
    }

    public RestResponse<List<CustomerRespDto>> queryPostByList(CustomerSearchReqDto searchReqDto) {
        return new RestResponse(this.customerService.queryPostByList(searchReqDto));
    }

    public RestResponse<List<Long>> queryIdsBySingleFilter(CustomerSearchBaseReqDto customerSearchReqDto) {
        Long currentUserOrgId = this.customerExtService.getCurrentUserOrgId();
        ArrayList merchantIds = Lists.newArrayList();
        merchantIds.add(currentUserOrgId);
        customerSearchReqDto.setMerchantIds((List)merchantIds);
        return new RestResponse(this.customerService.queryIdsBySingleFilter(customerSearchReqDto));
    }

    public RestResponse<List<Long>> getCurrentUserOrOrgCustomer(Long userId, Long orgId) {
        return new RestResponse(this.customerService.getCurrentUserOrOrgCustomer(userId, orgId, false));
    }

    public RestResponse<List<CustomerNameSimpleRespDto>> queryByListParent(Long customerId) {
        return new RestResponse(this.customerService.queryByListParent(customerId));
    }

    public RestResponse<String> queryExcelDownloadUrl() {
        return new RestResponse((Object)this.customerService.queryExcelDownloadUrl());
    }

    public RestResponse<List<CustomerRespDto>> queryCustomerRespDto(List<Long> shopIds) {
        List<Object> customerRespDtos = Lists.newArrayList();
        String customerId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.customerid");
        if (StringUtils.isNumeric((CharSequence)customerId)) {
            logger.info("\u4e1a\u52a1\u5458\u7aef\uff1a{}", (Object)customerId);
            customerRespDtos.add(this.customerService.queryById(Long.valueOf(customerId)));
        } else {
            if (CollectionUtils.isEmpty(shopIds)) {
                return new RestResponse((Object)customerRespDtos);
            }
            logger.info("h5\u7aef");
            HashSet<Long> shopIdSet = new HashSet<Long>(shopIds);
            List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIds(shopIdSet));
            ArrayList merchantIds = Lists.newArrayList();
            for (ShopDto shopDto : shopDtos) {
                merchantIds.add(shopDto.getOrganizationId());
            }
            String orgId = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid");
            logger.info("yes.req.cus.b2b.organizationid,{}", (Object)orgId);
            customerRespDtos = this.customerExtService.queryListByOrgIdAndMerchantIds(merchantIds, orgId != null ? Long.valueOf(orgId) : null);
        }
        return new RestResponse((Object)customerRespDtos);
    }

    public RestResponse<VerifyCertificationResultDto> verifyCertification(VerifyCertificationDto verifyCertificationDto) {
        Date currentTime = new Date();
        VerifyCertificationResultDto resultDto = new VerifyCertificationResultDto();
        ArrayList shopIds = Lists.newArrayList();
        shopIds.add(verifyCertificationDto.getShopId());
        List<CustomerRespDto> customerRespDtos = Lists.newArrayList();
        if (verifyCertificationDto.getCustomerId() != null) {
            CustomerRespDto customerRespDto = this.customerService.queryById(verifyCertificationDto.getCustomerId());
            customerRespDtos.add(customerRespDto);
        } else {
            customerRespDtos = (List)RestResponseHelper.extractData(this.queryCustomerRespDto(shopIds));
        }
        logger.info("\u5ba2\u6237\u8ba4\u8bc1\uff1a\u5ba2\u6237\u4fe1\u606f,{}", (Object)JSONObject.toJSONString(customerRespDtos));
        Long customerId = null;
        boolean passCertification = true;
        Date deadline = null;
        if (CollectionUtils.isNotEmpty(customerRespDtos)) {
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtos.get(0);
            customerId = customerRespDto.getId();
            if (customerRespDto.getIfCertification() == 0) {
                if (null != customerRespDto.getCertificationDeadline()) {
                    deadline = customerRespDto.getCertificationDeadline();
                    passCertification = this.compareTime(currentTime, deadline);
                } else {
                    SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
                    sellerQueryReqDto.setOrganizationId(customerRespDto.getMerchantId());
                    List sellerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.sellerQueryApi.queryList(sellerQueryReqDto));
                    logger.info("\u5ba2\u6237\u8ba4\u8bc1\uff1a\u5546\u5bb6\u4fe1\u606f,{}", (Object)JSONObject.toJSONString((Object)sellerRespDtos));
                    if (CollectionUtils.isNotEmpty((Collection)sellerRespDtos) && null != ((SellerRespDto)sellerRespDtos.get(0)).getSellerCertificationDeadline()) {
                        deadline = ((SellerRespDto)sellerRespDtos.get(0)).getSellerCertificationDeadline();
                        passCertification = this.compareTime(currentTime, deadline);
                    }
                }
            }
        }
        resultDto.setCustomerId(customerId);
        resultDto.setPassCertification(Boolean.valueOf(passCertification));
        resultDto.setDeadline(deadline);
        return new RestResponse((Object)resultDto);
    }

    private boolean compareTime(Date currentTime, Date DeadlineTime) {
        return currentTime.getTime() <= DeadlineTime.getTime();
    }
}

