/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreGovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.BuildStoreSellerRelateReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreGovernAllotReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernContentReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerGovernReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.vo.StoreSellerGovernExcelExtVo;
import com.dtyunxi.yundt.cube.center.customer.biz.vo.StoreSellerGovernExcelVo;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerToBQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.demo.center.xx.api.query.ISellerExtendsQueryApi;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractStoreSellerGovernServiceImpl
implements IStoreSellerGovernService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStoreSellerGovernServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private ISellerQueryApi iSellerQueryApi;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernService")
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource
    private ISellerExtendsQueryApi sellerExtendsQueryApi;
    @Resource
    private StoreDas storeDas;
    @Resource
    private StoreSellerGovernDas storeSellerGovernDas;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernContentService")
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource(name="${yunxi.dg.base.project}_IStoreAreaService")
    private IStoreAreaService storeAreaService;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerRelateService")
    private IStoreSellerRelateService storeSellerRelateService;

    @Override
    public Long addStoreSellerGovern(StoreSellerGovernReqDto addReqDto) {
        StoreSellerGovernEo storeSellerGovernEo = new StoreSellerGovernEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)storeSellerGovernEo);
        this.storeSellerGovernDas.insert((BaseEo)storeSellerGovernEo);
        return storeSellerGovernEo.getId();
    }

    @Override
    public void modifyStoreSellerGovern(StoreSellerGovernReqDto modifyReqDto) {
        StoreSellerGovernEo storeSellerGovernEo = new StoreSellerGovernEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)storeSellerGovernEo);
        this.storeSellerGovernDas.updateSelective((BaseEo)storeSellerGovernEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStoreSellerGovern(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.storeSellerGovernDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public StoreSellerGovernRespDto queryById(Long id) {
        StoreSellerGovernEo storeSellerGovernEo = (StoreSellerGovernEo)this.storeSellerGovernDas.selectByPrimaryKey(id);
        StoreSellerGovernRespDto storeSellerGovernRespDto = new StoreSellerGovernRespDto();
        DtoHelper.eo2Dto((BaseEo)storeSellerGovernEo, (BaseVo)storeSellerGovernRespDto);
        return storeSellerGovernRespDto;
    }

    @Override
    public PageInfo<StoreSellerGovernRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        StoreSellerGovernReqDto storeSellerGovernReqDto = (StoreSellerGovernReqDto)JSON.parseObject((String)filter, StoreSellerGovernReqDto.class);
        StoreSellerGovernEo storeSellerGovernEo = new StoreSellerGovernEo();
        DtoHelper.dto2Eo((BaseVo)storeSellerGovernReqDto, (BaseEo)storeSellerGovernEo);
        PageInfo eoPageInfo = this.storeSellerGovernDas.selectPage((BaseEo)storeSellerGovernEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, StoreSellerGovernRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public RestResponse<StoreSellerGovernExcelRespDto> excel(MultipartFile file) {
        return null;
    }

    @Override
    public RestResponse<StoreSellerGovernExcelRespDto> excelExt(MultipartFile file) {
        StoreSellerGovernExcelRespDto respDto = new StoreSellerGovernExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List storeSellerGovernExcelVoList = Lists.newArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), StoreSellerGovernExcelExtVo.class, (ImportParams)importParams);
            storeSellerGovernExcelVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)storeSellerGovernExcelVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        List<StoreSellerGovernEo> storeSellerGovernEos = this.verifyStoreSellerGovern(storeSellerGovernExcelVoList);
        List errorList = storeSellerGovernExcelVoList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getErrorMsg())).collect(Collectors.toList());
        List successList = storeSellerGovernExcelVoList.stream().filter(c -> !StringUtils.isNotBlank((CharSequence)c.getErrorMsg())).collect(Collectors.toList());
        Map<String, List<StoreSellerGovernExcelExtVo>> listMap = successList.stream().collect(Collectors.groupingBy(StoreSellerGovernExcelExtVo::getSellerCode));
        Map<String, StoreSellerGovernEo> storeSellerGovernEoMap = storeSellerGovernEos.stream().collect(Collectors.toMap(k -> k.getSellerCode(), v -> v, (k1, k2) -> k2));
        listMap.forEach((k, v) -> {
            StoreSellerGovernEo orDefault = storeSellerGovernEoMap.getOrDefault(k, null);
            Assert.notNull((Object)orDefault, (String)"0001", (String)(k + "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728"));
            List<StoreSellerGovernContentRespDto> contents = this.storeSellerGovernContentService.queryByStoreSellerId(orDefault.getId());
            Map<String, List<StoreSellerGovernContentRespDto>> contentMap = contents.stream().collect(Collectors.groupingBy(StoreSellerGovernContentRespDto::getGovernType));
            Map<String, List<StoreSellerGovernExcelExtVo>> storeSellerExcelMap = v.stream().collect(Collectors.groupingBy(StoreSellerGovernExcelExtVo::getType));
            for (GovernTypeEnum typeEnum : GovernTypeEnum.values()) {
                List<StoreSellerGovernContentRespDto> storeSellerGovernContentRespDtos = contentMap.getOrDefault(typeEnum.getCode(), Lists.newArrayList());
                List<StoreSellerGovernExcelExtVo> sellerGovernExcelExtVos = storeSellerExcelMap.getOrDefault(typeEnum.getCode(), Lists.newArrayList());
                if (CollectionUtils.isNotEmpty(sellerGovernExcelExtVos)) {
                    List collect;
                    ArrayList theLastDelCodes = Lists.newArrayList();
                    ArrayList theLastAddCodes = Lists.newArrayList();
                    List delCodes = sellerGovernExcelExtVos.stream().map(c -> c.getDelCodes()).collect(Collectors.toList());
                    List addCodes = sellerGovernExcelExtVos.stream().map(c -> c.getAddCodes()).collect(Collectors.toList());
                    if (!typeEnum.equals((Object)GovernTypeEnum.AREA)) {
                        logger.info("\u836f\u5e97\u7ba1\u8f96\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(delCodes));
                        delCodes.addAll(addCodes);
                        StoreEo storeEo = new StoreEo();
                        storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"social_credit_num", delCodes)}));
                        List select = this.storeDas.select((BaseEo)storeEo);
                        theLastDelCodes.addAll(select.stream().filter(c -> delCodes.contains(c.getSocialCreditNum())).map(c -> c.getStoreId()).collect(Collectors.toList()));
                        theLastAddCodes.addAll(select.stream().filter(c -> addCodes.contains(c.getStoreId())).map(c -> c.getStoreId()).collect(Collectors.toList()));
                    } else {
                        theLastDelCodes.addAll(delCodes);
                        theLastAddCodes.addAll(addCodes);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)theLastDelCodes) && CollectionUtils.isNotEmpty(collect = storeSellerGovernContentRespDtos.stream().filter(c -> theLastDelCodes.contains(c.getGovernContent())).collect(Collectors.toList()))) {
                        List ids = collect.stream().map(e -> e.getId().toString()).collect(Collectors.toList());
                        this.storeSellerGovernContentService.removeStoreSellerGovernContent(StringUtils.join(ids, (String)","), this.context.instanceId());
                        logger.info("[{}]\u7ba1\u8f96\u5185\u5bb9{}\u5904\u7406\u524d:{}", new Object[]{k, typeEnum.getName(), JSON.toJSONString(ids)});
                    }
                    if (CollectionUtils.isNotEmpty((Collection)theLastAddCodes)) {
                        theLastAddCodes.forEach(c -> {
                            if (StringUtils.isNotBlank((CharSequence)c)) {
                                StoreSellerGovernContentReqDto dto = new StoreSellerGovernContentReqDto();
                                dto.setStoreSellerId(orDefault.getId());
                                dto.setGovernType(typeEnum.getCode());
                                dto.setGovernContent(c);
                                dto.setOrganizationId(orDefault.getOrganizationId());
                                this.storeSellerGovernContentService.addStoreSellerGovernContent(dto);
                            }
                        });
                    }
                }
                logger.info("\u5904\u7406\u884c\u6570\u636e\u5b8c\u6210\uff0c\u51c6\u5907\u6784\u5efa\u5546\u5bb6\u7ba1\u8f96\u836f\u5e97\u7684\u5173\u8054\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)orDefault));
                this.storeSellerGovernService.changeStoreSellerGovernStatus(orDefault.getSellerId(), orDefault.getOrganizationId(), GovernStatusEnum.DEAL);
                ExecutorUtils.execute(() -> this.storeSellerRelateService.buildStoreSellerRelate(orDefault.getSellerId(), orDefault.getOrganizationId()));
            }
        });
        respDto.setNum(Integer.valueOf(storeSellerGovernExcelVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        if (CollectionUtils.isNotEmpty(errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u836f\u5e97\u5206\u914d\u5bfc\u5165\u5931\u8d25\u4fe1\u606f_\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, StoreSellerGovernExcelExtVo.class, null, excelName, "xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e) {
                logger.error("\u836f\u5e97\u5206\u914d\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:{}", (Object)e.toString());
                return new RestResponse("-1", "\u836f\u5e97\u5206\u914d\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:" + e);
            }
        }
        return new RestResponse((Object)respDto);
    }

    private List<StoreSellerGovernEo> verifyStoreSellerGovern(List<StoreSellerGovernExcelExtVo> storeSellerGovernExcelVoList) {
        ArrayList storeSellerGovernEos = Lists.newArrayList();
        for (StoreSellerGovernExcelExtVo c : storeSellerGovernExcelVoList) {
            if (null == c.getSellerCode()) {
                c.setErrorMsg("\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
                continue;
            }
            SellerToBQueryReqDto reqDto = new SellerToBQueryReqDto();
            reqDto.setCode(c.getSellerCode());
            reqDto.setPageNum(1);
            reqDto.setPageSize(Integer.MAX_VALUE);
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.queryPageByFeign(reqDto));
            SellerToBListRespDto sellerRespDto = null;
            if (!CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                c.setErrorMsg("\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728");
                continue;
            }
            sellerRespDto = (SellerToBListRespDto)pageInfo.getList().get(0);
            StoreSellerGovernEo storeSellerGovernEo = new StoreSellerGovernEo();
            storeSellerGovernEo.setSellerCode(c.getSellerCode());
            StoreSellerGovernEo sellerGovernEo = (StoreSellerGovernEo)this.storeSellerGovernDas.selectOne((BaseEo)storeSellerGovernEo);
            if (!sellerGovernEo.getRelateStatus().equals(GovernStatusEnum.OVER.getKey())) {
                c.setErrorMsg("\u5f53\u524d\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5173\u7cfb\u6b63\u5728\u751f\u6210\u4e2d");
            }
            StoreSellerGovernEo eo = new StoreSellerGovernEo();
            eo.setSellerCode(c.getSellerCode());
            StoreSellerGovernEo governEo = (StoreSellerGovernEo)this.storeSellerGovernDas.selectOne((BaseEo)eo);
            if (Objects.isNull(governEo)) {
                governEo = new StoreSellerGovernEo();
                governEo.setSellerId(sellerRespDto.getId());
                governEo.setSellerCode(sellerRespDto.getCode());
                governEo.setSellerName(sellerRespDto.getName());
                governEo.setCompanyName(sellerRespDto.getOrganizationName());
                governEo.setOrganizationId(sellerRespDto.getOrganizationId());
                this.storeSellerGovernDas.insert((BaseEo)governEo);
            }
            storeSellerGovernEos.add(governEo);
        }
        return storeSellerGovernEos;
    }

    @Override
    public PageInfo<StoreSellerGovernRespDto> queryPage(StoreSellerGovernQueryReqDto reqDto) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long allotStoreGovernArea(StoreGovernAllotReqDto reqDto) {
        return null;
    }

    @Override
    public StoreSellerGovernRespDto queryStoreSellerGovernByID(Long id, Long sellerId) {
        if (ObjectUtils.isEmpty((Object)id) && ObjectUtils.isEmpty((Object)sellerId)) {
            return null;
        }
        StoreSellerGovernEo params = new StoreSellerGovernEo();
        params.setId(id);
        params.setSellerId(sellerId);
        StoreSellerGovernEo storeSellerGovernEo = (StoreSellerGovernEo)this.storeSellerGovernDas.selectOne((BaseEo)params);
        StoreSellerGovernRespDto respDto = new StoreSellerGovernRespDto();
        DtoHelper.eo2Dto((BaseEo)storeSellerGovernEo, (BaseVo)respDto);
        return respDto;
    }

    @Override
    public List<StoreSellerGovernRespDto> queryExcel(StoreSellerGovernQueryReqDto reqDto) {
        return Lists.newArrayList();
    }

    @Override
    public void deleteStoreSellerGovern(Long id) {
        if (ObjectUtils.isEmpty((Object)id)) {
            throw new BizException("-1", "\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
        }
        StoreSellerGovernRespDto respDto = this.queryById(id);
        this.storeSellerGovernDas.logicDeleteById(id);
        this.storeSellerGovernContentService.deleteGovernContent(id);
        this.storeSellerRelateService.deleteStoreSellerRelate(respDto.getSellerId());
    }

    @Override
    public List<StoreSellerGovernRespDto> queryByStore(StoreReqDto storeReqDto) {
        ArrayList<String> areas = new ArrayList<String>();
        areas.add(storeReqDto.getProvinceCode());
        areas.add(storeReqDto.getCityCode());
        areas.add(storeReqDto.getDistrictCode());
        List storeSellerGovernRespDtos = this.storeSellerGovernDas.queryByArea(areas, storeReqDto.getStoreId());
        if (CollectionUtils.isEmpty((Collection)storeSellerGovernRespDtos)) {
            return new ArrayList<StoreSellerGovernRespDto>();
        }
        return storeSellerGovernRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeStoreSellerGovernStatus(Long sellerId, Long orgId, GovernStatusEnum governStatusEnum) {
    }

    @Override
    public List<StoreSellerGovernRespDto> queryByParentStoreId(String parentStoreId) {
        return null;
    }

    protected Map<String, Integer> getGovernDetail(String govern) {
        String[] splitStr;
        HashMap<String, Integer> restMap = new HashMap<String, Integer>();
        restMap.put(StoreGovernTypeEnum.AREA.getCode(), 0);
        restMap.put(StoreGovernTypeEnum.STORE.getCode(), 0);
        restMap.put(StoreGovernTypeEnum.BLACKLIST.getCode(), 0);
        restMap.put(StoreGovernTypeEnum.STORE_PARENT.getCode(), 0);
        if (StringUtils.isEmpty((CharSequence)govern)) {
            return restMap;
        }
        for (String str : splitStr = govern.split(",")) {
            String[] governSplit = str.split("-");
            restMap.put(governSplit[0], Integer.valueOf(governSplit[1]));
        }
        return restMap;
    }

    protected StoreSellerGovernExcelVo excelErrorMsg(StoreSellerGovernExcelVo vo, String errorMsg) {
        vo.setErrorMsg(errorMsg);
        return vo;
    }

    @Override
    public void buildStoreSellerRelate(BuildStoreSellerRelateReqDto storeSellerRelateReqDto) {
    }
}

