/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.tcbj.small;

import cn.hutool.core.util.IdUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.SellerAreaDto;
import com.dtyunxi.yundt.cube.center.customer.biz.proxy.shop.ISellerExpandApi;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerAreaDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.cube.center.user.api.util.AssertUtil;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.request.CustomerAreaExtReqDto;
import com.yx.tcbj.center.customer.biz.service.adapter.AbstractCustomerAreaExtServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tcbj_small_ICustomerAreaExtService")
public class TcbjSmallCustomerAreaExtServiceImpl
extends AbstractCustomerAreaExtServiceImpl {
    @Resource
    private CustomerAreaDas customerAreaDas;
    @Resource
    private CustomerAreaMapper customerAreaMapper;
    @Resource
    private ISellerExpandApi sellerExpandApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateSaleArea(List<CustomerAreaExtReqDto> addAreaList) {
        AssertUtil.assertNotEmpty(addAreaList, (String)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a");
        Long orgInfoId = addAreaList.get(0).getOrgInfoId();
        List areaNameList = addAreaList.stream().map(CustomerAreaExtReqDto::getName).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_info_id", (Object)orgInfoId);
        queryWrapper.in((Object)"name", areaNameList);
        List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)queryWrapper);
        Map<Object, Object> customerAreaEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
            customerAreaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getName, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList sellerAreaDtoList = Lists.newArrayList();
        int i = 0;
        String parentCode = "";
        Long topId = null;
        for (CustomerAreaExtReqDto areaExtReqDto : addAreaList) {
            SellerAreaDto areaDto;
            String name = areaExtReqDto.getName();
            if (customerAreaEoMap.isEmpty() || !customerAreaEoMap.containsKey(name)) {
                CustomerAreaEo addAreaEo = new CustomerAreaEo();
                String code = IdUtil.fastSimpleUUID();
                addAreaEo.setCode(code);
                addAreaEo.setName(name);
                addAreaEo.setOrgInfoId(orgInfoId);
                addAreaEo.setSort(Integer.valueOf(1));
                addAreaEo.setInstanceId(areaExtReqDto.getInstanceId());
                addAreaEo.setTenantId(areaExtReqDto.getTenantId());
                if (i == 0) {
                    addAreaEo.setLevel(Integer.valueOf(i));
                    addAreaEo.setParentCode("0");
                    addAreaEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    addAreaEo.setTopId(addAreaEo.getId());
                    parentCode = code;
                    topId = addAreaEo.getId();
                } else {
                    addAreaEo.setLevel(Integer.valueOf(i));
                    addAreaEo.setParentCode(parentCode);
                    addAreaEo.setTopId(topId);
                    parentCode = code;
                }
                this.customerAreaDas.insert((BaseEo)addAreaEo);
                areaDto = new SellerAreaDto();
                areaDto.setSellerId(areaExtReqDto.getSellerId());
                areaDto.setAreaCode(addAreaEo.getCode());
                areaDto.setAreaLevel(addAreaEo.getLevel() + "");
                sellerAreaDtoList.add(areaDto);
            } else {
                CustomerAreaEo editAreaEo = (CustomerAreaEo)customerAreaEoMap.get(name);
                Long oldTopId = editAreaEo.getTopId();
                editAreaEo.setInstanceId(areaExtReqDto.getInstanceId());
                editAreaEo.setTenantId(areaExtReqDto.getTenantId());
                if (i == 0) {
                    editAreaEo.setLevel(Integer.valueOf(i));
                    editAreaEo.setParentCode("0");
                    editAreaEo.setTopId(editAreaEo.getId());
                    parentCode = editAreaEo.getCode();
                    topId = editAreaEo.getId();
                } else {
                    editAreaEo.setLevel(Integer.valueOf(i));
                    editAreaEo.setParentCode(parentCode);
                    editAreaEo.setTopId(topId);
                    parentCode = editAreaEo.getCode();
                }
                areaDto = new SellerAreaDto();
                areaDto.setSellerId(areaExtReqDto.getSellerId());
                areaDto.setAreaCode(editAreaEo.getCode());
                areaDto.setAreaLevel(editAreaEo.getLevel() + "");
                sellerAreaDtoList.add(areaDto);
                CustomerAreaEo areaQueryEo = new CustomerAreaEo();
                areaQueryEo.setTopId(oldTopId);
                areaQueryEo.setOrgInfoId(editAreaEo.getOrgInfoId());
                List<CustomerAreaEo> topIdAreaList = this.customerAreaDas.select((BaseEo)areaQueryEo);
                topIdAreaList = topIdAreaList.stream().sorted(Comparator.comparing(StdCustomerAreaEo::getLevel)).collect(Collectors.toList());
                ArrayList childAllList = Lists.newArrayList();
                this.doChildAreaList(topIdAreaList, childAllList, editAreaEo.getCode());
                Map<String, List<CustomerAreaEo>> childAreaGroupMap = childAllList.stream().collect(Collectors.groupingBy(StdCustomerAreaEo::getParentCode));
                for (List<CustomerAreaEo> areaEos : childAreaGroupMap.values()) {
                    int level = i + 1;
                    for (CustomerAreaEo customerAreaEo : areaEos) {
                        customerAreaEo.setTopId(topId);
                        customerAreaEo.setLevel(Integer.valueOf(level));
                        this.customerAreaDas.update((BaseEo)customerAreaEo);
                        SellerAreaDto childAreaDto = new SellerAreaDto();
                        childAreaDto.setSellerId(areaExtReqDto.getSellerId());
                        childAreaDto.setAreaCode(customerAreaEo.getCode());
                        childAreaDto.setAreaLevel(customerAreaEo.getLevel() + "");
                        childAreaDto.setInstanceId(customerAreaEo.getInstanceId());
                        childAreaDto.setTenantId(customerAreaEo.getTenantId());
                        sellerAreaDtoList.add(areaDto);
                    }
                }
                this.customerAreaDas.update((BaseEo)editAreaEo);
            }
            ++i;
        }
        if (CollectionUtils.isNotEmpty((Collection)sellerAreaDtoList)) {
            this.sellerExpandApi.updateSellerAreaBatch(sellerAreaDtoList);
        }
    }

    private boolean doChildAreaList(List<CustomerAreaEo> topIdAreaList, List<CustomerAreaEo> childAllList, String code) {
        List childList = topIdAreaList.stream().filter(dto -> dto.getParentCode().equals(code)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(childList)) {
            return true;
        }
        childAllList.addAll(childList);
        for (CustomerAreaEo customerAreaEo : childList) {
            boolean flag = this.doChildAreaList(topIdAreaList, childAllList, customerAreaEo.getCode());
            if (!flag) continue;
        }
        return false;
    }
}

