/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EasCustomerOrgRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EasCustomerOrgRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EasCustomerOrgRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EasCustomerOrgRelationEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.customer.biz.service.IEasCustomerOrgRelationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractEasCustomerOrgRelationServiceImpl
implements IEasCustomerOrgRelationService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractEasCustomerOrgRelationServiceImpl.class);
    @Resource
    private EasCustomerOrgRelationDas easCustomerOrgRelationDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public Long addEasCustomerOrgRelation(EasCustomerOrgRelationReqDto addReqDto) {
        EasCustomerOrgRelationEo easCustomerOrgRelationEo = new EasCustomerOrgRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)easCustomerOrgRelationEo);
        this.easCustomerOrgRelationDas.insert((BaseEo)easCustomerOrgRelationEo);
        return easCustomerOrgRelationEo.getId();
    }

    @Override
    public void modifyEasCustomerOrgRelation(EasCustomerOrgRelationReqDto modifyReqDto) {
        EasCustomerOrgRelationEo easCustomerOrgRelationEo = new EasCustomerOrgRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)easCustomerOrgRelationEo);
        this.easCustomerOrgRelationDas.updateSelective((BaseEo)easCustomerOrgRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEasCustomerOrgRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.easCustomerOrgRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public EasCustomerOrgRelationRespDto queryById(Long id) {
        EasCustomerOrgRelationEo easCustomerOrgRelationEo = (EasCustomerOrgRelationEo)this.easCustomerOrgRelationDas.selectByPrimaryKey(id);
        EasCustomerOrgRelationRespDto easCustomerOrgRelationRespDto = new EasCustomerOrgRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)easCustomerOrgRelationEo, (BaseVo)easCustomerOrgRelationRespDto);
        return easCustomerOrgRelationRespDto;
    }

    @Override
    public PageInfo<EasCustomerOrgRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EasCustomerOrgRelationReqDto easCustomerOrgRelationReqDto = (EasCustomerOrgRelationReqDto)JSON.parseObject((String)filter, EasCustomerOrgRelationReqDto.class);
        EasCustomerOrgRelationEo easCustomerOrgRelationEo = new EasCustomerOrgRelationEo();
        DtoHelper.dto2Eo((BaseVo)easCustomerOrgRelationReqDto, (BaseEo)easCustomerOrgRelationEo);
        PageInfo eoPageInfo = this.easCustomerOrgRelationDas.selectPage((BaseEo)easCustomerOrgRelationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EasCustomerOrgRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void syncEasCustomerOrgRelation(List<EasCustomerOrgRelationReqDto> reqDtoList) {
        logger.info("\u540c\u6b65EAS\u5ba2\u6237\u7ec4\u7ec7\u79df\u6237\u5173\u7cfb\uff1a{}", (Object)JSON.toJSONString(reqDtoList));
        List customerCodes = reqDtoList.stream().map(EasCustomerOrgRelationReqDto::getCustomerCode).collect(Collectors.toList());
        List easCustomerOrgRelationRespDtoList = this.easCustomerOrgRelationDas.queryCustomerList(customerCodes);
        if (CollectionUtil.isEmpty((Collection)easCustomerOrgRelationRespDtoList)) {
            logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5ba2\u6237\u4fe1\u606f");
            return;
        }
        Map<String, Long> easCustomerOrgRelationRespDtoMap = easCustomerOrgRelationRespDtoList.stream().collect(Collectors.toMap(EasCustomerOrgRelationRespDto::getCustomerCode, EasCustomerOrgRelationRespDto::getCustomerId, (k1, k2) -> k1));
        List tenantCodes = reqDtoList.stream().map(EasCustomerOrgRelationReqDto::getTenantCode).collect(Collectors.toList());
        List organizationDtoList = (List)RestResponseHelper.extractData((RestResponse)this.organizationQueryApi.queryListByOrgCode(Long.valueOf(1254039287584232622L), tenantCodes));
        if (CollectionUtil.isEmpty((Collection)organizationDtoList)) {
            logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f");
            return;
        }
        Map<String, Long> organizationDtoMap = organizationDtoList.stream().collect(Collectors.toMap(OrganizationDto::getCode, OrganizationDto::getId, (k1, k2) -> k1));
        reqDtoList.forEach(dto -> {
            dto.setCustomerId((Long)easCustomerOrgRelationRespDtoMap.get(dto.getCustomerCode()));
            dto.setOrgId((Long)organizationDtoMap.get(dto.getTenantCode()));
        });
        this.easCustomerOrgRelationDas.addAndUpdEasCustomerOrgRelation(reqDtoList);
    }
}

