/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.core.util.CronExpression;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsDealEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerCheckConfigReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerCheckConfigRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerCheckConfigService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerCheckConfigDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerCheckConfigEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerCheckConfigServiceImpl
implements ICustomerCheckConfigService {
    private static final Logger log = LoggerFactory.getLogger(CustomerCheckConfigServiceImpl.class);
    @Resource
    private CustomerCheckConfigDas customerCheckConfigDas;

    @Override
    public Long addCustomerCheckConfig(CustomerCheckConfigReqDto addReqDto) {
        CustomerCheckConfigEo customerCheckConfigEo = new CustomerCheckConfigEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerCheckConfigEo);
        this.customerCheckConfigDas.insert((BaseEo)customerCheckConfigEo);
        return customerCheckConfigEo.getId();
    }

    @Override
    public void modifyCustomerCheckConfig(CustomerCheckConfigReqDto modifyReqDto) {
        CustomerCheckConfigEo customerCheckConfigEo = new CustomerCheckConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerCheckConfigEo);
        this.customerCheckConfigDas.updateSelective((BaseEo)customerCheckConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerCheckConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerCheckConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerCheckConfigRespDto queryById(Long id) {
        CustomerCheckConfigEo customerCheckConfigEo = (CustomerCheckConfigEo)this.customerCheckConfigDas.selectByPrimaryKey(id);
        CustomerCheckConfigRespDto customerCheckConfigRespDto = new CustomerCheckConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)customerCheckConfigEo, (BaseVo)customerCheckConfigRespDto);
        return customerCheckConfigRespDto;
    }

    @Override
    public PageInfo<CustomerCheckConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerCheckConfigReqDto customerCheckConfigReqDto = (CustomerCheckConfigReqDto)JSON.parseObject((String)filter, CustomerCheckConfigReqDto.class);
        CustomerCheckConfigEo customerCheckConfigEo = new CustomerCheckConfigEo();
        DtoHelper.dto2Eo((BaseVo)customerCheckConfigReqDto, (BaseEo)customerCheckConfigEo);
        PageInfo eoPageInfo = this.customerCheckConfigDas.selectPage((BaseEo)customerCheckConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerCheckConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerCheckConfigRespDto queryEnableConfig() {
        CustomerCheckConfigRespDto customerCheckConfigReqDto = new CustomerCheckConfigRespDto();
        try {
            CustomerCheckConfigEo customerCheckConfig = (CustomerCheckConfigEo)this.customerCheckConfigDas.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).eq(CustomerCheckConfigEo::getValid, (Object)IsDealEnum.NOT_DEAL.getCode()));
            DtoHelper.eo2Dto((BaseEo)customerCheckConfig, (BaseVo)customerCheckConfigReqDto);
            boolean in = cn.hutool.core.date.DateUtil.isIn((Date)cn.hutool.core.date.DateUtil.date(), (Date)customerCheckConfigReqDto.getControlStartTime(), (Date)customerCheckConfigReqDto.getControlEndTime());
            customerCheckConfigReqDto.setEnable(in ? IsDealEnum.IS_DEAL.getCode() : IsDealEnum.NOT_DEAL.getCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return customerCheckConfigReqDto;
    }

    public Date calculateControlEndTime(CronExpression cronExpression, String requestDate, Date date) {
        Date nextValidTimeAfter = cronExpression.getNextValidTimeAfter(date);
        String nextValidTime = DateUtil.formatDate((DatePattern)DatePattern.MONTH_PATTERN, (Date)nextValidTimeAfter);
        if (nextValidTime.equals(requestDate)) {
            return this.calculateControlEndTime(cronExpression, requestDate, nextValidTimeAfter);
        }
        return date;
    }

    @Override
    public void saveCustomerCheckConfig(CustomerCheckConfigReqDto saveReqDto) {
        CustomerCheckConfigEo customerCheckConfig = (CustomerCheckConfigEo)this.customerCheckConfigDas.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEo::getDr, (Object)0)).eq(CustomerCheckConfigEo::getValid, (Object)IsDealEnum.NOT_DEAL.getCode()));
        if (ObjectUtils.isNotEmpty((Object)customerCheckConfig)) {
            customerCheckConfig.setValid(IsDealEnum.IS_DEAL.getCode());
            customerCheckConfig.setDr(1);
            this.customerCheckConfigDas.update((BaseEo)customerCheckConfig);
            log.info("\u5220\u9664\u4eba\u5e97config\u914d\u7f6e customerCheckConfig:{}", (Object)JSON.toJSONString((Object)customerCheckConfig));
        }
        CustomerCheckConfigEo eo = new CustomerCheckConfigEo();
        DtoHelper.dto2Eo((BaseVo)saveReqDto, (BaseEo)eo);
        eo.setValid(IsDealEnum.NOT_DEAL.getCode());
        this.customerCheckConfigDas.insert((BaseEo)eo);
        log.info("\u65b0\u589e-> \u4eba\u5e97config\u914d\u7f6e eo:{}", (Object)JSON.toJSONString((Object)eo));
    }
}

