/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreTypeEnum;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StoreHelper {
    private static final Logger log = LoggerFactory.getLogger(StoreHelper.class);
    private static final Long DEFAULT_VAL = 1L;
    private static final Integer CODE_LENGTH = 7;
    private static final String PLACEHOLDER = "0";
    private static final String PRIMACY = "1";
    private static final String STORE_NO = "storeNo";
    @Resource
    private ICacheService cacheService;

    public String generateStoreCode(String storeType) {
        StoreTypeEnum storeTypeEnum = StoreTypeEnum.fromName((String)storeType);
        Long shopCount = this.cacheService.incr(STORE_NO);
        StringBuilder shopNumber = new StringBuilder(String.valueOf(ObjectUtils.isEmpty((Object)shopCount) ? DEFAULT_VAL : shopCount));
        if (shopNumber.length() < CODE_LENGTH) {
            int completion = CODE_LENGTH - shopNumber.length();
            for (int i = 1; i < completion; ++i) {
                shopNumber.insert(0, PLACEHOLDER);
            }
            shopNumber.insert(0, PRIMACY);
        }
        String storeCode = null == storeTypeEnum ? "" : storeTypeEnum.getCode();
        log.info(" [createStoreCode] \u751f\u6210\u95e8\u5e97\u7f16\u7801 => {} ", (Object)(storeCode + shopNumber.toString()));
        return storeCode + shopNumber.toString();
    }
}

