/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.schedule;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.customer.api.constants.IsDealEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreModifyRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreModifyRecordRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreModifyRecordService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="bizModifyStoreChangeSellerRelateSchedule")
@Scope(value="prototype")
public class BizModifyStoreChangeSellerRelateSchedule
extends SingleTupleScheduleEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(BizModifyStoreChangeSellerRelateSchedule.class);
    @Resource
    private IStoreModifyRecordService storeModifyRecordService;
    @Resource
    private IStoreSellerRelateService storeSellerRelateService;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        try {
            StoreModifyRecordReqDto storeModifyRecordReqDto = new StoreModifyRecordReqDto();
            storeModifyRecordReqDto.setIsDeal(IsDealEnum.NOT_DEAL.getCode());
            List<StoreModifyRecordRespDto> storeModifyRecordRespDtos = this.storeModifyRecordService.queryList(storeModifyRecordReqDto);
            if (CollectionUtils.isNotEmpty(storeModifyRecordRespDtos)) {
                this.storeSellerRelateService.updateRelateByModifyRecord(storeModifyRecordRespDtos);
                storeModifyRecordRespDtos.forEach(c -> {
                    c.setIsDeal(IsDealEnum.IS_DEAL.getCode());
                    StoreModifyRecordReqDto modifyRecordReqDto = new StoreModifyRecordReqDto();
                    CubeBeanUtils.copyProperties((Object)modifyRecordReqDto, (Object)c, (String[])new String[0]);
                    this.storeModifyRecordService.modifyStoreModifyRecord(modifyRecordReqDto);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }
}

