/**
 * @(#)CsOutResultOrderApi.java 1.0 2021/12/29 11:13
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.RollbackDeliveryOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * CsOutResultOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:13
 * @since 1.0.0
 */
@Api(tags = {"CsOutResultOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csOutResultOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsOutResultOrderApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsOutResultOrderAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsOutResultOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);


    @PostMapping(value = "/sendBack", produces = "application/json")
    @ApiOperation(value = "营销云 发货回传;生成发货结果单", notes = "发货回传")
    RestResponse<String> sendBack(@Validated @RequestBody TcbjResGenReqDto reqDto);

    /**
     * 根据发货通知单回滚库存 [仅针对与进销存库存存在差异修数]
     * @param rollbackDeliveryOrderReqDto
     * @return
     */
    @PostMapping(value = "/rollbackOutResultOrder")
    @ApiOperation(value = "根据发货通知单回滚库存", notes = "根据发货通知单回滚库存 [仅针对与进销存库存存在差异修数]")
    RestResponse<Void> rollbackOutResultOrder(@RequestBody RollbackDeliveryOrderReqDto rollbackDeliveryOrderReqDto);

}