/**
 * @(#)CsPhysicsWarehouseApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
* CsPhysicsWarehouseApi
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@Api(tags = {"CsPhysicsWarehouse接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csPhysicsWarehouse", url = "${yundt.cube.center.inventory.api:}")
public interface ICsPhysicsWarehouseApi {

    /**
     * 添加
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsPhysicsWarehouseAddReqDto addReqDto);

    /**
     * 修改
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsPhysicsWarehouseUpdateReqDto updateReqDto);

    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    /**
     * 初始化物理仓
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "/initPhysicsWarehouse", produces = "application/json")
    @ApiOperation(value = "初始化", notes = "初始化")
    RestResponse<Long> initPhysicsWarehouse(@Validated @RequestBody CsPhysicsWarehouseAddReqDto addReqDto);


    @PostMapping(value = "/batch/initPhysicsWarehouseByOrganizationIdList", produces = "application/json")
    @ApiOperation(value = "批量根据组织id初始化仓库", notes = "批量根据组织id初始化仓库")
    RestResponse<Long> initPhysicsWarehouseByOrganizationIdList(@RequestBody List<Long> organizationIdList);

    /**
     * 更新物理仓
     * 针对汤臣V1.0的业务，营销云发起的，同步更新中台的仓库数据
     * @param id
     * @param updateReqDto
     */
    @PostMapping(value = "/{id}/updatePhysicsWarehouse", produces = "application/json")
    @ApiOperation(value = "更新物理仓，针对汤臣V1.0的业务，营销云发起的，同步更新中台的仓库数据", notes = "更新物理仓，针对汤臣V1.0的业务，营销云发起的，同步更新中台的仓库数据")
    RestResponse<Void> updatePhysicsWarehouse(@PathVariable("id") Long id, @Validated @RequestBody CsPhysicsWarehouseUpdateReqDto updateReqDto);

}