package com.dtyunxi.yundt.cube.center.inventory.dto.inventory;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 发送 发货/收货通知单 MQ订单消息Dto
 */
@Data
public class MqContentOrderDto {

    /**
     * 租户ID
     */
    private String orgId;

    /**
     * 客户ID
     */
    private String applyerId;

    /**
     * 客户外围系统编码
     */
    private String extCusCode;

    /**
     * 订单号
     */
    private String no;

    /**
     * 订单日期
     */
    private Date dt;

    /**
     * 收货地址
     */
    private String shippingAddress;

    /**
     * 收货联系人电话
     */
    private String phone;

    /**
     * 收货联系人
     */
    private String contacts;

    /**
     * 审批人
     */
    private String approverId;

    /**
     * 客户名称
     */
    private String applyerName;

    /**
     * 总金额
     */
    private Double totalMoney;

    /**
     * 来源系统
     */
    private String srcSystem;

    /**
     * 订单备注
     */
    private String remark;

    /**
     * 发货仓库
     */
    private String warehouseCode;

    /**
     * 订单明细
     */
    private List<MqContentOrderDetailDto> orderApplyItems;

    @ApiModelProperty(name = "bizType", value = "业务类型：S01：普通销售单（为空时默认），S02：下级租户采购")
    private String bizType;

    @ApiModelProperty(name = "subTenantId", value = "下级租户id")
    private String subTenantId;

    @ApiModelProperty(name = "secondSaleReturnOrder", value = "下级退货进销存单号")
    private String secondSaleReturnOrder;

    /*
     * 下单人，中文名称，非用户名或用户id
     */
    private String orderPersonName;

    private String fullApplyerName;

    private String uscc;
}
