package com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 复核货品明细信息
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/11/16 4:09 下午
 */
public class TcbjReCheckDetailReqDto implements Serializable {

    /**
     * 货品编码
     */
    @ApiModelProperty(name = "cargoCode", value = "货品编码")
    private String cargoCode;

    /**
     * 货品批次
     */
    @ApiModelProperty(name = "batch", value = "货品批次")
    private String batch;

    /**
     * 退货数量
     */
    @ApiModelProperty(name = "refundNum", value = "退货数量")
    private BigDecimal refundNum;

    /**
     * 仓库编码
     */
    @ApiModelProperty(name = "warehouseCode", value = "仓库编码")
    private String warehouseCode;

    /**
     * 过期日期
     */
    @ApiModelProperty(name = "expireTime")
    private Date expireTime;

    /**
     * 生产日期
     */
    @ApiModelProperty(name = "produceTime")
    private Date produceTime;

    public TcbjReCheckDetailReqDto() {
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public BigDecimal getRefundNum() {
        return refundNum;
    }

    public void setRefundNum(BigDecimal refundNum) {
        this.refundNum = refundNum;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Date getExpireTime() {
        return expireTime;
    }

    public void setExpireTime(Date expireTime) {
        this.expireTime = expireTime;
    }

    public Date getProduceTime() {
        return produceTime;
    }

    public void setProduceTime(Date produceTime) {
        this.produceTime = produceTime;
    }
}
