package com.dtyunxi.yundt.cube.center.inventory.enums;

import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 * 活动库存的活动是否正在进行中
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 2:44 下午
 */
public enum CsActivityInventoryStatusEnum {

    /** 进行中 **/
    ONGOING("ongoing","进行中"),

    /** 已结束 **/
    TERMINATE("terminate","已结束"),

    ;

    /** 编码 **/
    private String code;

    /** 描述 **/
    private String desc;

    CsActivityInventoryStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    /**
     * 根据code获取
     *
     * @param code
     * @return
     */
    public static CsActivityInventoryStatusEnum getByCode(String code){
        if(StringUtils.isBlank(code)){
            return null;
        }
        return Arrays.asList(CsActivityInventoryStatusEnum.values()).stream().filter(e->{return e.getCode().equals(code);}).findAny().orElse(null);
    }
}
