package com.dtyunxi.yundt.cube.center.inventory.enums;

/**
 * 单据状态变换流程
 *
 * @author jingran
 * @version 1.0
 * @Date 2021/12/30 7:20 下午
 */
public enum CsDocumentActionProcessEnum {

    //正向
    CANCEL_PAY(CsOrderStatusEnum.INIT.getCode(), CsDocumentActionEnum.CANCEL_PAY.getCode(), CsOrderStatusEnum.DELIVERY_CANCEL.getCode(), "（草稿）取消支付(已取消)"),
    SUCCESS_PAY(CsOrderStatusEnum.INIT.getCode(), CsDocumentActionEnum.SUCCESS_PAY.getCode(), CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode(), "（草稿）支付成功(待审核)"),
    AUDIT_PASS(CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode(), CsDocumentActionEnum.AUDIT_PASS.getCode(), CsOrderStatusEnum.DELIVERY_OUT.getCode(), "（待审核）审核通过（出库）"),
    AUDIT_ADJUST(CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode(), CsDocumentActionEnum.AUDIT_ADJUST.getCode(), CsOrderStatusEnum.ADJUST_REFUSE.getCode(), "（待审核）审核不通过（审批拒绝）"),
    PAY_CANCEL(CsOrderStatusEnum.DELIVERY_WAIT_AUDIT.getCode(), CsDocumentActionEnum.CANCEL_PAY.getCode(), CsOrderStatusEnum.DELIVERY_CANCEL.getCode(), "（待审核）支付完成后取消（已取消）"),
    OUTING(CsOrderStatusEnum.DELIVERY_OUT.getCode(), CsDocumentActionEnum.OUTING.getCode(), CsOrderStatusEnum.DELIVERY_OUT_ING.getCode(), "（出库）预占状态变更（出库中）"),
    SUCCESS_OUT(CsOrderStatusEnum.DELIVERY_OUT_ING.getCode(), CsDocumentActionEnum.SUCCESS_OUT.getCode(), CsOrderStatusEnum.DELIVERY_OUT_FINISH.getCode(), "（出库中）出库成功（已完成）"),
    CANCEL_OUT(CsOrderStatusEnum.DELIVERY_OUT_ING.getCode(), CsDocumentActionEnum.CANCEL_OUT.getCode(), CsOrderStatusEnum.DELIVERY_CANCEL.getCode(), "出库取消(已取消)"),
    REVERSE_AUDIT(CsOrderStatusEnum.DELIVERY_OUT.getCode(), CsDocumentActionEnum.REVERSE_AUDIT.getCode(), CsOrderStatusEnum.ADJUST_REFUSE.getCode(), "反审核已经通过的订单(审批拒绝)"),
    REVERSE_AUDIT2(CsOrderStatusEnum.DELIVERY_OUT_ING.getCode(), CsDocumentActionEnum.REVERSE_AUDIT.getCode(), CsOrderStatusEnum.ADJUST_REFUSE.getCode(), "反审核已经通过的订单(审批拒绝)"),
    REVERSE_ORDER_PASS(CsOrderStatusEnum.ADJUST_REFUSE.getCode(), CsDocumentActionEnum.AUDIT_PASS.getCode(), CsOrderStatusEnum.DELIVERY_OUT.getCode(), "反审核已经通过的订单再次通过(出库)"),
    REVERSE_ORDER_NO_PASS(CsOrderStatusEnum.ADJUST_REFUSE.getCode(), CsDocumentActionEnum.AUDIT_ADJUST.getCode(), CsOrderStatusEnum.DELIVERY_CANCEL.getCode(), "审核拒绝反审核中的订单(已取消)"),
    REVERSE_ORDER_NO_PASS2(CsOrderStatusEnum.ADJUST_REFUSE.getCode(), CsDocumentActionEnum.CANCEL_PAY.getCode(), CsOrderStatusEnum.DELIVERY_CANCEL.getCode(), "取消反审核中的订单(已取消)"),

    //逆向
    AGAIN_AUDIT_REFUSE(CsOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode(), CsDocumentActionEnum.REVERSE_AUDIT.getCode(), CsOrderStatusEnum.RECEIVE_CANCEL.getCode(), "反审核已通过的售后单(已取消)"),
    REVERSE_AUDIT_PASS(CsOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode(), CsDocumentActionEnum.REVERSE_AUDIT_PASS.getCode(), CsOrderStatusEnum.RECEIVE_FINISH.getCode(), "复核通过"),
    REVERSE_AUDIT_REFUSE(CsOrderStatusEnum.RECEIVE_WAIT_RECEIVE.getCode(), CsDocumentActionEnum.REVERSE_AUDIT_REFUSE.getCode(), CsOrderStatusEnum.RECEIVE_CANCEL.getCode(), "复核不通过");


    CsDocumentActionProcessEnum(String preCode, String action, String suffixCode, String desc) {
        this.preCode = preCode;
        this.action = action;
        this.suffixCode = suffixCode;
        this.desc = desc;
    }

    private String preCode;
    private String action;
    private String suffixCode;
    private String desc;

    public String getPreCode() {
        return preCode;
    }

    public void setPreCode(String preCode) {
        this.preCode = preCode;
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getSuffixCode() {
        return suffixCode;
    }

    public void setSuffixCode(String suffixCode) {
        this.suffixCode = suffixCode;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getSuffixByAction(String preCode, String action) {
        for (CsDocumentActionProcessEnum value : CsDocumentActionProcessEnum.values()) {
            if (value.preCode.equals(preCode) && value.action.equals(action)) {
                return value.suffixCode;
            }
        }
        return null;
    }
}
