/**
 * @(#)CsLogicWarehouseQueryApi.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicSupplyWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsLogicWarehouseQueryApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:12
 * @since 1.0.0
 */
@Api(tags = {"CsLogicWarehouse接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csLogicWarehouse", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicWarehouseQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsLogicWarehouseRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询逻辑仓库", notes = "分页查询")
    RestResponse<PageInfo<CsLogicWarehouseRespDto>> queryByPage(@Validated @RequestBody CsLogicWarehouseQueryDto queryDto);

    /**
     * 参数查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "查询仓库集合", notes = "查询仓库集合")
    RestResponse<List<CsLogicWarehouseRespDto>> queryByParam(@Validated @RequestBody CsLogicWarehouseQueryDto queryDto);

    @PostMapping(value = "/supply-page", produces = "application/json")
    @ApiOperation(value = "分页查询主仓+分仓仓库", notes = "分页查询")
    RestResponse<PageInfo<CsLogicSupplyWarehouseRespDto>> querySupplyByPage(@Validated @RequestBody CsLogicWarehouseQueryDto queryDto);


}