/**
 * @(#)CsLogicInventoryTotalQueryApi.java 1.0 2022/01/12 09:18
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPageQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryTotalBatchQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* CsLogicInventoryTotalQueryApi
*
* @author jingran
* @Date: 2022/01/12 09:18
* @since 1.0.0
*/
@Api(tags = {"CsLogicInventoryTotal接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csLogicInventoryTotal", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicInventoryTotalQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsLogicInventoryTotalRespDto> queryByPrimaryKey(@PathVariable("id") Long id);


    @PostMapping(value = "/query/warehouse/totalInventory", produces = "application/json")
    @ApiOperation(value = "批量查询指定仓库货品（总）库存", notes = "批量查询指定仓库货品（总）库存")
    RestResponse<List<CsLogicInventoryTotalRespDto>> queryWarehouseInventory(@RequestBody CsLogicInventoryTotalBatchQueryDto batchQueryDto);

    @PostMapping(value = "/query/warehouse/totalInventoryPage", produces = "application/json")
    @ApiOperation(value = "分页查询指定仓库货品（总）库存", notes = "分页查询指定仓库货品（总）库存")
    RestResponse<PageInfo<CsLogicInventoryTotalRespDto>> queryWarehouseInventoryPageInfo(@RequestBody CsInventoryPageQueryReqDto inventoryPageQueryReqDto);

}