package com.dtyunxi.yundt.cube.center.inventory.api.order.recipt;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.SimpleRequestDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjNotiGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.resp.TcbjResDetailCargoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.TcbjReCheckReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.InDraOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.recipt.*;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author shuidi
 */
@Api(tags = {"收货单接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}", path = "/v1/order-recipt", url = "${yundt.cube.center.inventory.api:}")
public interface ITcbjReciptApi {
    @PostMapping(value = "/noti-page", produces = "application/json")
    @ApiOperation(value = "前端 分页收货通知单查询", notes = "分页收货通知单查询")
    RestResponse<PageInfo<TcbjReciptNotiRespDto>> notiPage(@Validated @RequestBody TcbjReciptNotiReqDto queryDto);

    @PostMapping(value = "/noti-detail", produces = "application/json")
    @ApiOperation(value = "前端 收货通知单详细", notes = "收货通知单详细")
    RestResponse<TcbjReciptNotiDetailRespDto> notiDetail(@Validated @RequestBody SimpleRequestDto dto);

    @PostMapping(value = "/res-page", produces = "application/json")
    @ApiOperation(value = "前端 分页收货结果单查询", notes = "分页收货结果单查询")
    RestResponse<PageInfo<TcbjReciptResRespDto>> resPage(@Validated @RequestBody TcbjReciptResReqDto queryDto);

    @PostMapping(value = "/res-detail", produces = "application/json")
    @ApiOperation(value = "前端 收货结果单详细", notes = "收货结果单详细")
    RestResponse<TcbjReciptResDetailRespDto> resDetail(@Validated @RequestBody SimpleRequestDto dto);

    @PostMapping(value = "send", produces = "application/json")
    @ApiOperation(value = "订单中心 收货", notes = "收货")
    RestResponse<String> send(@Validated @RequestBody TcbjNotiGenReqDto reqDto);

    @PostMapping(value = "sendback", produces = "application/json")
    @ApiOperation(value = "营销云 收货回传", notes = "收货回传")
    RestResponse<String> sendback(@Validated @RequestBody TcbjResGenReqDto reqDto);

    @PostMapping(value = "cancel", produces = "application/json")
    @ApiOperation(value = "订单中心 取消收货通知单", notes = "取消收货通知单")
    RestResponse<String> cancel(@Validated @RequestBody SimpleRequestDto dto);

    @PostMapping(value = "/inNum", produces = "application/json")
    @ApiOperation(value = "订单中心 入库数", notes = "入库数")
    RestResponse<List<TcbjResDetailCargoRespDto>> inNum(@Validated @RequestBody SimpleRequestDto dto);

    @PostMapping(value = "/audit", produces = "application/json")
    @ApiOperation(value = "订单中心 审核收货通知单", notes = "审核收货通知单")
    RestResponse<String> audit(@Validated @RequestBody TcbjReciptAuReqDto dto);

    @PostMapping(value = "/inOrder/list", produces = "application/json")
    @ApiOperation(value = "前端 查询单据数据", notes = "查询单据数据")
    RestResponse<List<InDraOrderRespDto>> inOrderQuery(@Validated @RequestBody SimpleRequestDto dto);

    /**
     * 退货回传，修改售后通知单状态
     * 退货单推送到营销云后，营销云通过扫描枪进行扫描，回传中台结果，
     * 但是不进行直接入库，之前是直接进行入库的，目前是改造成修改收货通知单
     * 的状态为"待收货"
     *
     * @param reqDto
     * @return
     */
    @PostMapping(value = "/refundModifyNotifyStatus", produces = "application/json")
    @ApiOperation(value = "退货回传，修改收货通知单的状态", notes = "退货回传，修改收货通知单的状态")
    RestResponse<Void> refundModifyNotifyStatus(@Validated @RequestBody TcbjResGenReqDto reqDto);

    /**
     * 复核入库
     * 复核入库时，需要操作的是，在页面上选择的那些允许进行入库操作的货品
     *
     * @param reCheckReqDto  请求参数
     */
    @PostMapping(value = "/reCheckInInventory",produces = "application/json")
    @ApiOperation(value = "复核入库",notes = "复核入库")
    RestResponse<Void> reCheckInInventory(@RequestBody TcbjReCheckReqDto reCheckReqDto);

}
