package com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log;

import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.BasePageDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;

/**
 * 库存流水分页查询请求DTO
 *
 * @author jingran
 * @version 1.0
 * @Date 2022/1/16 10:41 下午
 */
@ApiModel(value="CsInventoryLogPageQueryReqDto",description = "库存流水分页查询请求DTO")
public class CsInventoryLogPageQueryReqDto extends BasePageDto implements Serializable {

    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;

    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;

    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;

    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;

    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;

    /** 业务单据类型 */
    @ApiModelProperty(name="sourceType",value = "业务单据类型")
    private String sourceType;

    /** 库存流水类型  即时库存-balance  可用库存-available  锁定库存-preempt */
    @ApiModelProperty(name="inventoryType",value = "库存类型,即时库存-balance  可用库存-available  锁定库存-preempt")
    private String inventoryType;

    /** 前置单号 */
    @ApiModelProperty(name="sourceNo",value = "前置单号")
    private String sourceNo;

    /** 变动查询起始时间 */
    @ApiModelProperty(name="beginChangeTime",value = "变动查询起始时间 格式: yyyy-MM-dd HH:mm:ss")
    private String beginChangeTime;

    /** 变动查询结束时间 */
    @ApiModelProperty(name="endChangeTime",value = "变动查询起始时间 格式: yyyy-MM-dd HH:mm:ss")
    private String endChangeTime;

    @ApiModelProperty(name="currentUserWarehouseIds",value = "当前用户对应仓库id")
    private List<Long> currentUserWarehouseIds;

    public CsInventoryLogPageQueryReqDto() {
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getInventoryType() {
        return inventoryType;
    }

    public void setInventoryType(String inventoryType) {
        this.inventoryType = inventoryType;
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public String getBeginChangeTime() {
        return beginChangeTime;
    }

    public void setBeginChangeTime(String beginChangeTime) {
        this.beginChangeTime = beginChangeTime;
    }

    public String getEndChangeTime() {
        return endChangeTime;
    }

    public void setEndChangeTime(String endChangeTime) {
        this.endChangeTime = endChangeTime;
    }

    public List<Long> getCurrentUserWarehouseIds() {
        return currentUserWarehouseIds;
    }

    public void setCurrentUserWarehouseIds(List<Long> currentUserWarehouseIds) {
        this.currentUserWarehouseIds = currentUserWarehouseIds;
    }
}
