/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.IInventoryItemExtendService;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.InventoryItemExtendDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.InventoryItemExtendEo;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.InventoryItemExtendReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.InventoryItemExtendRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class InventoryItemExtendServiceImpl
implements IInventoryItemExtendService {
    @Resource
    private InventoryItemExtendDas inventoryItemExtendDas;

    @Override
    public Long addInventoryItemExtend(InventoryItemExtendReqDto addReqDto) {
        InventoryItemExtendEo inventoryItemExtendEo = new InventoryItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inventoryItemExtendEo);
        this.inventoryItemExtendDas.insert((BaseEo)inventoryItemExtendEo);
        return inventoryItemExtendEo.getId();
    }

    @Override
    public void modifyInventoryItemExtend(InventoryItemExtendReqDto modifyReqDto) {
        InventoryItemExtendEo inventoryItemExtendEo = new InventoryItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inventoryItemExtendEo);
        this.inventoryItemExtendDas.updateSelective((BaseEo)inventoryItemExtendEo);
    }

    @Override
    public void saveOrUpdateInventoryItemExtend(InventoryItemExtendReqDto modifyReqDto) {
        InventoryItemExtendEo inventoryItemExtendEo = new InventoryItemExtendEo();
        inventoryItemExtendEo.setItemCode(modifyReqDto.getItemCode());
        inventoryItemExtendEo.setBatch(modifyReqDto.getBatch());
        InventoryItemExtendEo inventoryItemExtend = (InventoryItemExtendEo)this.inventoryItemExtendDas.selectOne((BaseEo)inventoryItemExtendEo);
        if (ObjectUtils.isEmpty((Object)inventoryItemExtend)) {
            this.addInventoryItemExtend(modifyReqDto);
        } else {
            inventoryItemExtend.setExpireTime(modifyReqDto.getExpireTime());
            inventoryItemExtend.setProduceTime(modifyReqDto.getProduceTime());
            this.inventoryItemExtendDas.update((BaseEo)inventoryItemExtend);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInventoryItemExtend(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inventoryItemExtendDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InventoryItemExtendRespDto queryById(Long id) {
        InventoryItemExtendEo inventoryItemExtendEo = (InventoryItemExtendEo)this.inventoryItemExtendDas.selectByPrimaryKey(id);
        InventoryItemExtendRespDto inventoryItemExtendRespDto = new InventoryItemExtendRespDto();
        DtoHelper.eo2Dto((BaseEo)inventoryItemExtendEo, (BaseVo)inventoryItemExtendRespDto);
        return inventoryItemExtendRespDto;
    }

    @Override
    public List<InventoryItemExtendRespDto> queryInventoryItemExtend(String filter) {
        InventoryItemExtendReqDto inventoryItemExtendReqDto = (InventoryItemExtendReqDto)JSON.parseObject((String)filter, InventoryItemExtendReqDto.class);
        InventoryItemExtendEo inventoryItemExtendEo = new InventoryItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)inventoryItemExtendReqDto, (BaseEo)inventoryItemExtendEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)inventoryItemExtendReqDto.getItemCodes())) {
            sqlFilters.add(SqlFilter.in((String)"item_code", (Object)inventoryItemExtendReqDto.getItemCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)inventoryItemExtendReqDto.getBatchs())) {
            sqlFilters.add(SqlFilter.in((String)"batch", (Object)inventoryItemExtendReqDto.getBatchs()));
        }
        List inventoryItemExtends = this.inventoryItemExtendDas.select((BaseEo)inventoryItemExtendEo);
        ArrayList<InventoryItemExtendRespDto> dtoList = new ArrayList<InventoryItemExtendRespDto>();
        DtoHelper.eoList2DtoList((Collection)inventoryItemExtends, dtoList, InventoryItemExtendRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<InventoryItemExtendRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InventoryItemExtendReqDto inventoryItemExtendReqDto = (InventoryItemExtendReqDto)JSON.parseObject((String)filter, InventoryItemExtendReqDto.class);
        InventoryItemExtendEo inventoryItemExtendEo = new InventoryItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)inventoryItemExtendReqDto, (BaseEo)inventoryItemExtendEo);
        PageInfo eoPageInfo = this.inventoryItemExtendDas.selectPage((BaseEo)inventoryItemExtendEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, InventoryItemExtendRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

