/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.log.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.api.exception.InventoryExceptionCode;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.log.ICsInventoryLogQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.log.ICsInventoryLogService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryLogAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.log.CsInventoryLogUpdateReqDto;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryLogDomain;
import com.yunxi.dg.base.center.inventory.eo.InventoryLogEo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csInventoryLogService")
public class CsInventoryLogServiceImpl
implements ICsInventoryLogService {
    private static Logger logger = LoggerFactory.getLogger(CsInventoryLogServiceImpl.class);
    @Autowired
    private IInventoryLogDomain inventoryLogDomain;
    @Autowired
    private ICsInventoryLogQueryService csInventoryLogQueryService;

    @Override
    public Long add(CsInventoryLogAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryLogEo insertEo = new InventoryLogEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.inventoryLogDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsInventoryLogUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryLogEo updateEo = new InventoryLogEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.inventoryLogDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        InventoryLogEo eo = (InventoryLogEo)this.inventoryLogDomain.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, InventoryExceptionCode.RECORD_NOT_EXIST.getMsg());
        this.inventoryLogDomain.logicDeleteById(id);
    }
}

