/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.generate.GenerateCodeUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.AbstractCsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.CsBasicsOrderStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.ICsBasicsOrderOperateService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.basics.anno.CsBasicsOrderOperateStrategy;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsBusinessOrderCallBackUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.basics.CsOverchargeAdjustReqDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBusinessCallBackStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@CsBasicsOrderOperateStrategy(strategyName="receiveDeliveryNoticeOrder")
@Component(value="CsreceiveDeliveryNoticeOrderbasicsOrderStrategyService")
public class CsReceiveDeliveryNoticeOrderOperateServiceImpl
extends AbstractCsBasicsOrderOperateService {
    private static final Logger logger = LoggerFactory.getLogger(CsReceiveDeliveryNoticeOrderOperateServiceImpl.class);
    @Resource
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;

    private Long generateReceiveDeliveryOrder(CsBasicsOrderReqDto orderReqDto) {
        ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        String documentNo = orderReqDto.getDocumentNo();
        if (StringUtils.isEmpty((CharSequence)documentNo)) {
            String generateCodeStrategy;
            if (BasicsOrderOperateTypeEnum.RECEIVE.getCode().equals(orderReqDto.getBasicsOrderOperateType())) {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.RECEIVE_NOTICE_ORDER.getCode();
                if (CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_IN.getCode().equals(orderReqDto.getBusinessType())) {
                    generateCodeStrategy = CsGenerateCodeStrategyEnum.IN_TRANSIT_RECEIVE_NOTICE_ORDER.getCode();
                }
                documentNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            } else {
                generateCodeStrategy = CsGenerateCodeStrategyEnum.DELIVERY_NOTICE_ORDER.getCode();
                if (CsPcpBusinessTypeEnum.IN_TRANSIT_ADJUSTMENT_OUT.getCode().equals(orderReqDto.getBusinessType())) {
                    generateCodeStrategy = CsGenerateCodeStrategyEnum.IN_TRANSIT_DELIVERY_NOTICE_ORDER.getCode();
                }
                documentNo = GenerateCodeUtils.getStrategy(generateCodeStrategy).getCode();
            }
            orderReqDto.setDocumentNo(documentNo);
        }
        receiveDeliveryNoticeOrderEo.setDocumentNo(documentNo);
        receiveDeliveryNoticeOrderEo.setRelevanceTableName(orderReqDto.getRelevanceTableName());
        receiveDeliveryNoticeOrderEo.setPreOrderNo(orderReqDto.getPreOrderNo());
        receiveDeliveryNoticeOrderEo.setRelevanceNo(orderReqDto.getRelevanceNo());
        receiveDeliveryNoticeOrderEo.setExternalOrderNo(orderReqDto.getExternalOrderNo());
        receiveDeliveryNoticeOrderEo.setBusinessType(orderReqDto.getBusinessType());
        receiveDeliveryNoticeOrderEo.setOrderStatus(orderReqDto.getOrderStatus());
        receiveDeliveryNoticeOrderEo.setSourceSystem(orderReqDto.getSourceSystem());
        if (CsRelevanceTableNameEnum.CS_BATCH_ADJUSTMENT_ORDER.getCode().equals(orderReqDto.getRelevanceTableName())) {
            receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(orderReqDto.getLogicWarehouseCode());
            receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(orderReqDto.getLogicWarehouseName());
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(orderReqDto.getPhysicsWarehouseCode());
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(orderReqDto.getPhysicsWarehouseName());
            receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseCode(orderReqDto.getLogicWarehouseCode());
            receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseName(orderReqDto.getLogicWarehouseName());
            receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseCode(orderReqDto.getPhysicsWarehouseCode());
            receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseName(orderReqDto.getPhysicsWarehouseName());
        } else if (BasicsOrderOperateTypeEnum.DELIVERY.getCode().equals(orderReqDto.getBasicsOrderOperateType())) {
            receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(orderReqDto.getLogicWarehouseCode());
            receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(orderReqDto.getLogicWarehouseName());
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(orderReqDto.getPhysicsWarehouseCode());
            receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(orderReqDto.getPhysicsWarehouseName());
            receiveDeliveryNoticeOrderEo.setWarehouseCode(orderReqDto.getLogicWarehouseCode());
        } else {
            receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseCode(orderReqDto.getInLogicWarehouseCode());
            receiveDeliveryNoticeOrderEo.setReceiveLogicWarehouseName(orderReqDto.getInLogicWarehouseName());
            receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseCode(orderReqDto.getInPhysicsWarehouseCode());
            receiveDeliveryNoticeOrderEo.setReceivePhysicsWarehouseName(orderReqDto.getInPhysicsWarehouseName());
            receiveDeliveryNoticeOrderEo.setWarehouseCode(orderReqDto.getInLogicWarehouseCode());
        }
        receiveDeliveryNoticeOrderEo.setOrderType(BasicsOrderOperateTypeEnum.DELIVERY.getCode().equals(orderReqDto.getBasicsOrderOperateType()) ? "delivery" : "receive");
        receiveDeliveryNoticeOrderEo.setTotalQuantity(orderReqDto.getTotalQuantity() == null ? BigDecimal.ZERO : orderReqDto.getTotalQuantity());
        receiveDeliveryNoticeOrderEo.setRemark(orderReqDto.getRemark());
        receiveDeliveryNoticeOrderEo.setExtension(orderReqDto.getExtension());
        receiveDeliveryNoticeOrderEo.setNoBatch(orderReqDto.getNoBatch());
        List reqDtoList = orderReqDto.getOrderBasicsDetailReqDtoList();
        ArrayList<ReceiveDeliveryNoticeOrderDetailEo> detailEoList = new ArrayList<ReceiveDeliveryNoticeOrderDetailEo>(reqDtoList.size());
        for (CsBasicsOrderDetailReqDto d : reqDtoList) {
            ReceiveDeliveryNoticeOrderDetailEo detailEo = new ReceiveDeliveryNoticeOrderDetailEo();
            detailEo.setSkuCode(d.getLongCode());
            detailEo.setSkuName(d.getItemName());
            detailEo.setBatch(d.getBatch());
            detailEo.setDocumentNo(documentNo);
            detailEo.setPlanQuantity(d.getQuantity());
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            BigDecimal doneQuantity = null != d.getDoneQuantity() ? d.getDoneQuantity() : BigDecimal.ZERO;
            detailEo.setDoneQuantity(doneQuantity);
            detailEo.setWaitQuantity(d.getQuantity().subtract(doneQuantity));
            detailEo.setExternalOrderNo(orderReqDto.getExternalOrderNo());
            detailEo.setPreOrderNo(orderReqDto.getPreOrderNo());
            detailEo.setRelevanceNo(orderReqDto.getRelevanceNo());
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEo.setItemStatus(CsPlannedOrderItemStatusEnum.COMMON.getCode());
            detailEo.setExtension(d.getExtension());
            detailEo.setPreOrderItemId(d.getTradeOrderItemId());
            detailEoList.add(detailEo);
        }
        this.receiveDeliveryNoticeOrderDomain.insert((BaseEo)receiveDeliveryNoticeOrderEo);
        this.receiveDeliveryNoticeOrderDetailDomain.insertBatch(detailEoList);
        CsBusinessCallBackStrategyEnum callBackStrategyEnum = CsBusinessCallBackStrategyEnum.getByTableName((String)orderReqDto.getRelevanceTableName());
        if (null == callBackStrategyEnum) {
            return receiveDeliveryNoticeOrderEo.getId();
        }
        ICsBusinessOrderCallBackService businessOrderCallBackService = CsBusinessOrderCallBackUtils.getBusinessOrderCallBackService(callBackStrategyEnum.getCode());
        CsOrderBusinessCallBackContext context = new CsOrderBusinessCallBackContext();
        context.setCsBasicsOrderReqDto(orderReqDto);
        context.setInFlag(Boolean.valueOf(false));
        if (BasicsOrderOperateTypeEnum.RECEIVE.getCode().equals(orderReqDto.getBasicsOrderOperateType())) {
            context.setInFlag(Boolean.valueOf(true));
        }
        context.setRelevanceNo(orderReqDto.getRelevanceNo());
        context.setDocumentNo(documentNo);
        businessOrderCallBackService.deliveryReceiveNoticeOrderCallBack(context);
        return receiveDeliveryNoticeOrderEo.getId();
    }

    @Override
    public void updateStatusByDocumentNo(String documentNo, String orderStatus) {
        ICsBasicsOrderOperateService inOutResultService = CsBasicsOrderStrategyUtils.getBasicsOrderOperateService("inOutResultOrder");
        CsOverchargeAdjustReqDto csOverchargeAdjustReqDto = new CsOverchargeAdjustReqDto();
        inOutResultService.relieveOvercharge(csOverchargeAdjustReqDto);
    }
}

