/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.adapter.tcbj;

import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.TransportConfirmInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.TransportOrderInfoReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.adapter.WmsApiImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderPushStatusPostbackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsPlannedCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsWmsInSendBackReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsOutSendBackReqDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="tcbj_WmsApi")
public class TcbjWmsApiImpl
extends WmsApiImpl {
    private static final Logger log = LoggerFactory.getLogger(TcbjWmsApiImpl.class);

    public RestResponse<Void> appendLogistics(CsWmsOutSendBackReqDto csWmsInSendBackReqDto) {
        this.csWmsService.appendLogistics(csWmsInSendBackReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<String> inSendBack(CsWmsInSendBackReqDto csWmsInSendBackReqDto) {
        this.csWmsService.inSendBack(csWmsInSendBackReqDto);
        return RestResponse.SUCCEED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<String> outSendBack(CsWmsOutSendBackReqDto csWmsOutSendBackReqDto) {
        String key = csWmsOutSendBackReqDto.getOutNoticeOrderNo() + "_" + csWmsOutSendBackReqDto.getWmsOrderNo();
        Mutex mutex = this.lockService.lock("WMS_OUT_BACK:", key, 30, 35, TimeUnit.SECONDS);
        try {
            this.preValid(csWmsOutSendBackReqDto);
            this.csWmsService.outSendBack(csWmsOutSendBackReqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.SUCCEED;
    }

    private void preValid(CsWmsOutSendBackReqDto csWmsOutSendBackReqDto) {
        if (YesNoEnum.YES.getValue().equals(csWmsOutSendBackReqDto.getIsAllDeal())) {
            Boolean existResult = this.csOutResultOrderQueryService.queryPreOrderNoExist(csWmsOutSendBackReqDto.getOutNoticeOrderNo());
            AssertUtil.isTrue(existResult == false, "\u6574\u5355\u64cd\u4f5c\uff0c\u5df2\u5b58\u5728\u51fa\u5e93\u7ed3\u679c\u5355");
        }
    }

    public RestResponse<String> cancel(CsWmsCancelReqDto csWmsCancelReqDto) {
        this.csWmsService.cancel(csWmsCancelReqDto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> cancelRetreat(CsWmsCancelReqDto csWmsCancelReqDto) {
        this.csWmsService.cancelRetreat(csWmsCancelReqDto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> plannedOrderExposedCancel(CsPlannedCancelReqDto plannedCancelReqDto) {
        this.csWmsService.plannedOrderExposedCancel(plannedCancelReqDto);
        return RestResponse.SUCCEED;
    }

    public RestResponse<String> retreatExposedCancel(CsPlannedCancelReqDto plannedCancelReqDto) {
        this.csWmsService.retreatExposedCancel(plannedCancelReqDto);
        return RestResponse.SUCCEED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<String> cancelInstruct(CsWmsCancelReqDto csWmsCancelReqDto) {
        String key = csWmsCancelReqDto.getNoticeOrderNo();
        Mutex mutex = this.lockService.lock("WMS_CANCEL_BACK:", key, 30, 35, TimeUnit.SECONDS);
        try {
            this.csWmsService.cancelInstruct(csWmsCancelReqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.SUCCEED;
    }

    public RestResponse<Boolean> pushStatusPostback(CsOutNoticeOrderPushStatusPostbackReqDto outNoticeOrderPushStatusPostbackReqDto) {
        return null;
    }

    public RestResponse<Void> heavyPushWms(List<String> documentNos) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<String> noticeTransferConsignment(WmsInSendBackReqDto wmsInSendBackReqDto) {
        TransportOrderInfoReqDto transportOrderInfoReqDto = wmsInSendBackReqDto.getTransportOrderInfoReqDto();
        String key = transportOrderInfoReqDto.getDocumentNo();
        Mutex mutex = this.lockService.lock("NOTICE_CONSIGNMENT:", key, 30, 35, TimeUnit.SECONDS);
        try {
            this.csWmsService.noticeTransferConsignment(transportOrderInfoReqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.SUCCEED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestResponse<String> confirmTransferConsignment(WmsInSendBackReqDto wmsInSendBackReqDto) {
        TransportConfirmInfoReqDto transportConfirmInfoReqDto = wmsInSendBackReqDto.getTransportConfirmInfoReqDto();
        String key = transportConfirmInfoReqDto.getDocumentNo();
        Mutex mutex = this.lockService.lock("CONFIRM_CONSIGNMENT:", key, 30, 35, TimeUnit.SECONDS);
        try {
            this.csWmsService.confirmTransferConsignment(transportConfirmInfoReqDto);
        }
        finally {
            this.lockService.unlock(mutex);
        }
        return RestResponse.SUCCEED;
    }
}

