/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DispatcherOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.response.DispatcherOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.IOrderPreemptWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.commons.ITransferOrderWrapperHelper;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.impl.wms.CsBdWmsExternalServiceImpl;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsDispatcherOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.ICsTransferOrderService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.inventory.IDispatcherOrderDetailService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.ICsDeliveryResultOrderQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.AbstractCsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsUpdatePreemptServer;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.das.cs.inventory.CsTransferOrderDas;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderDetailEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderDetailMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsCancelTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushSalesHeadReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushSalesItemReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushSalesTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderHeadReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushTransferStorageOrderHeadReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.bd.sap.PushTransferStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsShopEnquiryApplyStatusExtEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsTransferOrderEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.SapCenterTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.bd.PcpBasicInventoryBusinessTypeEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component(value="CsBdtransfer_orderBusinessOrderCallBackService")
public class CsBdTransferOrderCallBackServiceImpl
extends AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(CsBdTransferOrderCallBackServiceImpl.class);
    @Resource
    private CsTransferOrderDas csTransferOrderDas;
    @Resource
    private ICsDeliveryResultOrderQueryService csDeliveryResultOrderQueryService;
    @Resource
    private CsUpdatePreemptServer csUpdatePreemptServer;
    @Resource(name="bd_TransferOrderApi")
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private CsBdWmsExternalServiceImpl csBdWmsExternalService;
    @Resource
    private ICommonsMqService commonsMqService;
    @Value(value="${order.send.flag:false}")
    private boolean pushFlag;
    @Value(value="${ignore.batch.flag:false}")
    protected boolean ignoreBatch;
    @Resource
    private CsTransferOrderDetailMapper csTransferOrderDetailMapper;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private CsTransferOrderMapper csTransferOrderMapper;
    @Resource
    private ICsTransferOrderService csTransferOrderService;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private ITransferOrderWrapperHelper transferOrderWrapperHelper;
    @Resource
    private IOrderPreemptWrapperHelper orderPreemptWrapperHelper;
    @Resource
    private IDispatcherOrderDetailService dispatcherOrderDetailService;
    @Resource
    private ICsDispatcherOrderService csDispatcherOrderService;

    @Override
    public String getStrategy() {
        return "bdtransfer_order";
    }

    private void updateOrderStatus(String transferOrderNo, String status) {
        CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(transferOrderNo);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"id", (Object)transferOrderEo.getId());
        transferOrderEo.setOrderStatus(status);
        this.csTransferOrderMapper.update((Object)transferOrderEo, (Wrapper)queryWrapper);
        this.shippingDataToOa(status, transferOrderEo);
        Integer requisitionOrderStatus = CsTransferOrderEnum.Status.FINISH.getCode().equals(status) ? CsShopEnquiryApplyStatusExtEnum.COMPLETE.getType() : null;
        CsTransferOrderReqDto transferOrderReqDto = new CsTransferOrderReqDto();
        CubeBeanUtils.copyProperties((Object)transferOrderReqDto, (Object)transferOrderEo, (String[])new String[0]);
        this.csTransferOrderService.linkageUpdateRequisitionOrder(transferOrderReqDto, status, requisitionOrderStatus);
    }

    private void dispatcherTransferOrder(final String transferOrderNo, String status) {
        if (CsTransferOrderEnum.Status.FINISH.getCode().equals(status)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    logger.info("\u5904\u7406\u6536\u53d1\u5dee\u5f02:{}", (Object)LogUtils.buildLogContent(transferOrderNo));
                    CsBdTransferOrderCallBackServiceImpl.this.csTransferOrderService.dispatcherTransferOrder(transferOrderNo);
                }
            });
        }
    }

    private void shippingDataToOa(String status, CsTransferOrderEo transferOrderEo) {
        if (!CsTransferOrderEnum.Status.DELIVERED.getCode().equals(status) || !"OA".equals(transferOrderEo.getOrderSrc())) {
            return;
        }
        String transferOrderNo = transferOrderEo.getTransferOrderNo();
        logger.info("\u8c03\u62e8\u5355\u53f7\uff1a\u3010{}\u3011\u5df2\u53d1\u8d27\u72b6\u6001\u53ca\u5355\u636e\u6765\u6e90\u662foa,\u7ec4\u88c5\u6570\u636e\u53d1\u9001\u7269\u6d41\u4fe1\u606f\u7ed9oa", (Object)transferOrderNo);
        List outResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"order_type", (Object)"out")).list();
        logger.info("\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u51fa\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outResultOrderEos));
        if (CollectionUtils.isEmpty((Collection)outResultOrderEos)) {
            return;
        }
        InOutResultOrderEo outResultOrderEo = (InOutResultOrderEo)outResultOrderEos.get(0);
        List shippingInfoReqDtoList = JSON.parseArray((String)outResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class);
        if (CollectionUtils.isEmpty((Collection)shippingInfoReqDtoList)) {
            return;
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("orderNo", transferOrderEo.getPreOrderNo());
        String logisticsNos = shippingInfoReqDtoList.stream().map(CsWmsShippingInfoReqDto::getShippingNo).collect(Collectors.joining(","));
        msgMap.put("shippingNo", logisticsNos);
        String companyNames = shippingInfoReqDtoList.stream().map(CsWmsShippingInfoReqDto::getShippingCompanyName).collect(Collectors.joining(","));
        msgMap.put("shipmentEnterpriseName", companyNames);
        List outResultOrderDetailEos = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)outResultOrderEo.getDocumentNo())).list();
        logger.info("\u6839\u636e\u8c03\u62e8\u5355\u53f7\u67e5\u8be2\u51fa\u5e93\u7ed3\u679c\u5355\u51fa\u5e93\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outResultOrderEos));
        if (CollectionUtils.isEmpty((Collection)outResultOrderDetailEos)) {
            return;
        }
        List itemDtoList = outResultOrderDetailEos.stream().map(e -> {
            HashMap<String, String> itemDto = new HashMap<String, String>();
            itemDto.put("skuCode", e.getSkuCode());
            return itemDto;
        }).collect(Collectors.toList());
        msgMap.put("goodsList", itemDtoList);
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString(msgMap));
        logger.info("\u3010\u5df2\u53d1\u8d27\u72b6\u6001\u53ca\u5355\u636e\u6765\u6e90\u662foa\u7684\u53d1\u9001\u7269\u6d41\u4fe1\u606f\u7ed9oa\u3011\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "PUSH_OA_SHIPPING_EXPRESS_NEW", (Object)messageVo);
    }

    private CsTransferOrderEo getCsTransferOrderEo(String transferOrderNo) {
        CsTransferOrderEo transferOrderEo = (CsTransferOrderEo)((ExtQueryChainWrapper)this.csTransferOrderDas.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        AssertUtil.isTrue(Objects.nonNull(transferOrderEo), "\u627e\u4e0d\u5230\u8c03\u62e8\u5355\u5355\u636e,\u5355\u636e\u53f7:" + transferOrderNo);
        return transferOrderEo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8c03\u62e8\u5355\u56de\u8c03deliveryReceiveNoticeOrderCallBack");
        return true;
    }

    private void increaseLogicIntransitInventory(CsOrderBusinessCallBackContext callBackContext) {
        CsBasicsOrderReqDto csBasicsOrderReqDto = callBackContext.getCsBasicsOrderReqDto();
        List detailList = csBasicsOrderReqDto.getOrderBasicsDetailReqDtoList();
        TransferOutDto transferOutDto = new TransferOutDto();
        transferOutDto.setSourceNo(csBasicsOrderReqDto.getRelevanceNo());
        transferOutDto.setSourceType(CsInventorySourceTypeEnum.OUT_ALLOT.getCode());
        transferOutDto.setBusinessType(csBasicsOrderReqDto.getBusinessType());
        transferOutDto.setInLogicWarehouseCode(csBasicsOrderReqDto.getInLogicWarehouseCode());
        ArrayList outDetails = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : detailList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            detailParam.setNum(detailReqDto.getQuantity().abs());
            detailParam.setSkuCode(detailReqDto.getLongCode());
            detailParam.setLogicWarehouseCode(csBasicsOrderReqDto.getLogicWarehouseCode());
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            detailParam.setLineNo(detailReqDto.getLineNo());
            outDetails.add(detailParam);
        }
        if (Objects.isNull(((CsBasicsOrderDetailReqDto)detailList.get(0)).getLineNo())) {
            transferOutDto.setNoneLineNo(Boolean.valueOf(true));
        }
        transferOutDto.setDetails((List)outDetails);
        if (!this.ignoreBatch) {
            logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u4ed3\u5728\u9014\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(transferOutDto));
            this.calcInventoryService.transferOut(transferOutDto);
            logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u4ed3\u5728\u9014\u5e93\u5b58\u5b8c\u6210");
        }
        for (CalcDetailDto cargoDto : transferOutDto.getDetails()) {
            cargoDto.setBatch(null);
        }
        logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u603b\u4ed3\u5728\u9014\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(transferOutDto));
        this.calcInventoryService.transferOut(transferOutDto);
        logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u603b\u5728\u9014\u4ed3\u5e93\u5b58\u7ed3\u679c\u5b8c\u6210");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean inOutNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutNoticeOrderCallBack==>callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(callBackContext.getRelevanceNo());
        logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutNoticeOrderCallBack==>transferOrderEo:{}", (Object)LogUtils.buildLogContent(transferOrderEo));
        callBackContext.setTransferOrderFirstCallBack(Boolean.valueOf(true));
        if (callBackContext.getInFlag().booleanValue()) {
            this.updateOrderStatus(callBackContext.getRelevanceNo(), CsTransferOrderEnum.Status.WAIT_RECEIVE.getCode());
            if ("9999".equals(transferOrderEo.getInLogicWarehouseCode()) || CsPcpBusinessTypeEnum.DICT_ALLOT_STORE_RAISED.getCode().equals(transferOrderEo.getType())) {
                logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutNoticeOrderCallBack==>\u5339\u914d\u5230\u5165\u5e93,callBackContext:{},transferOrderEo:{}", (Object)LogUtils.buildLogContent(callBackContext), (Object)LogUtils.buildLogContent(transferOrderEo));
                this.generateWmsInCallbackOrder(callBackContext, transferOrderEo);
            }
        } else {
            this.updateOrderStatus(callBackContext.getRelevanceNo(), CsTransferOrderEnum.Status.WAIT_DELIVERY.getCode());
            if (CsPcpBusinessTypeEnum.ALLOT_BC_EFFICACY.getCode().equals(transferOrderEo.getType()) || "9999".equals(transferOrderEo.getOutLogicWarehouseCode()) || CsPcpBusinessTypeEnum.DICT_ALLOT_STORE_RAISED.getCode().equals(transferOrderEo.getType())) {
                logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutNoticeOrderCallBack==>\u5339\u914d\u5230\u51fa\u5e93,callBackContext:{},transferOrderEo:{}", (Object)LogUtils.buildLogContent(callBackContext), (Object)LogUtils.buildLogContent(transferOrderEo));
                this.generateWmsOutCallbackOrder(callBackContext, transferOrderEo);
            }
        }
        return true;
    }

    private void updateInOutNoticeOrderInfo(CsTransferOrderEo transferOrderEo) {
        ArrayList<String> filterOrderStatusList = new ArrayList<String>(2);
        filterOrderStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        filterOrderStatusList.add(BaseOrderStatusEnum.INO_CANCEL.getCode());
        List InOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderEo.getTransferOrderNo())).notIn((Object)"order_status", filterOrderStatusList)).list();
        logger.info("updateInOutNoticeOrderInfo==>InOutNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEoList));
        if (CollectionUtils.isEmpty((Collection)InOutNoticeOrderEoList)) {
            return;
        }
        for (InOutNoticeOrderEo InOutNoticeOrderEo2 : InOutNoticeOrderEoList) {
            InOutNoticeOrderEo2.setExternalOrderNo(transferOrderEo.getPreOrderNo());
            InOutNoticeOrderEo2.setSourcePlatformCode(transferOrderEo.getOrderSrc());
            InOutNoticeOrderEo2.setPayTime(transferOrderEo.getCreateTime());
            InOutNoticeOrderEo2.setTradeOrderCreateTime(transferOrderEo.getCreateTime());
            InOutNoticeOrderEo2.setId(InOutNoticeOrderEo2.getId());
            logger.info("updateInOutNoticeOrderInfo==>InOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEo2));
            this.inOutNoticeOrderDomain.update((BaseEo)InOutNoticeOrderEo2);
        }
    }

    private void generateWmsInCallbackOrder(CsOrderBusinessCallBackContext callBackContext, CsTransferOrderEo transferOrderEo) {
        logger.info("generateInOutOrder==>\u8c03\u62e8\u5355\u7c7b\u578b\u56de\u8c03,\u6a21\u62dfWMS\u56de\u8c03\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355");
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = this.covertWmsInOutDto(callBackContext, transferOrderEo, transferOrderEo.getInPhysicsWarehouseCode());
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
    }

    private void generateWmsOutCallbackOrder(CsOrderBusinessCallBackContext callBackContext, CsTransferOrderEo transferOrderEo) {
        logger.info("generateInOutOrder==>\u8c03\u62e8\u5355\u7c7b\u578b\u56de\u8c03,\u6a21\u62dfWMS\u56de\u8c03\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355");
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = this.covertWmsInOutDto(callBackContext, transferOrderEo, transferOrderEo.getOutPhysicsWarehouseCode());
        wmsExternalService.receiveOut(csBasicsReceiveReqDto);
    }

    private CsBasicsReceiveReqDto covertWmsInOutDto(CsOrderBusinessCallBackContext callBackContext, CsTransferOrderEo transferOrderEo, String outPhysicsWarehouseCode) {
        CsBasicsOrderReqDto basics = callBackContext.getCsBasicsOrderReqDto();
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        List sourceDetail = basics.getOrderBasicsDetailReqDtoList();
        csBasicsReceiveReqDto.setPlatformOrderNo(transferOrderEo.getPreOrderNo());
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(basics.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : sourceDetail) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
            inSendBackDetailReqDto.setQuantity(detailReqDto.getQuantity());
            inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
            inSendBackDetailReqDto.setWarehouseCode(outPhysicsWarehouseCode);
            inSendBackDetailReqDto.setTradeOrderItemId(detailReqDto.getTradeOrderItemId());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        return csBasicsReceiveReqDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutResultOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        ArrayList<String> specialHandlingTypeList = new ArrayList<String>(3);
        specialHandlingTypeList.add(PcpBasicInventoryBusinessTypeEnum.TRANSFER_RETURN_PILOT_MACHINE.getCode());
        specialHandlingTypeList.add(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_ALSO.getCode());
        specialHandlingTypeList.add(PcpBasicInventoryBusinessTypeEnum.TRANSFER_RETURN_OF_THE_CONSIGNMENT.getCode());
        if (callBackContext.getInFlag().booleanValue()) {
            if (callBackContext.getOverchargeFlag().booleanValue()) {
                logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutResultOrderCallBack,\u8d85\u6536\u4e86");
            } else {
                logger.info("callBackContext.getInFlag()==>");
                String status = this.judgeStatus(callBackContext);
                this.increasePhysicsInventory(callBackContext);
                this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
                this.dispatcherTransferOrder(callBackContext.getRelevanceNo(), status);
            }
        } else if (callBackContext.getOverchargeFlag().booleanValue()) {
            logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutResultOrderCallBack,\u8d85\u6536\u53d1\u4e86");
        } else {
            String status = callBackContext.getPortionFlag() != false ? CsTransferOrderEnum.Status.PORTION_DELIVERY.getCode() : CsTransferOrderEnum.Status.DELIVERED.getCode();
            if (!specialHandlingTypeList.contains(callBackContext.getCsInOutResultRespDto().getDisplayBusinessType())) {
                this.deducePhysicsInventory(callBackContext, 1);
            } else {
                this.specialHandlingPhysicsInventory(callBackContext);
            }
            this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
        }
        logger.info("csBdTransferOrderCallBackServiceImpl\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u63a8\u9001\u6807\u8bc6pushFlag:{},relevanceNo:{}", (Object)this.pushFlag, (Object)callBackContext.getRelevanceNo());
        if (this.pushFlag) {
            String reqId = MDC.get((String)"yes.req.requestId");
            ExecutorUtils.execute(() -> {
                MDC.put((String)"yes.req.requestId", (String)reqId);
                this.pushResultOrder(callBackContext);
            });
        }
        return true;
    }

    private void specialHandlingPhysicsInventory(CsOrderBusinessCallBackContext callBackContext) {
    }

    private String judgeStatus(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("judgeStatus==>callBackContext:{}", (Object)LogUtils.buildLogContent(callBackContext));
        String status = CsTransferOrderEnum.Status.PORTION_RECEIVE.getCode();
        CsTransferOrderEo csTransferOrderEo = this.getCsTransferOrderEo(callBackContext.getRelevanceNo());
        List<ReceiveDeliveryResultOrderEo> resultOrderEoList = this.csDeliveryResultOrderQueryService.queryByRelevanceNo(callBackContext.getRelevanceNo());
        logger.info("\u6839\u636e\u8c03\u62e8\u5355\u53f7\uff1a{} \u67e5\u8be2\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u4fe1\u606f\uff1a{}", (Object)callBackContext.getRelevanceNo(), (Object)JSON.toJSONString(resultOrderEoList));
        if (CollectionUtils.isNotEmpty(resultOrderEoList)) {
            BigDecimal deliveryTotal = BigDecimal.ZERO;
            for (ReceiveDeliveryResultOrderEo ReceiveDeliveryResultOrderEo2 : resultOrderEoList) {
                if (!"receive".equals(ReceiveDeliveryResultOrderEo2.getOrderType())) continue;
                deliveryTotal = deliveryTotal.add(ReceiveDeliveryResultOrderEo2.getTotalQuantity());
            }
            if (csTransferOrderEo.getTotalQuantity().compareTo(deliveryTotal) <= 0 && (status = CsTransferOrderEnum.Status.FINISH.getCode()).equals(csTransferOrderEo.getOrderStatus()) && StringUtils.isNotBlank((CharSequence)csTransferOrderEo.getDispatcherStatus())) {
                CsTransferOrderEo transferOrderEo = new CsTransferOrderEo();
                transferOrderEo.setId(csTransferOrderEo.getId());
                transferOrderEo.setDispatcherHandleStatus("");
                transferOrderEo.setDispatcherStatus("");
                this.csTransferOrderMapper.updateById((BaseEo)transferOrderEo);
            }
        }
        return status;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("\u8c03\u62e8\u5355\u56de\u8c03deliveryReceiveResultOrderCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        if (callBackContext.getInFlag().booleanValue()) {
            String status = this.judgeStatus(callBackContext);
            this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
            this.specialHandling(callBackContext.getRelevanceNo());
        } else {
            this.generateReceiveNoticeOrder(callBackContext);
            if (callBackContext.getPortionFlag().booleanValue()) {
                this.updateOrderStatus(callBackContext.getRelevanceNo(), CsTransferOrderEnum.Status.PORTION_DELIVERY.getCode());
            }
        }
        return true;
    }

    private void specialHandling(String transferOrderNo) {
        logger.info("specialHandling==>\u8c03\u62e8\u5355\u786e\u8ba4\u6536\u8d27\u7279\u6b8a\u5904\u7406,\u5c06\u8c03\u62e8\u5355\u66f4\u65b0\u4e3a\u6302\u8d77\u72b6\u6001,transferOrderNo:{}", (Object)transferOrderNo);
        CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(transferOrderNo);
        QueryWrapper csTransferOrderDetailEoQueryWrapper = new QueryWrapper();
        csTransferOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        csTransferOrderDetailEoQueryWrapper.eq((Object)"transfer_order_no", (Object)transferOrderNo);
        List transferOrderDetailEoList = this.csTransferOrderDetailMapper.selectList((Wrapper)csTransferOrderDetailEoQueryWrapper);
        List InOutResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"order_type", (Object)"in")).list();
        if (CollectionUtils.isEmpty((Collection)InOutResultOrderEoList)) {
            return;
        }
        List outResultDocumentNoList = InOutResultOrderEoList.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList());
        logger.info("specialHandling==>\u8c03\u62e8\u5355\u786e\u8ba4\u6536\u8d27\u7279\u6b8a\u5904\u7406,\u5c06\u8c03\u62e8\u5355\u66f4\u65b0\u4e3a\u6302\u8d77\u72b6\u6001,outResultDocumentNoList:{}", (Object)LogUtils.buildLogContent(outResultDocumentNoList));
        List InOutResultOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", outResultDocumentNoList)).list();
        if (CollectionUtils.isEmpty((Collection)InOutResultOrderDetailEoList)) {
            return;
        }
        Map<String, List<InOutResultOrderDetailEo>> eoGroupMap = InOutResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getSkuCode));
        Map<Long, List<InOutResultOrderDetailEo>> eoPreOrderItemIdGroupMap = InOutResultOrderDetailEoList.stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getPreOrderItemId));
        logger.info("specialHandling==>\u8c03\u62e8\u5355\u786e\u8ba4\u6536\u8d27\u7279\u6b8a\u5904\u7406,\u5c06\u8c03\u62e8\u5355\u66f4\u65b0\u4e3a\u6302\u8d77\u72b6\u6001,eoGroupMap:{}", (Object)LogUtils.buildLogContent(eoGroupMap));
        boolean updateFlag = false;
        for (CsTransferOrderDetailEo detailEo : transferOrderDetailEoList) {
            BigDecimal totalResultDoneQuantity;
            String longCode = detailEo.getLongCode();
            BigDecimal quantity = detailEo.getQuantity();
            List<InOutResultOrderDetailEo> tempResultEoList = CollectionUtils.isNotEmpty((Collection)eoPreOrderItemIdGroupMap.get(detailEo.getId())) ? eoPreOrderItemIdGroupMap.get(detailEo.getId()) : eoGroupMap.get(longCode);
            if (CollectionUtils.isEmpty(tempResultEoList) || (totalResultDoneQuantity = tempResultEoList.stream().map(InOutResultOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(quantity) <= 0) continue;
            updateFlag = true;
            break;
        }
        logger.info("specialHandling==>\u8c03\u62e8\u5355\u786e\u8ba4\u6536\u8d27\u7279\u6b8a\u5904\u7406,\u5c06\u8c03\u62e8\u5355\u66f4\u65b0\u4e3a\u6302\u8d77\u72b6\u6001,updateFlag:{}", (Object)updateFlag);
        if (!updateFlag) {
            return;
        }
        CsTransferOrderEo updateEo = new CsTransferOrderEo();
        updateEo.setId(transferOrderEo.getId());
        updateEo.setOrderStatus(CsTransferOrderEnum.Status.HANG_UP.getCode());
        this.csTransferOrderDas.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void pushResultOrder(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("CsBdTransferOrderCallBackServiceImpl-pushResultOrder:{}", (Object)JSON.toJSONString((Object)callBackContext));
        CsInOutResultRespDto csInOutResultRespDto = callBackContext.getCsInOutResultRespDto();
        if (Objects.isNull(csInOutResultRespDto)) {
            return;
        }
        List inOutResultDetailRespDtoList = csInOutResultRespDto.getInOutResultDetailRespDtoList();
        CsTransferOrderEo transferOrder = this.getCsTransferOrderEo(callBackContext.getRelevanceNo());
        if (this.setVirtualTransferOrderType(csInOutResultRespDto, transferOrder)) {
            return;
        }
        logger.info("\u8fdb\u5165pushResultOrder\u65b9\u6cd5\uff0ctransferOrderNo:{},type:{}", (Object)csInOutResultRespDto.getRelevanceNo(), (Object)transferOrder.getType());
        List<String> transferList = Arrays.asList(PcpBasicInventoryBusinessTypeEnum.TRANSFER_WARHEOUSE.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORES_TO_CARGO.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_SALES_WARHEOUSE_SEND.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_BACK.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_RAISED.getCode());
        List<String> notSale = Arrays.asList(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_OPPORTUNITY.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_BORROW_MACHINE.getCode());
        List<String> notPurchase = Arrays.asList(PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_ALSO.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_RETURN_PILOT_MACHINE.getCode());
        List<String> consignment = Arrays.asList(PcpBasicInventoryBusinessTypeEnum.TRANSFER_CONSIGNMENT_TO_CARGO.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_RETURN_OF_THE_CONSIGNMENT.getCode());
        if (transferList.contains(transferOrder.getType())) {
            this.pushTransferInOutOrderToSap(callBackContext, csInOutResultRespDto, inOutResultDetailRespDtoList, transferOrder);
        } else if (consignment.contains(transferOrder.getType())) {
            this.pushSaleTransferResultOrder(callBackContext, csInOutResultRespDto, inOutResultDetailRespDtoList, transferOrder);
        } else if (notSale.contains(transferOrder.getType())) {
            logger.info("\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93,inFlag:{},transferOrderNo:{}", (Object)callBackContext.getInFlag(), (Object)csInOutResultRespDto.getRelevanceNo());
            this.pushNotSaleTransferResultOrder(callBackContext, csInOutResultRespDto, inOutResultDetailRespDtoList, transferOrder);
        } else if (notPurchase.contains(transferOrder.getType())) {
            Boolean transferOrderFirstCallBack = callBackContext.getTransferOrderFirstCallBack();
            logger.info("transferOrderFirstCallBack:{}", (Object)transferOrderFirstCallBack);
            if (transferOrderFirstCallBack.booleanValue()) {
                return;
            }
            this.pushNotPurchaseResultOrder(callBackContext, csInOutResultRespDto, inOutResultDetailRespDtoList, transferOrder);
        }
    }

    @Override
    public void closeOrderStatus(String relevanceNo) {
    }

    private boolean setVirtualTransferOrderType(CsInOutResultRespDto csInOutResultRespDto, CsTransferOrderEo transferOrder) {
        if (PcpBasicInventoryBusinessTypeEnum.isVirtualTransferOrder((String)transferOrder.getType())) {
            if ("in".equals(csInOutResultRespDto.getOrderType())) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            DispatcherOrderDetailReqDto dispatcherOrderDetailReqDto = new DispatcherOrderDetailReqDto();
            dispatcherOrderDetailReqDto.setOrderNo(transferOrder.getPreOrderNo());
            dispatcherOrderDetailReqDto.setBusinessNo(transferOrder.getTransferOrderNo());
            PageInfo<DispatcherOrderDetailRespDto> pageInfo = this.dispatcherOrderDetailService.queryByPage(JSON.toJSONString((Object)dispatcherOrderDetailReqDto), 1, 1);
            logger.info("\u6839\u636e\u6536\u53d1\u5dee\u5f02\u5355\u53f7\uff1a{}\u67e5\u8be2\u5230\u6536\u53d1\u5dee\u5f02\u660e\u7ec6\u4fe1\u606f\uff1a{}", (Object)transferOrder.getPreOrderNo(), (Object)JSON.toJSONString(pageInfo));
            DispatcherOrderDetailRespDto dispatcherOrderDetailRespDto = Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) ? (DispatcherOrderDetailRespDto)pageInfo.getList().get(0) : null;
            logger.info("dispatcherOrderDetailRespDto:{}", (Object)JSON.toJSONString(dispatcherOrderDetailRespDto));
            DispatcherOrderReqDto dispatcherOrderReqDto = new DispatcherOrderReqDto();
            dispatcherOrderReqDto.setOrderNo(transferOrder.getPreOrderNo());
            PageInfo<DispatcherOrderRespDto> dtoPageInfo = this.csDispatcherOrderService.queryByPage(JSON.toJSONString((Object)dispatcherOrderReqDto), 1, 1);
            DispatcherOrderRespDto dispatcherOrderRespDto = Objects.nonNull(dtoPageInfo) && CollectionUtils.isNotEmpty((Collection)dtoPageInfo.getList()) ? (DispatcherOrderRespDto)dtoPageInfo.getList().get(0) : null;
            logger.info("dispatcherOrderRespDto:{}", (Object)JSON.toJSONString(dispatcherOrderRespDto));
            String type = this.getType(transferOrder, dispatcherOrderDetailRespDto, dispatcherOrderRespDto);
            if (StringUtils.isEmpty((CharSequence)type)) {
                logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7c7b\u578b\uff0c\u4e0d\u63a8sap");
                return true;
            }
            transferOrder.setType(type);
        }
        return false;
    }

    private String getType(CsTransferOrderEo transferOrder, DispatcherOrderDetailRespDto dispatcherOrderDetailRespDto, DispatcherOrderRespDto dispatcherOrderRespDto) {
        if (StringUtils.isBlank((CharSequence)dispatcherOrderDetailRespDto.getOperationWay())) {
            return "";
        }
        String type = "";
        switch (dispatcherOrderDetailRespDto.getOperationWay()) {
            case "more_transfer": 
            case "less_again_receive": 
            case "less_transfer": {
                logger.info("\u83b7\u53d6\u539f\u8c03\u62e8\u5355\u4e1a\u52a1\u7c7b\u578b\uff1a{}", (Object)dispatcherOrderRespDto.getType());
                type = dispatcherOrderRespDto.getType();
                break;
            }
            case "less_return_transfer": {
                logger.info("\u6839\u636e\u865a\u62df\u8c03\u62e8\u5355\u7c7b\u578b\u83b7\u53d6\u5bf9\u5e94\u6b63\u5e38\u7c7b\u578b\uff1a{}", (Object)transferOrder.getType());
                type = PcpBasicInventoryBusinessTypeEnum.virtualTransferOrderGetNormalType((String)transferOrder.getType());
                break;
            }
        }
        return type;
    }

    private void pushNotPurchaseResultOrder(CsOrderBusinessCallBackContext callBackContext, CsInOutResultRespDto csInOutResultRespDto, List<CsInOutResultDetailRespDto> detailList, CsTransferOrderEo transferOrder) {
        String type = transferOrder.getType();
        if (callBackContext.getInFlag().booleanValue() && ("71004".equals(type) || "71002".equals(type))) {
            this.pushOrder(callBackContext.getOutResultOrderId().toString(), csInOutResultRespDto, detailList, transferOrder, "PUSH_RECEIVED_RESULT_ORDER", csInOutResultRespDto.getInLogicWarehouseCode(), "pushOrder\u63a8\u9001\u975e\u91c7\u8d2d\u5165\u5e93\u5355mq\u6d88\u606f");
        }
        if (!callBackContext.getInFlag().booleanValue()) {
            this.pushOrder(callBackContext.getOutResultOrderId().toString(), csInOutResultRespDto, detailList, transferOrder, "PUSH_RECEIVED_RESULT_ORDER", csInOutResultRespDto.getInLogicWarehouseCode(), "pushOrder\u63a8\u9001\u975e\u91c7\u8d2d\u5165\u5e93\u5355mq\u6d88\u606f");
        }
    }

    private void pushNotSaleTransferResultOrder(CsOrderBusinessCallBackContext callBackContext, CsInOutResultRespDto csInOutResultRespDto, List<CsInOutResultDetailRespDto> detailList, CsTransferOrderEo transferOrder) {
        if (!callBackContext.getInFlag().booleanValue()) {
            this.pushOrder(callBackContext.getOutResultOrderId().toString(), csInOutResultRespDto, detailList, transferOrder, "PUSH_DELIVERY_RESULT_ORDER", csInOutResultRespDto.getOutLogicWarehouseCode(), "pushOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f");
        }
    }

    private void pushOrder(String id, CsInOutResultRespDto csDeliveryReceiveResultRespDto, List<CsInOutResultDetailRespDto> detailList, CsTransferOrderEo transferOrder, String tag, String warehouseCode, String message) {
        logger.info("\u8fdb\u5165pushOrder\u65b9\u6cd5,id:{},transferOrder\uff1a{}", (Object)id, (Object)csDeliveryReceiveResultRespDto.getRelevanceNo());
        String orderType = csDeliveryReceiveResultRespDto.getOrderType();
        String type = transferOrder.getType();
        if ("out".equals(orderType) && ("71004".equals(type) || "71002".equals(type))) {
            logger.info("\u501f\u673a\u8fd8\u673a\u7279\u6b8a\u5904\u7406...");
            return;
        }
        List<String> product = Arrays.asList(CsPcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_BORROW.getCode(), CsPcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_RETURN.getCode());
        String moveReason = "";
        if (product.contains(transferOrder.getType())) {
            moveReason = "0004";
        }
        PushStorageOrderHeadReqDto head = new PushStorageOrderHeadReqDto();
        head.setId(id);
        head.setCreateDate(DateUtil.formatDateTime((Date)("PUSH_RECEIVED_RESULT_ORDER".equals(tag) ? csDeliveryReceiveResultRespDto.getCreateTime() : transferOrder.getCreateTime())));
        head.setSapMoveType(SapCenterTypeEnum.getSapTypeByCenterType((String)transferOrder.getType()));
        head.setKostl(transferOrder.getKostl());
        String factoryType = "1220";
        head.setFactoryType(factoryType);
        head.setCustomerCode(transferOrder.getCustomerCode());
        head.setTransferOrderNo(transferOrder.getTransferOrderNo());
        head.setSrcOrderNo(csDeliveryReceiveResultRespDto.getExternalOrderNo());
        head.setRefNo(csDeliveryReceiveResultRespDto.getDocumentNo());
        ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailList.size());
        DecimalFormat df = new DecimalFormat("#0.00");
        for (int i = 0; i < detailList.size(); ++i) {
            PushItemReqDto sapItemReqDto = new PushItemReqDto();
            sapItemReqDto.setCode(detailList.get(i).getSkuCode());
            sapItemReqDto.setRowNum(String.valueOf(i + 1));
            sapItemReqDto.setWarehouseCode(warehouseCode);
            sapItemReqDto.setNum(df.format(detailList.get(i).getQuantity()));
            sapItemReqDto.setFactoryType(factoryType);
            sapItemReqDto.setMoveReason(moveReason);
            itemReqDtoList.add(sapItemReqDto);
        }
        PushStorageOrderReqDto sapStorageOrderReqDto = new PushStorageOrderReqDto();
        sapStorageOrderReqDto.setStorageOrderHearReqDto(head);
        sapStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
        logger.info("pushOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f,transferOrder\uff1a{},", (Object)csDeliveryReceiveResultRespDto.getRelevanceNo());
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)sapStorageOrderReqDto));
    }

    private void pushSaleTransferResultOrder(CsOrderBusinessCallBackContext callBackContext, CsInOutResultRespDto csInOutResultRespDto, List<CsInOutResultDetailRespDto> detailList, CsTransferOrderEo transferOrder) {
        boolean flag = this.getPushSapFlag(callBackContext.getInFlag(), transferOrder);
        if (flag) {
            String factoryType = "1220";
            String warehouseCode = csInOutResultRespDto.getInLogicWarehouseCode();
            if (warehouseCode.equals("9999")) {
                warehouseCode = csInOutResultRespDto.getOutLogicWarehouseCode();
            }
            String sapType = callBackContext.getInFlag() != false ? "ZKA" : "ZKB";
            PushSalesTransferOrderReqDto salesTransferOrderReqDto = new PushSalesTransferOrderReqDto();
            PushSalesHeadReqDto sapSalesHeadReqDto = new PushSalesHeadReqDto();
            sapSalesHeadReqDto.setId(transferOrder.getId().toString());
            sapSalesHeadReqDto.setType(sapType);
            sapSalesHeadReqDto.setChannelCode("00");
            sapSalesHeadReqDto.setFactoryType(factoryType);
            sapSalesHeadReqDto.setTransferOrderNo(transferOrder.getTransferOrderNo());
            sapSalesHeadReqDto.setCustomerCode(transferOrder.getCustomerCode());
            sapSalesHeadReqDto.setCreateDate(DateUtil.formatDateTime((Date)transferOrder.getCreateTime()));
            sapSalesHeadReqDto.setRefNo(csInOutResultRespDto.getDocumentNo());
            ArrayList itemReqDtoList = new ArrayList(detailList.size());
            String finalWarehouseCode = warehouseCode;
            DecimalFormat df = new DecimalFormat("#0.00");
            detailList.forEach(d -> {
                PushSalesItemReqDto item = new PushSalesItemReqDto();
                item.setCode(d.getSkuCode());
                item.setNum(df.format(d.getQuantity()));
                item.setWarehouseCode(finalWarehouseCode);
                item.setFactoryType(factoryType);
                itemReqDtoList.add(item);
            });
            salesTransferOrderReqDto.setSapSalesHeadReqDto(sapSalesHeadReqDto);
            salesTransferOrderReqDto.setItemReqDtoList(itemReqDtoList);
            logger.info("pushSaleTransferResultOrder\u53d1\u9001\u63a8\u9001\u5bc4\u552e\u8c03\u62e8mq\u6d88\u606f");
            this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "PUSH_CONSIGNMENT_TRANSFER_ORDER", (Object)JSON.toJSONString((Object)salesTransferOrderReqDto));
        }
    }

    private boolean getPushSapFlag(boolean inFlag, CsTransferOrderEo transferOrderEo) {
        String in = transferOrderEo.getInLogicWarehouseCode();
        String out = transferOrderEo.getOutLogicWarehouseCode();
        if (inFlag) {
            return "9999".equals(out);
        }
        return "9999".equals(in);
    }

    private void pushTransferInOutOrderToSap(CsOrderBusinessCallBackContext callBackContext, CsInOutResultRespDto csInOutResultRespDto, List<CsInOutResultDetailRespDto> detailList, CsTransferOrderEo transferOrder) {
        String moveType;
        String warehouseCode;
        String tag;
        PushTransferStorageOrderHeadReqDto head = new PushTransferStorageOrderHeadReqDto();
        head.setWarehouseCode(csInOutResultRespDto.getInLogicWarehouseCode());
        String factoryType = "1220";
        String sapNo = transferOrder.getSapNO();
        if (callBackContext.getInFlag().booleanValue()) {
            tag = "PUSH_TRANSFER_IN_ORDER";
            warehouseCode = csInOutResultRespDto.getInLogicWarehouseCode();
            moveType = "Z15";
        } else {
            tag = "PUSH_TRANSFER_OUT_ORDER";
            warehouseCode = csInOutResultRespDto.getOutLogicWarehouseCode();
            moveType = "Z13";
        }
        PushTransferStorageOrderReqDto pushTransferStorageOrderReqDto = new PushTransferStorageOrderReqDto();
        head.setId(callBackContext.getOutResultOrderId().toString());
        head.setSapNo(sapNo);
        head.setSapMoveType(moveType);
        head.setCreateDate(DateUtil.formatDateTime((Date)new Date()));
        head.setFactoryType(factoryType);
        head.setTransferOrderNo(transferOrder.getTransferOrderNo());
        head.setRefNo(csInOutResultRespDto.getDocumentNo());
        ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailList.size());
        DecimalFormat df = new DecimalFormat("#0.00");
        for (int i = 0; i < detailList.size(); ++i) {
            PushItemReqDto sapItemReqDto = new PushItemReqDto();
            sapItemReqDto.setCode(detailList.get(i).getSkuCode());
            sapItemReqDto.setRowNum(String.valueOf(i + 1));
            sapItemReqDto.setNum(df.format(detailList.get(i).getQuantity()));
            sapItemReqDto.setFactoryType(factoryType);
            sapItemReqDto.setWarehouseCode(warehouseCode);
            itemReqDtoList.add(sapItemReqDto);
        }
        pushTransferStorageOrderReqDto.setSapTransferStorageOrderHearReqDto(head);
        pushTransferStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{sapNo})) {
            logger.info("pushTransferInOutOrderToSap-pushTransferResultOrder\u53d1\u9001\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355mq\u6d88\u606f");
            this.commonsMqService.sendDelaySingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)pushTransferStorageOrderReqDto), Long.valueOf(10L));
        } else {
            CsTransferOrderRespDto transferOrderRespDto;
            logger.info("pushTransferInOutOrderToSap-\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355sap\u5355\u53f7\u7f3a\u5931,\u8c03\u62e8\u5355\u5355\u53f7\uff1a" + transferOrder.getTransferOrderNo());
            int num = 1;
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                transferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.queryByTransferOrderNo(transferOrder.getTransferOrderNo()));
                logger.info("pushTransferInOutOrderToSap-\u6839\u636e\u8c03\u62e8\u5355\u53f7\uff1a{} \u67e5\u8be2\uff1a{}\u6b21\uff0csapNo\uff1a{}", new Object[]{transferOrder.getTransferOrderNo(), num, transferOrderRespDto.getSapNO()});
            } while (StringUtils.isBlank((CharSequence)transferOrderRespDto.getSapNO()) && ++num < 180);
            if (StringUtils.isNotBlank((CharSequence)transferOrderRespDto.getSapNO())) {
                head.setSapNo(transferOrderRespDto.getSapNO());
                logger.info("pushTransferInOutOrderToSap-pushTransferResultOrder\u53d1\u9001\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355mq\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)pushTransferStorageOrderReqDto));
                this.commonsMqService.sendDelaySingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)pushTransferStorageOrderReqDto), Long.valueOf(10L));
            }
        }
    }

    private void generateReceiveNoticeOrder(CsOrderBusinessCallBackContext callBackContext) {
        logger.info("generateReceiveNoticeOrder==>\u8c03\u62e8\u5355\u56de\u8c03,\u751f\u6210\u6536\u8d27\u901a\u77e5\u5355\uff1a{}", (Object)JSON.toJSONString((Object)callBackContext));
        CsDeliveryReceiveResultRespDto resultRespDto = callBackContext.getCsDeliveryReceiveResultRespDto();
        List detail = resultRespDto.getDeliveryReceiveResultDetailRespDtoList();
        final CsTransferOrderEo transferOrderEo = this.getCsTransferOrderEo(resultRespDto.getRelevanceNo());
        ReceiveDeliveryNoticeOrderFacadeBo csBasicsOrderReqDto = new ReceiveDeliveryNoticeOrderFacadeBo();
        csBasicsOrderReqDto.setPreOrderNo(resultRespDto.getDocumentNo());
        csBasicsOrderReqDto.setExternalOrderNo(resultRespDto.getExternalOrderNo());
        csBasicsOrderReqDto.setDisplayBusinessType(transferOrderEo.getType());
        csBasicsOrderReqDto.setRelevanceNo(transferOrderEo.getTransferOrderNo());
        csBasicsOrderReqDto.setBusinessType(transferOrderEo.getType());
        csBasicsOrderReqDto.setRelevanceTableName(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER);
        csBasicsOrderReqDto.setLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
        csBasicsOrderReqDto.setLogicWarehouseName(transferOrderEo.getInLogicWarehouseName());
        csBasicsOrderReqDto.setPhysicsWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
        csBasicsOrderReqDto.setPhysicsWarehouseName(transferOrderEo.getInPhysicsWarehouseName());
        csBasicsOrderReqDto.setSourceType(CsInventorySourceTypeEnum.IN_ALLOT.getCode());
        csBasicsOrderReqDto.setRemark(resultRespDto.getRemark());
        csBasicsOrderReqDto.setCallBack((BaseOrderCallBack)new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
                ReceiveDeliveryNoticeOrderContext relContext = (ReceiveDeliveryNoticeOrderContext)context;
                ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = relContext.getReceiveDeliveryNoticeOrderEo();
                CsBdTransferOrderCallBackServiceImpl.this.transferOrderWrapperHelper.wrapperTransferOrderDelivery(receiveDeliveryNoticeOrderEo, transferOrderEo);
                CsBdTransferOrderCallBackServiceImpl.this.orderPreemptWrapperHelper.copyDeliveryToContext(relContext, receiveDeliveryNoticeOrderEo);
                if (CsPcpBusinessTypeEnum.ALLOT_BC_EFFICACY.getCode().equals(transferOrderEo.getType())) {
                    relContext.setSendWms(false);
                }
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                context.setCallBack(CsBdTransferOrderCallBackServiceImpl.this.getInNoticeCallBack(transferOrderEo));
                context.setTransparentCallback(Boolean.valueOf(true));
            }
        });
        csBasicsOrderReqDto.setOrderBasicsDetailReqDtoList(detail.stream().map(re -> {
            BaseOrderDetailReqDto basic = (BaseOrderDetailReqDto)BeanUtil.copyProperties((Object)re, BaseOrderDetailReqDto.class, (String[])new String[0]);
            basic.setSkuCode(re.getSkuCode());
            basic.setSkuName(Optional.ofNullable(re.getCargoName()).filter(StringUtil::isNotBlank).orElse(re.getSkuName()));
            return basic;
        }).collect(Collectors.toList()));
        this.baseOrderFacade.receiveNoticeOrderGen(csBasicsOrderReqDto);
    }

    @NotNull
    private BaseOrderCallBack<BaseOrderBaseContext> getInNoticeCallBack(final CsTransferOrderEo transferOrderEo) {
        return new BaseOrderCallBack<BaseOrderBaseContext>(){

            public void beforeCallBack(BaseOrderBaseContext context) {
            }

            public void afterCallBack(BaseOrderBaseContext context) {
                InOutNoticeOrderContext outNoticeOrderContext = (InOutNoticeOrderContext)context;
                outNoticeOrderContext.setSendWms(!CsPcpBusinessTypeEnum.ALLOT_BC_EFFICACY.getCode().equals(transferOrderEo.getType()));
                CsBdTransferOrderCallBackServiceImpl.this.updateOrderStatus(context.getRelevanceNo(), CsTransferOrderEnum.Status.WAIT_RECEIVE.getCode());
                if ("9999".equals(transferOrderEo.getInLogicWarehouseCode()) || CsPcpBusinessTypeEnum.DICT_ALLOT_STORE_RAISED.getCode().equals(transferOrderEo.getType())) {
                    logger.info("\u8c03\u62e8\u5355\u56de\u8c03inOutNoticeOrderCallBack==>\u5339\u914d\u5230\u5165\u5e93,callBackContext:{},transferOrderEo:{}", (Object)LogUtils.buildLogContent(context), (Object)LogUtils.buildLogContent(transferOrderEo));
                    logger.info("generateInOutOrder==>\u8c03\u62e8\u5355\u7c7b\u578b\u56de\u8c03,\u6a21\u62dfWMS\u56de\u8c03\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355");
                    CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
                    List sourceDetail = outNoticeOrderContext.getOrderBasicsDetailReqDtoList();
                    csBasicsReceiveReqDto.setPlatformOrderNo(transferOrderEo.getPreOrderNo());
                    csBasicsReceiveReqDto.setInOutNoticeOrderNo(outNoticeOrderContext.getDocumentNo());
                    csBasicsReceiveReqDto.setInOutTime(new Date());
                    csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
                    ArrayList detailReqDtoList = Lists.newArrayList();
                    for (BaseOrderDetailReqDto detailReqDto : sourceDetail) {
                        CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
                        inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
                        inSendBackDetailReqDto.setQuantity(detailReqDto.getQuantity());
                        inSendBackDetailReqDto.setSkuCode(detailReqDto.getSkuCode());
                        inSendBackDetailReqDto.setWarehouseCode(context.getLogicWarehouseCode());
                        inSendBackDetailReqDto.setTradeOrderItemId(detailReqDto.getPreOrderItemId());
                        inSendBackDetailReqDto.setLineNo(detailReqDto.getLineNo());
                        detailReqDtoList.add(inSendBackDetailReqDto);
                    }
                    csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
                    CsBdTransferOrderCallBackServiceImpl.this.csBdWmsExternalService.receiveIn(csBasicsReceiveReqDto);
                }
            }
        };
    }

    private void releaseLogicChannelInventory(CsOrderBusinessCallBackContext callBackContext) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        String status;
        logger.info("\u8c03\u62e8\u5355\u56de\u8c03relieveOverchargeCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        if (callBackContext.getInFlag().booleanValue()) {
            status = this.judgeStatus(callBackContext);
            this.increasePhysicsInventory(callBackContext);
        } else {
            status = CsTransferOrderEnum.Status.DELIVERED.getCode();
            this.deducePhysicsInventory(callBackContext, 0);
        }
        this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        String status;
        logger.info("\u8c03\u62e8\u5355\u56de\u8c03overchargeAdjustCallBack==>{}", (Object)LogUtils.buildLogContent(callBackContext));
        if (callBackContext.getInFlag().booleanValue()) {
            status = this.judgeStatus(callBackContext);
            this.increasePhysicsInventory(callBackContext);
        } else {
            status = CsTransferOrderEnum.Status.DELIVERED.getCode();
            this.deducePhysicsInventory(callBackContext, 0);
        }
        this.updateOrderStatus(callBackContext.getRelevanceNo(), status);
        return true;
    }

    private void increaseLogicInventory(CsOrderBusinessCallBackContext callBackContext) {
        CsDeliveryReceiveResultRespDto csBasicsOrderReqDto = callBackContext.getCsDeliveryReceiveResultRespDto();
        List detailList = csBasicsOrderReqDto.getDeliveryReceiveResultDetailRespDtoList();
        TransferInDto transferInDto = new TransferInDto();
        transferInDto.setSourceNo(csBasicsOrderReqDto.getRelevanceNo());
        transferInDto.setSourceType(CsInventorySourceTypeEnum.IN_ALLOT.getCode());
        transferInDto.setBusinessType(csBasicsOrderReqDto.getBusinessType());
        ArrayList outDetails = Lists.newArrayList();
        for (CsDeliveryReceiveResultDetailRespDto detailReqDto : detailList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            detailParam.setNum(detailReqDto.getQuantity().abs());
            detailParam.setSkuCode(detailReqDto.getCargoCode());
            detailParam.setLogicWarehouseCode(csBasicsOrderReqDto.getReceiveLogicWarehouseCode());
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            outDetails.add(detailParam);
        }
        transferInDto.setReleaseDetails((List)outDetails);
        if (!this.ignoreBatch) {
            logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u4ed3\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(transferInDto));
            this.calcInventoryService.transferIn(transferInDto);
            logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u4ed3\u5e93\u5b58\u5b8c\u6210");
        }
        for (CalcDetailDto cargoDto : transferInDto.getReleaseDetails()) {
            cargoDto.setBatch(null);
        }
        logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u603b\u4ed3\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(transferInDto));
        this.calcInventoryService.transferIn(transferInDto);
        logger.info("increaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u589e\u52a0\u903b\u8f91\u603b\u4ed3\u5e93\u5b58\u7ed3\u679c\u5b8c\u6210");
    }

    private Map<String, InOutNoticeOrderDetailEo> getOriginalOutNoticeOrderInfo(String relevanceNo) {
        List InOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)"in")).list();
        if (CollectionUtils.isEmpty((Collection)InOutNoticeOrderEoList)) {
            return Maps.newHashMap();
        }
        InOutNoticeOrderEo InOutNoticeOrderEo2 = (InOutNoticeOrderEo)InOutNoticeOrderEoList.get(0);
        String documentNo = InOutNoticeOrderEo2.getDocumentNo();
        List outNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
        if (CollectionUtils.isEmpty((Collection)outNoticeOrderDetailEoList)) {
            return Maps.newHashMap();
        }
        Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailEoMap = outNoticeOrderDetailEoList.stream().collect(Collectors.toMap(eo -> eo.getSkuCode() + "_" + eo.getPreOrderItemId(), Function.identity()));
        logger.info("getOutNoticeOrderInfo==>\u83b7\u53d6\u901a\u77e5\u5355\u660e\u7ec6\u4fe1\u606f,outNoticeOrderDetailEoMap:{}", (Object)LogUtils.buildLogContent(outNoticeOrderDetailEoMap));
        return outNoticeOrderDetailEoMap;
    }

    private void increaseLogicChannelInventory(CsOrderBusinessCallBackContext callBackContext) {
    }

    private void releaseLogicInventory(CsOrderBusinessCallBackContext callBackContext) {
        CsDeliveryReceiveResultRespDto csDeliveryReceiveResultRespDto = callBackContext.getCsDeliveryReceiveResultRespDto();
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(csDeliveryReceiveResultRespDto.getRelevanceNo());
        releasePreemptParam.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER_RELEASE.getCode());
        releasePreemptParam.setBusinessType(csDeliveryReceiveResultRespDto.getBusinessType());
        logger.info("releaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u91ca\u653e\u4ed3\u5e93\u5b58,csInventoryInOutBasicsDto:{}", (Object)LogUtils.buildLogContent(releasePreemptParam));
        this.calcInventoryService.releasePreempt(releasePreemptParam);
        logger.info("releaseLogicInventory==>\u8c03\u62e8\u5355\u56de\u8c03\u91ca\u653e\u4ed3\u5e93\u5b58\u5b8c\u6210");
    }

    private void increasePhysicsInventory(CsOrderBusinessCallBackContext callBackContext) {
    }

    private void deducePhysicsInventory(CsOrderBusinessCallBackContext callBackContext, int validate) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        CsCancelTransferOrderReqDto csCancelTransferOrderReqDto = new CsCancelTransferOrderReqDto();
        csCancelTransferOrderReqDto.setOutNoticeNo(callBackContext.getInOutNoticeNo());
        csCancelTransferOrderReqDto.setRemark(callBackContext.getRemark());
        csCancelTransferOrderReqDto.setCancelPerson(callBackContext.getOperatePerson());
        this.csTransferOrderApi.cancelTransferOrder(csCancelTransferOrderReqDto);
        return true;
    }

    @Override
    public void getContactsInfo(WmsStockOutOrderReqDto dto) {
    }

    @Override
    public void getContactsInfo(WmsStockEntryOrderReqDto dto) {
    }
}

