/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.mj.biz.commons.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.CsBasicsExternalStrategyUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.external.ICsBasicsExternalService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.CsUpdatePreemptServer;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.order.business.ICsBusinessOrderCallBackService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.IdUtils;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.inventory.CsTransferOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.in.CsInPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.eo.cs.order.out.CsOutPlannedOrderEo;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.inventory.CsTransferOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.in.CsInPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dao.mapper.cs.order.out.CsOutPlannedOrderMapper;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsReceiveReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsWmsBasicsDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOrderBusinessCallBackContext;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutMatchRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInOutResultDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.basics.CsInOutBasicsOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsBasicsExternalStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPlannedOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsValidFlagEnum;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.basicdata.api.IPcpDictApi;
import com.yunxi.dg.base.center.basicdata.enums.DictEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.FormInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FormOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsBasicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractCsBusinessOrderCallBackService
implements ICsBusinessOrderCallBackService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCsBusinessOrderCallBackService.class);
    @Autowired
    CsUpdatePreemptServer csUpdatePreemptServer;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;
    protected BigDecimal overchargeProportion = new BigDecimal(1);
    @Autowired
    IPcpDictApi pcpDictApi;
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Autowired
    IReceiveDeliveryNoticeOrderDetailDomain receiveDeliveryNoticeOrderDetailDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    CsOutPlannedOrderMapper csOutPlannedOrderMapper;
    @Autowired
    CsTransferOrderMapper csTransferOrderMapper;
    @Autowired
    ILogicInventoryDomain logicInventoryDomain;
    @Autowired
    CsInPlannedOrderMapper csInPlannedOrderMapper;
    @Value(value="${yunxi.dg.base.project}")
    public String projectCode;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Autowired
    IPhysicsWarehouseDomain physicsWarehouseDomain;

    @Override
    public String getStrategy() {
        return "common";
    }

    public String getPrefix() {
        return StringUtils.isNotEmpty((CharSequence)this.projectCode) ? this.projectCode : "";
    }

    @Override
    public Boolean deliveryReceiveNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean inOutNoticeOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        Boolean sendWms = callBackContext.getSendWms();
        if (!sendWms.booleanValue()) {
            String physicWarehouseCode;
            CsBasicsOrderReqDto csBasicsOrderReqDto = callBackContext.getCsBasicsOrderReqDto();
            String string = physicWarehouseCode = StringUtils.isNotBlank((CharSequence)csBasicsOrderReqDto.getPhysicsWarehouseCode()) ? csBasicsOrderReqDto.getPhysicsWarehouseCode() : csBasicsOrderReqDto.getInPhysicsWarehouseCode();
            if (callBackContext.getInFlag().booleanValue()) {
                this.generateWmsInCallbackOrder(callBackContext, physicWarehouseCode);
            } else {
                this.generateWmsOutCallbackOrder(callBackContext, physicWarehouseCode);
            }
        }
        return null;
    }

    private void generateWmsInCallbackOrder(CsOrderBusinessCallBackContext callBackContext, String physicWarehouseCode) {
        logger.info("generateWmsInCallbackOrder==>\u81ea\u52a8\u56de\u8c03\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355\uff0cdocumentNo:{}", (Object)callBackContext.getDocumentNo());
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsOrderReqDto basics = callBackContext.getCsBasicsOrderReqDto();
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        List sourceDetail = basics.getOrderBasicsDetailReqDtoList();
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(basics.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        csBasicsReceiveReqDto.setEnableAdjustInTransit(callBackContext.getEnableAdjustInTransit());
        csBasicsReceiveReqDto.setAdjustInTransitAutoAudit(callBackContext.getEnableAdjustInTransit());
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : sourceDetail) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
            inSendBackDetailReqDto.setQuantity(detailReqDto.getQuantity());
            inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
            inSendBackDetailReqDto.setWarehouseCode(physicWarehouseCode);
            inSendBackDetailReqDto.setExpireTime(detailReqDto.getExpireTime());
            inSendBackDetailReqDto.setProduceTime(detailReqDto.getProduceTime());
            inSendBackDetailReqDto.setTradeOrderItemId(detailReqDto.getTradeOrderItemId());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveIn(csBasicsReceiveReqDto);
    }

    private void generateWmsOutCallbackOrder(CsOrderBusinessCallBackContext callBackContext, String physicWarehouseCode) {
        logger.info("generateWmsOutCallbackOrder==>\u81ea\u52a8\u56de\u8c03\u751f\u6210\u51fa\u5e93\u7ed3\u679c\u5355,documentNo:{}", (Object)callBackContext.getDocumentNo());
        ICsBasicsExternalService wmsExternalService = CsBasicsExternalStrategyUtils.getBasicsOrderOperateService(CsBasicsExternalStrategyEnum.WMS.getCode());
        CsBasicsOrderReqDto basics = callBackContext.getCsBasicsOrderReqDto();
        CsBasicsReceiveReqDto csBasicsReceiveReqDto = new CsBasicsReceiveReqDto();
        List sourceDetail = basics.getOrderBasicsDetailReqDtoList();
        csBasicsReceiveReqDto.setPlatformOrderNo("-1");
        csBasicsReceiveReqDto.setInOutNoticeOrderNo(basics.getDocumentNo());
        csBasicsReceiveReqDto.setInOutTime(new Date());
        csBasicsReceiveReqDto.setWmsOrderNo(IdUtils.getId() + "");
        csBasicsReceiveReqDto.setAdjustInTransitAutoAudit(callBackContext.getEnableAdjustInTransit());
        csBasicsReceiveReqDto.setEnableAdjustInTransit(callBackContext.getEnableAdjustInTransit());
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (CsBasicsOrderDetailReqDto detailReqDto : sourceDetail) {
            CsWmsBasicsDetailReqDto inSendBackDetailReqDto = new CsWmsBasicsDetailReqDto();
            inSendBackDetailReqDto.setBatch(detailReqDto.getBatch());
            inSendBackDetailReqDto.setQuantity(detailReqDto.getQuantity());
            inSendBackDetailReqDto.setSkuCode(detailReqDto.getLongCode());
            inSendBackDetailReqDto.setWarehouseCode(physicWarehouseCode);
            inSendBackDetailReqDto.setTradeOrderItemId(detailReqDto.getTradeOrderItemId());
            detailReqDtoList.add(inSendBackDetailReqDto);
        }
        csBasicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        wmsExternalService.receiveOut(csBasicsReceiveReqDto);
    }

    @Override
    public Boolean inOutResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean deliveryReceiveResultOrderCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean relieveOverchargeCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean overchargeAdjustCallBack(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean wmsCancel(CsOrderBusinessCallBackContext callBackContext) {
        return null;
    }

    @Override
    public Boolean sendWms(InOutNoticeOrderEo outNoticeOrderEo) {
        String logicWarehouseCode = "";
        String physicsWarehouseCode = "";
        if ("out".equals(outNoticeOrderEo.getOrderType())) {
            logicWarehouseCode = outNoticeOrderEo.getOutLogicWarehouseCode();
            physicsWarehouseCode = outNoticeOrderEo.getOutPhysicsWarehouseCode();
        } else {
            logicWarehouseCode = outNoticeOrderEo.getInLogicWarehouseCode();
            physicsWarehouseCode = outNoticeOrderEo.getInPhysicsWarehouseCode();
        }
        AssertUtils.notEmpty((String)logicWarehouseCode, (String)"\u901a\u77e5\u5355\u903b\u8f91\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        List csLogicWarehouseEoList = this.logicWarehouseDomain.queryByCodes((List)Lists.newArrayList((Object[])new String[]{logicWarehouseCode}));
        LogicWarehouseEo csLogicWarehouseEo = (LogicWarehouseEo)csLogicWarehouseEoList.get(0);
        if (YesNoHelper.isYes((Integer)csLogicWarehouseEo.getIsVirtual())) {
            return false;
        }
        List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(physicsWarehouseCode);
        AssertUtils.notEmpty((Collection)physicsWarehouseEos, (String)"\u51fa\u5e93\u7269\u7406\u4ed3\u67e5\u8be2\u4e0d\u5b58\u5728");
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
        if (YesNoHelper.isYes((Integer)physicsWarehouseEo.getIsLogistics())) {
            return false;
        }
        return true;
    }

    private List<InventoryPreemptionEo> getInventoryPreemptionEos(String sourceNo) {
        List<String> warehouseTypeList = Arrays.asList(CsWarehouseClassifyEnum.LOGIC.getCode(), CsWarehouseClassifyEnum.PHYSICS.getCode());
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().in((Object)"warehouse_classify", warehouseTypeList)).eq((Object)"source_no", (Object)sourceNo)).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).list();
    }

    @Override
    public void groupByCargoCodeBatch(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        HashMap<String, CsWmsBasicsDetailReqDto> basicsDetailReqDtoMap = new HashMap<String, CsWmsBasicsDetailReqDto>();
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : detailReqDtoList) {
            String key = csWmsBasicsDetailReqDto.getSkuCode() + "_" + csWmsBasicsDetailReqDto.getBatch();
            CsWmsBasicsDetailReqDto wmsBasicsDetailReqDto = (CsWmsBasicsDetailReqDto)basicsDetailReqDtoMap.get(key);
            if (null == wmsBasicsDetailReqDto) {
                basicsDetailReqDtoMap.put(key, csWmsBasicsDetailReqDto);
                continue;
            }
            csWmsBasicsDetailReqDto.setQuantity(csWmsBasicsDetailReqDto.getQuantity().add(wmsBasicsDetailReqDto.getQuantity()));
            csWmsBasicsDetailReqDto.setVolume(csWmsBasicsDetailReqDto.getVolume().add(wmsBasicsDetailReqDto.getVolume()));
            csWmsBasicsDetailReqDto.setWeight(csWmsBasicsDetailReqDto.getWeight().add(wmsBasicsDetailReqDto.getWeight()));
            basicsDetailReqDtoMap.put(key, csWmsBasicsDetailReqDto);
        }
        ArrayList detailReqDtoList2 = new ArrayList(basicsDetailReqDtoMap.values());
        basicsReceiveBasicsReqDto.setDetailReqDtoList(detailReqDtoList2);
    }

    @Override
    public CsInOutMatchRespDto matchDetail(InOutNoticeOrderEo InOutNoticeOrderEo2, List<InOutNoticeOrderDetailEo> InOutNoticeOrderDetailEoList, CsBasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        HashMap<String, BigDecimal> cargoMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> cargoBatchMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> cargoPlanMap = new HashMap<String, BigDecimal>();
        HashMap<String, List<InOutNoticeOrderDetailEo>> batchMap = new HashMap<String, List<InOutNoticeOrderDetailEo>>();
        for (InOutNoticeOrderDetailEo detailEo : InOutNoticeOrderDetailEoList) {
            List noticeOrderDetailEoList;
            String key1 = detailEo.getSkuCode();
            String key2 = detailEo.getSkuCode() + "_" + detailEo.getBatch();
            BigDecimal quantity1 = (BigDecimal)cargoMap.get(key1);
            quantity1 = null == quantity1 ? BigDecimal.ZERO : quantity1;
            cargoMap.put(key1, quantity1.add(detailEo.getWaitQuantity()));
            BigDecimal quantity10 = (BigDecimal)cargoPlanMap.get(key1);
            quantity10 = null == quantity10 ? BigDecimal.ZERO : quantity10;
            cargoPlanMap.put(key1, quantity10.add(detailEo.getPlanQuantity()));
            if (StringUtils.isNotBlank((CharSequence)detailEo.getBatch())) {
                BigDecimal quantity2 = (BigDecimal)cargoBatchMap.get(key2);
                quantity2 = null == quantity2 ? BigDecimal.ZERO : quantity2;
                cargoBatchMap.put(key2, quantity2.add(detailEo.getWaitQuantity()));
                BigDecimal quantity20 = (BigDecimal)cargoPlanMap.get(key2);
                quantity20 = null == quantity20 ? BigDecimal.ZERO : quantity20;
                cargoPlanMap.put(key2, quantity20.add(detailEo.getPlanQuantity()));
            }
            noticeOrderDetailEoList = CollectionUtils.isEmpty((Collection)(noticeOrderDetailEoList = (List)batchMap.get(key1))) ? new ArrayList() : noticeOrderDetailEoList;
            noticeOrderDetailEoList.add(detailEo);
            batchMap.put(key1, noticeOrderDetailEoList);
        }
        CsInOutMatchRespDto matchRespDto = new CsInOutMatchRespDto();
        this.outMatch(InOutNoticeOrderEo2, basicsReceiveBasicsReqDto, detailReqDtoList, cargoMap, cargoBatchMap, matchRespDto);
        this.inMatch(InOutNoticeOrderEo2, basicsReceiveBasicsReqDto.getAllowBatchChange(), detailReqDtoList, cargoMap, cargoBatchMap, batchMap, cargoPlanMap, matchRespDto);
        if (!basicsReceiveBasicsReqDto.getIgnoreHandUp().booleanValue()) {
            if (!matchRespDto.getOverchargeFlag().booleanValue()) {
                String overchargeReason = this.checkOverchargeFlag(InOutNoticeOrderEo2, batchMap, detailReqDtoList, InOutNoticeOrderEo2);
                matchRespDto.setOverchargeReason(overchargeReason);
                matchRespDto.setOverchargeFlag(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)overchargeReason)));
            } else if ("out".equals(InOutNoticeOrderEo2.getOrderType())) {
                matchRespDto.setOverchargeReason("\u51fa\u5e93\u6570\u91cf\u8d85\u8fc7\u51c6\u51fa\u6570\u91cf\uff0c\u7cfb\u7edf\u6302\u8d77");
            } else {
                matchRespDto.setOverchargeReason("\u5165\u5e93\u6570\u91cf\u8d85\u8fc7\u51c6\u5165\u6570\u91cf\uff0c\u7cfb\u7edf\u6302\u8d77");
            }
        } else {
            matchRespDto.setOverchargeFlag(Boolean.valueOf(false));
        }
        matchRespDto.setDetailReqDtoList(basicsReceiveBasicsReqDto.getDetailReqDtoList());
        return matchRespDto;
    }

    private void outMatch(InOutNoticeOrderEo InOutNoticeOrderEo2, CsBasicsReceiveReqDto csBasicsReceiveReqDto, List<CsWmsBasicsDetailReqDto> detailReqDtoList, Map<String, BigDecimal> cargoMap, Map<String, BigDecimal> cargoBatchMap, CsInOutMatchRespDto matchRespDto) {
        if ("out".equals(InOutNoticeOrderEo2.getOrderType())) {
            Boolean allowBatchChange = csBasicsReceiveReqDto.getAllowBatchChange();
            List<InventoryPreemptionEo> preemptionEoList = this.inventoryPreemptionDomain.queryBySourceNo(InOutNoticeOrderEo2.getRelevanceNo(), CsValidFlagEnum.ENABLE.getCode());
            preemptionEoList = this.groupPreemptByCargoCodeBatch(preemptionEoList);
            this.allOrderDeal(csBasicsReceiveReqDto, detailReqDtoList, cargoMap, cargoBatchMap, matchRespDto, allowBatchChange, preemptionEoList);
            this.moreOrderDeal(csBasicsReceiveReqDto, detailReqDtoList, cargoMap, cargoBatchMap, matchRespDto, allowBatchChange, preemptionEoList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkOverchargeFlag(InOutNoticeOrderEo inOutNoticeOrderEo, Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos, InOutNoticeOrderEo noticeOrderEo) {
        logger.info("\u5f00\u59cb\u5904\u7406\u6302\u8d77\u5224\u65ad................");
        logger.info("noticeDetails: {}", (Object)LogUtils.buildLogContent(batchNoticeDetailEosMap));
        logger.info("wmsDetails: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
        boolean isEqualBatch = this.checkEqualBatch(batchNoticeDetailEosMap, wmsDetailDtos);
        boolean isEqualSum = this.checkEqualSum(batchNoticeDetailEosMap, wmsDetailDtos);
        logger.info("isEqualBatch: {}, isEqualSum: {}", (Object)isEqualBatch, (Object)isEqualSum);
        boolean inFlag = StringUtils.equals((CharSequence)"in", (CharSequence)noticeOrderEo.getOrderType());
        if (CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            if (!isEqualSum) {
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (inFlag) return "";
            return this.checkInventory(inOutNoticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (CsRelevanceTableNameEnum.CS_ORDER_SALE_REFUND.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            if (isEqualSum) return "";
            return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
        }
        if (CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            CsInPlannedOrderEo csInPlannedOrderEo = (CsInPlannedOrderEo)this.csInPlannedOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsInPlannedOrderEo.class).eq(CsInPlannedOrderEo::getOrderNo, (Object)noticeOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertNotNull(csInPlannedOrderEo, "\u8ba1\u5212\u5165\u8ba2\u5355\u67e5\u8be2\u4e0d\u5b58\u5728: {}", noticeOrderEo.getRelevanceNo());
            if (!CsPcpBusinessTypeEnum.PRODUCTION.getCode().equals(csInPlannedOrderEo.getBusinessType()) || isEqualBatch) return "";
            if (!inFlag) return "\u5b9e\u9645\u51fa\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u51fa\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
            return "\u5b9e\u9645\u5165\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u5165\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
        }
        if (CsRelevanceTableNameEnum.CS_OUT_PLANNED_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            CsOutPlannedOrderEo csOutPlannedOrderEo = (CsOutPlannedOrderEo)this.csOutPlannedOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsOutPlannedOrderEo.class).eq(CsOutPlannedOrderEo::getOrderNo, (Object)noticeOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            AssertUtil.assertNotNull(csOutPlannedOrderEo, "\u8ba1\u5212\u51fa\u8ba2\u5355\u67e5\u8be2\u4e0d\u5b58\u5728: {}", noticeOrderEo.getRelevanceNo());
            if (CsPcpBusinessTypeEnum.PURCHASE_REFUND.getCode().equals(csOutPlannedOrderEo.getBusinessType())) {
                if (isEqualSum) return this.checkInventory(inOutNoticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (!CsPcpBusinessTypeEnum.PRODUCT_REPAIR.getCode().equals(csOutPlannedOrderEo.getBusinessType())) return "";
            if (!isEqualBatch) {
                if (!inFlag) return "\u5b9e\u9645\u51fa\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u51fa\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
                return "\u5b9e\u9645\u5165\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u5165\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
            }
            if (isEqualSum) return "";
            return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
        }
        if (CsRelevanceTableNameEnum.CS_OTHER_STORAGE_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) {
            if (!isEqualSum) {
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (inFlag) return "";
            return this.checkInventory(inOutNoticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (!CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(noticeOrderEo.getRelevanceTableName())) return "";
        CsTransferOrderEo csTransferOrderEo = (CsTransferOrderEo)this.csTransferOrderMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CsTransferOrderEo.class).eq(CsTransferOrderEo::getTransferOrderNo, (Object)noticeOrderEo.getRelevanceNo())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        AssertUtil.assertNotNull(csTransferOrderEo, "\u8c03\u62e8\u5355\u5355\u67e5\u8be2\u4e0d\u5b58\u5728: {}", noticeOrderEo.getRelevanceNo());
        if (CsPcpBusinessTypeEnum.ALLOT_OUT.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode().equals(csTransferOrderEo.getType())) {
            if (inFlag) {
                if (!isEqualBatch) {
                    return "\u5b9e\u9645\u5165\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u5165\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
                }
                if (isEqualSum) return "";
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (!this.checkGt(batchNoticeDetailEosMap, wmsDetailDtos)) return this.checkInventory(inOutNoticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
            return "\u8d27\u54c1\u6570\u91cf\u5927\u4e8e\u6279\u6b21\u6570\u91cf";
        }
        if (CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualSum) {
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (inFlag) return "";
            return this.checkInventory(inOutNoticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (CsPcpBusinessTypeEnum.ALLOT_LOSE_EFFICACY.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.INSPECTION_UNQUALIFIED.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualBatch) {
                if (!inFlag) return "\u5b9e\u9645\u51fa\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u51fa\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
                return "\u5b9e\u9645\u5165\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u5165\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
            }
            if (isEqualSum) return "";
            return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
        }
        if (CsPcpBusinessTypeEnum.BC_ALLOT.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualSum) {
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (inFlag) return "";
            return this.checkInventory(inOutNoticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (CsPcpBusinessTypeEnum.CB_ALLOT.getCode().equals(csTransferOrderEo.getType())) {
            if (isEqualSum) return "";
            return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
        }
        if (CsPcpBusinessTypeEnum.CC_ALLOT.getCode().equals(csTransferOrderEo.getType())) {
            if (isEqualSum) return "";
            return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
        }
        if (CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualBatch) {
                if (!inFlag) return "\u5b9e\u9645\u51fa\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u51fa\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
                return "\u5b9e\u9645\u5165\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u5165\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
            }
            if (isEqualSum) return "";
            return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
        }
        if (CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode().equals(csTransferOrderEo.getType())) {
            if (!isEqualSum) {
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (inFlag) return "";
            return this.checkInventory(inOutNoticeOrderEo, batchNoticeDetailEosMap, wmsDetailDtos, inFlag);
        }
        if (CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(csTransferOrderEo.getType()) || CsPcpBusinessTypeEnum.ALLOT_SALE_BH.getCode().equals(csTransferOrderEo.getType())) {
            if (inFlag) {
                if (!isEqualBatch) {
                    return "\u5b9e\u9645\u5165\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u5165\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
                }
                if (isEqualSum) return "";
                return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
            }
            if (!this.checkGt(batchNoticeDetailEosMap, wmsDetailDtos)) return "";
            return "\u8d27\u54c1\u6570\u91cf\u5927\u4e8e\u6279\u6b21\u6570\u91cf";
        }
        if (!isEqualBatch) {
            if (!inFlag) return "\u5b9e\u9645\u51fa\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u51fa\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
            return "\u5b9e\u9645\u5165\u5e93\u6279\u6b21\u4e0e\u8ba1\u5212\u5165\u5e93\u6279\u6b21\u4e0d\u4e00\u81f4\uff0c\u7cfb\u7edf\u6302\u8d77";
        }
        if (isEqualSum) return "";
        return "\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d";
    }

    private boolean checkEqualBatch(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos) {
        boolean isEqualBatch = true;
        Map<String, List<CsWmsBasicsDetailReqDto>> batchWmsDetailsMap = wmsDetailDtos.stream().collect(Collectors.groupingBy(CsWmsBasicsDetailReqDto::getSkuCode));
        block0: for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> cargoEntry : batchNoticeDetailEosMap.entrySet()) {
            String cargoCode = cargoEntry.getKey();
            List<InOutNoticeOrderDetailEo> batchList = cargoEntry.getValue();
            List<CsWmsBasicsDetailReqDto> wmsBatchList = batchWmsDetailsMap.get(cargoCode);
            if (CollectionUtils.isEmpty(wmsBatchList)) {
                isEqualBatch = false;
                break;
            }
            for (InOutNoticeOrderDetailEo noticeDetailEo : batchList) {
                CsWmsBasicsDetailReqDto wmsDetailDto = wmsBatchList.stream().filter(o -> StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)noticeDetailEo.getBatch())).findFirst().orElse(null);
                if (null != wmsDetailDto) continue;
                isEqualBatch = false;
                continue block0;
            }
        }
        return isEqualBatch;
    }

    private boolean checkEqualSum(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos) {
        BigDecimal num;
        String cargoCode;
        boolean isEqualSum = true;
        HashMap noticeNumMap = Maps.newHashMap();
        HashMap wmsNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> entry : batchNoticeDetailEosMap.entrySet()) {
            cargoCode = entry.getKey();
            num = BigDecimal.ZERO;
            for (InOutNoticeOrderDetailEo detailEo : entry.getValue()) {
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getPlanQuantity());
            }
            noticeNumMap.put(cargoCode, num);
        }
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : wmsDetailDtos) {
            cargoCode = csWmsBasicsDetailReqDto.getSkuCode();
            num = (BigDecimal)wmsNumMap.get(cargoCode);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)csWmsBasicsDetailReqDto.getQuantity());
            wmsNumMap.put(cargoCode, num);
        }
        for (Map.Entry<String, List<Object>> entry : noticeNumMap.entrySet()) {
            cargoCode = entry.getKey();
            isEqualSum = BigDecimalUtils.equals((BigDecimal)((BigDecimal)((Object)entry.getValue())), (BigDecimal)((BigDecimal)wmsNumMap.get(cargoCode)));
            if (isEqualSum) continue;
            break;
        }
        return isEqualSum;
    }

    private boolean checkGt(Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos) {
        BigDecimal num;
        String cargoCode;
        Boolean hasGt = false;
        HashMap noticeNumMap = Maps.newHashMap();
        HashMap wmsNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> entry : batchNoticeDetailEosMap.entrySet()) {
            cargoCode = entry.getKey();
            num = BigDecimal.ZERO;
            for (InOutNoticeOrderDetailEo detailEo : entry.getValue()) {
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getPlanQuantity());
            }
            noticeNumMap.put(cargoCode, num);
        }
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : wmsDetailDtos) {
            cargoCode = csWmsBasicsDetailReqDto.getSkuCode();
            num = (BigDecimal)wmsNumMap.get(cargoCode);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)csWmsBasicsDetailReqDto.getQuantity());
            wmsNumMap.put(cargoCode, num);
        }
        for (Map.Entry<String, List<Object>> entry : noticeNumMap.entrySet()) {
            cargoCode = entry.getKey();
            BigDecimal noticeSum = (BigDecimal)((Object)entry.getValue());
            BigDecimal wmsSum = (BigDecimal)wmsNumMap.get(cargoCode);
            if (!BigDecimalUtils.gt((BigDecimal)wmsSum, (BigDecimal)noticeSum).booleanValue()) continue;
            hasGt = true;
            break;
        }
        return hasGt;
    }

    private String checkInventory(InOutNoticeOrderEo InOutNoticeOrderEo2, Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap, List<CsWmsBasicsDetailReqDto> wmsDetailDtos, boolean inFlag) {
        String overInventoryReason = "";
        String warehouseCode = inFlag ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
        List cargoCodes = wmsDetailDtos.stream().map(CsWmsBasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        List batches = wmsDetailDtos.stream().map(CsWmsBasicsDetailReqDto::getBatch).distinct().collect(Collectors.toList());
        if (StringUtils.isBlank((CharSequence)warehouseCode)) {
            logger.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)warehouseCode);
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u4ed3\u5e93\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        if (CollectionUtils.isEmpty(cargoCodes)) {
            logger.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u8d27\u54c1\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u8d27\u54c1\u7f16\u7801\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        if (CollectionUtils.isEmpty(batches)) {
            logger.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u6279\u6b21\u4fe1\u606f\u4e0d\u5b58\u5728";
        }
        List csLogicInventoryEos = this.logicInventoryDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).eq(LogicInventoryEo::getWarehouseCode, (Object)warehouseCode)).in(LogicInventoryEo::getSkuCode, cargoCodes)).in(LogicInventoryEo::getBatch, batches)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)csLogicInventoryEos)) {
            logger.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetailDtos));
            return "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728";
        }
        for (CsWmsBasicsDetailReqDto wmsDetail : wmsDetailDtos) {
            LogicInventoryEo csLogicInventoryEo = csLogicInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)wmsDetail.getSkuCode()) && StringUtils.equals((CharSequence)o.getBatch(), (CharSequence)wmsDetail.getBatch())).findFirst().orElse(null);
            if (null == csLogicInventoryEo) {
                logger.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object)LogUtils.buildLogContent(wmsDetail));
                overInventoryReason = "\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u67e5\u8be2\u4e0d\u5b58\u5728";
                break;
            }
            if (!BigDecimalUtils.gt((BigDecimal)wmsDetail.getQuantity(), (BigDecimal)csLogicInventoryEo.getBalance()).booleanValue()) continue;
            logger.info("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58\u65f6\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5e93\u5b58:{}, \u9700\u8981\u6263\u9664\u5e93\u5b58: {}", (Object)csLogicInventoryEo.getBalance(), (Object)wmsDetail.getQuantity());
            overInventoryReason = String.format("\u6302\u8d77\u903b\u8f91\u68c0\u67e5\u5e93\u5b58 \u903b\u8f91\u4ed3\uff1a%s, SKU\uff1a%s, \u6279\u6b21\uff1a%s\uff0c\u5e93\u5b58\u4fe1\u606f\u660e\u7ec6\u4e0d\u591f\u6263\u9664: \u5e93\u5b58\u5269\u4f59\u5e93\u5b58:%s, \u9700\u8981\u6263\u9664\u5e93\u5b58: %s", csLogicInventoryEo.getWarehouseName(), wmsDetail.getSkuCode(), wmsDetail.getBatch(), csLogicInventoryEo.getBalance(), wmsDetail.getQuantity());
            break;
        }
        return overInventoryReason;
    }

    public List<InventoryPreemptionEo> groupPreemptByCargoCodeBatch(List<InventoryPreemptionEo> preemptionEoList) {
        HashMap<String, InventoryPreemptionEo> basicsDetailReqDtoMap = new HashMap<String, InventoryPreemptionEo>();
        for (InventoryPreemptionEo preemptionEo : preemptionEoList) {
            String key = preemptionEo.getSkuCode() + "_" + preemptionEo.getBatch();
            InventoryPreemptionEo InventoryPreemptionEo2 = (InventoryPreemptionEo)basicsDetailReqDtoMap.get(key);
            if (null == InventoryPreemptionEo2) {
                basicsDetailReqDtoMap.put(key, preemptionEo);
                continue;
            }
            InventoryPreemptionEo2.setPreemptNum(preemptionEo.getPreemptNum().add(preemptionEo.getPreemptNum()));
            basicsDetailReqDtoMap.put(key, InventoryPreemptionEo2);
        }
        ArrayList<InventoryPreemptionEo> detailReqDtoList = new ArrayList<InventoryPreemptionEo>(basicsDetailReqDtoMap.values());
        return detailReqDtoList;
    }

    private void inMatch(InOutNoticeOrderEo InOutNoticeOrderEo2, Boolean allowBatchChange, List<CsWmsBasicsDetailReqDto> detailReqDtoList, Map<String, BigDecimal> cargoMap, Map<String, BigDecimal> cargoBatchMap, Map<String, List<InOutNoticeOrderDetailEo>> batchMap, Map<String, BigDecimal> cargoPlanMap, CsInOutMatchRespDto matchRespDto) {
        if ("in".equals(InOutNoticeOrderEo2.getOrderType())) {
            this.buildOverchargeProportion(InOutNoticeOrderEo2);
            ArrayList<CsInOutBasicsOrderDetailRespDto> totalInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            ArrayList<CsInOutBasicsOrderDetailRespDto> batchInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            HashMap<String, BigDecimal> baseCargoMap = new HashMap<String, BigDecimal>();
            for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : detailReqDtoList) {
                String key = csWmsBasicsDetailReqDto.getSkuCode();
                String key1 = csWmsBasicsDetailReqDto.getSkuCode() + "_" + csWmsBasicsDetailReqDto.getBatch();
                BigDecimal quantity = (BigDecimal)baseCargoMap.get(key);
                quantity = null == quantity ? csWmsBasicsDetailReqDto.getQuantity() : quantity.add(csWmsBasicsDetailReqDto.getQuantity());
                baseCargoMap.put(key, quantity);
                BigDecimal totalPlanQuantity = cargoPlanMap.get(key);
                BigDecimal batchPlanQuantity = cargoPlanMap.get(key1);
                BigDecimal totalQuantity = cargoMap.get(key);
                BigDecimal batchQuantity = cargoBatchMap.get(key1);
                AssertUtil.isTrue(null != totalQuantity, "\u8d27\u54c1\u4e0d\u53ef\u53d8\u66f4\uff0c\u539f\u5355\u6ca1\u6709\u8be5\u8d27\u54c1\uff0c\u8d27\u54c1\u7f16\u7801:" + csWmsBasicsDetailReqDto.getSkuCode());
                if (!allowBatchChange.booleanValue() && cargoBatchMap.size() > 0) {
                    AssertUtil.isTrue(null != batchQuantity, "\u5f53\u524d\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u53d8\u66f4\u6279\u6b21\uff0c\u539f\u5355\u6ca1\u6709\u8be5\u8d27\u54c1\u6279\u6b21\uff0c\u8d27\u54c1\u7f16\u7801:" + csWmsBasicsDetailReqDto.getSkuCode() + "\u6279\u6b21" + csWmsBasicsDetailReqDto.getBatch());
                }
                CsInOutBasicsOrderDetailRespDto basicsOrderDetailRespDto = new CsInOutBasicsOrderDetailRespDto();
                basicsOrderDetailRespDto.setLongCode(csWmsBasicsDetailReqDto.getSkuCode());
                basicsOrderDetailRespDto.setCargoCode(csWmsBasicsDetailReqDto.getSkuCode());
                basicsOrderDetailRespDto.setExpireTime(csWmsBasicsDetailReqDto.getExpireTime());
                basicsOrderDetailRespDto.setProduceTime(csWmsBasicsDetailReqDto.getProduceTime());
                BigDecimal enableOverchargeVal = totalPlanQuantity.multiply(this.overchargeProportion).subtract(totalPlanQuantity.subtract(totalQuantity));
                if (csWmsBasicsDetailReqDto.getQuantity().compareTo(enableOverchargeVal) > 0 || quantity.compareTo(enableOverchargeVal) > 0) {
                    logger.info("wms\u56de\u4f20\u64cd\u4f5c\uff0c\u8d85\u5165\u4e86\uff1anoticeNo{},\u53ef\u5165\u6570\u91cf\uff1a{}", (Object)InOutNoticeOrderEo2.getDocumentNo(), (Object)enableOverchargeVal);
                    matchRespDto.setOverchargeFlag(Boolean.valueOf(true));
                }
                if (null != batchQuantity) {
                    BigDecimal inNum;
                    basicsOrderDetailRespDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
                    basicsOrderDetailRespDto.setBalance(csWmsBasicsDetailReqDto.getQuantity());
                    BigDecimal waitNum = totalQuantity.subtract(quantity).add(csWmsBasicsDetailReqDto.getQuantity());
                    waitNum = BigDecimal.ZERO.compareTo(waitNum) > 0 ? BigDecimal.ZERO : waitNum;
                    BigDecimal bigDecimal = inNum = totalQuantity.compareTo(quantity) > 0 ? csWmsBasicsDetailReqDto.getQuantity() : waitNum;
                    inNum = BigDecimal.ZERO.compareTo(batchQuantity) > 0 ? BigDecimal.ZERO : (inNum.compareTo(batchQuantity) > 0 ? batchQuantity : inNum);
                    basicsOrderDetailRespDto.setInNum(inNum.negate());
                    batchInventoryList.add(basicsOrderDetailRespDto);
                    BigDecimal enableOverchargeVal1 = batchPlanQuantity.multiply(this.overchargeProportion).subtract(batchPlanQuantity.subtract(batchQuantity));
                    if (csWmsBasicsDetailReqDto.getQuantity().compareTo(enableOverchargeVal1) > 0) {
                        logger.info("wms\u56de\u4f20\u64cd\u4f5c\uff0c\u8d85\u5165\u4e86\uff08\u6279\u6b21\uff09\uff1anoticeNo{},\u53ef\u5165\u6570\u91cf\uff1a{}", (Object)InOutNoticeOrderEo2.getDocumentNo(), (Object)enableOverchargeVal1);
                        matchRespDto.setOverchargeFlag(Boolean.valueOf(true));
                    }
                }
                if (null == batchQuantity && cargoBatchMap.size() == 0) {
                    basicsOrderDetailRespDto.setBalance(csWmsBasicsDetailReqDto.getQuantity());
                    basicsOrderDetailRespDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
                    batchInventoryList.add(basicsOrderDetailRespDto);
                    CsInOutBasicsOrderDetailRespDto basicsOrderDetailRespDto2 = new CsInOutBasicsOrderDetailRespDto();
                    basicsOrderDetailRespDto2.setLongCode(csWmsBasicsDetailReqDto.getSkuCode());
                    basicsOrderDetailRespDto2.setCargoCode(csWmsBasicsDetailReqDto.getSkuCode());
                    basicsOrderDetailRespDto2.setBalance(csWmsBasicsDetailReqDto.getQuantity());
                    BigDecimal waitNum = totalQuantity.subtract(quantity).add(csWmsBasicsDetailReqDto.getQuantity());
                    waitNum = BigDecimal.ZERO.compareTo(waitNum) > 0 ? BigDecimal.ZERO : waitNum;
                    BigDecimal inNum = totalQuantity.compareTo(quantity) > 0 ? csWmsBasicsDetailReqDto.getQuantity() : waitNum;
                    basicsOrderDetailRespDto2.setInNum(inNum.negate());
                    totalInventoryList.add(basicsOrderDetailRespDto2);
                }
                if (null != batchQuantity || cargoBatchMap.size() <= 0) continue;
                basicsOrderDetailRespDto.setBalance(csWmsBasicsDetailReqDto.getQuantity());
                basicsOrderDetailRespDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
                batchInventoryList.add(basicsOrderDetailRespDto);
                List<InOutNoticeOrderDetailEo> noticeOrderDetailEoList = batchMap.get(csWmsBasicsDetailReqDto.getSkuCode());
                for (InOutNoticeOrderDetailEo InOutNoticeOrderDetailEo2 : noticeOrderDetailEoList) {
                    CsInOutBasicsOrderDetailRespDto basicsOrderDetailRespDto2 = new CsInOutBasicsOrderDetailRespDto();
                    basicsOrderDetailRespDto2.setProduceTime(csWmsBasicsDetailReqDto.getProduceTime());
                    basicsOrderDetailRespDto2.setExpireTime(csWmsBasicsDetailReqDto.getExpireTime());
                    basicsOrderDetailRespDto2.setLongCode(csWmsBasicsDetailReqDto.getSkuCode());
                    basicsOrderDetailRespDto2.setCargoCode(csWmsBasicsDetailReqDto.getSkuCode());
                    BigDecimal waitNum = InOutNoticeOrderDetailEo2.getWaitQuantity().subtract(quantity).add(csWmsBasicsDetailReqDto.getQuantity());
                    waitNum = BigDecimal.ZERO.compareTo(waitNum) > 0 ? BigDecimal.ZERO : waitNum;
                    BigDecimal inNum = InOutNoticeOrderDetailEo2.getWaitQuantity().compareTo(quantity) > 0 ? csWmsBasicsDetailReqDto.getQuantity() : waitNum;
                    basicsOrderDetailRespDto2.setInNum(inNum.negate());
                    basicsOrderDetailRespDto2.setBatch(InOutNoticeOrderDetailEo2.getBatch());
                    batchInventoryList.add(basicsOrderDetailRespDto2);
                }
            }
            matchRespDto.setTotalInventoryList(totalInventoryList);
            matchRespDto.setBatchInventoryList(batchInventoryList);
        }
    }

    protected void buildOverchargeProportion(InOutNoticeOrderEo InOutNoticeOrderEo2) {
        logger.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,InOutNoticeOrderEo:{}", (Object)LogUtils.buildLogContent(InOutNoticeOrderEo2));
        String relevanceTableName = InOutNoticeOrderEo2.getRelevanceTableName();
        if (!CsRelevanceTableNameEnum.CS_IN_PLANNED_ORDER.getCode().equals(relevanceTableName)) {
            this.overchargeProportion = BigDecimal.ONE;
            return;
        }
        String orderType = InOutNoticeOrderEo2.getOrderType();
        if (!"in".equals(orderType)) {
            this.overchargeProportion = BigDecimal.ONE;
            return;
        }
        String plannedOrderType = InOutNoticeOrderEo2.getBusinessType();
        String code = DictEnum.PURCHASE_ORDER_RATIO.getCode();
        if (CsPlannedOrderTypeEnum.PRODUCTION.getCode().equals(plannedOrderType)) {
            code = DictEnum.PRODUCTION_ORDER_RATIO.getCode();
        } else if (CsPlannedOrderTypeEnum.OUTSOURCE.getCode().equals(plannedOrderType)) {
            code = DictEnum.OUT_SOURCED_ORDER_RATIO.getCode();
        }
        try {
            logger.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,GROUP_CODE:{},code:{}", (Object)DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), (Object)code);
            RestResponse dtoRestResponse = this.pcpDictApi.queryByGroupCodeAndCode(DictEnum.PURCHASE_ORDER_RATIO.getGroupCode(), code);
            DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dtoRestResponse);
            logger.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,dictDto:{}", (Object)LogUtils.buildLogContent(dictDto));
            if (null != dictDto) {
                String value = dictDto.getValue();
                BigDecimal decimalVal = BigDecimalUtils.divide((BigDecimal)BigDecimalUtils.parse((String)value), (BigDecimal)BigDecimalUtils.ONE_HUNDRED, (int)4);
                this.overchargeProportion = BigDecimalUtils.add((BigDecimal)decimalVal, (BigDecimal)BigDecimal.ONE);
                logger.info("buildOverchargeProportion==>\u83b7\u53d6\u8d85\u6536\u6bd4\u4f8b,\u57fa\u7840\u6570\u636e\u4e2d\u5fc3\u8ba1\u7b97\u4e4b\u540e\u7684,overchargeProportion:{}", (Object)this.overchargeProportion);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void moreOrderDeal(CsBasicsReceiveReqDto csBasicsReceiveReqDto, List<CsWmsBasicsDetailReqDto> detailReqDtoList, Map<String, BigDecimal> cargoMap, Map<String, BigDecimal> cargoBatchMap, CsInOutMatchRespDto matchRespDto, Boolean allowBatchChange, List<InventoryPreemptionEo> preemptionEoList) {
        if (!YesNoHelper.YES.equals(csBasicsReceiveReqDto.getIsAllDeal())) {
            logger.info("\u5141\u8bb8\u591a\u6b21\u5904\u7406");
            HashMap<String, BigDecimal> cargoMap1 = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> cargoBatchMap1 = new HashMap<String, BigDecimal>();
            for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : csBasicsReceiveReqDto.getDetailReqDtoList()) {
                String key1 = csWmsBasicsDetailReqDto.getSkuCode();
                String key2 = csWmsBasicsDetailReqDto.getSkuCode() + "_" + csWmsBasicsDetailReqDto.getBatch();
                BigDecimal quantity1 = (BigDecimal)cargoMap1.get(key1);
                quantity1 = null == quantity1 ? BigDecimal.ZERO : quantity1;
                cargoMap1.put(key1, quantity1.add(csWmsBasicsDetailReqDto.getQuantity()));
                if (!StringUtils.isNotBlank((CharSequence)csWmsBasicsDetailReqDto.getBatch())) continue;
                cargoBatchMap1.put(key2, csWmsBasicsDetailReqDto.getQuantity());
            }
            ArrayList<CsInOutBasicsOrderDetailRespDto> logicInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            ArrayList<CsInOutBasicsOrderDetailRespDto> logicTotalInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            ArrayList<CsInOutBasicsOrderDetailRespDto> physicsInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            ArrayList<CsInOutBasicsOrderDetailRespDto> physicsTotalInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            this.joinMorePreempt(matchRespDto, preemptionEoList, cargoMap1, cargoBatchMap1, logicInventoryList, logicTotalInventoryList, physicsInventoryList, physicsTotalInventoryList);
            ArrayList<CsInOutBasicsOrderDetailRespDto> batchChangeInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            this.judgeAndJoin(detailReqDtoList, cargoMap, cargoBatchMap, matchRespDto, allowBatchChange, logicInventoryList, logicTotalInventoryList, physicsInventoryList, physicsTotalInventoryList, batchChangeInventoryList);
            matchRespDto.setLogicInventoryList(logicInventoryList);
            matchRespDto.setLogicTotalInventoryList(logicTotalInventoryList);
            matchRespDto.setPhysicsInventoryList(physicsInventoryList);
            matchRespDto.setPhysicsTotalInventoryList(physicsTotalInventoryList);
            matchRespDto.setBatchChangeInventoryList(batchChangeInventoryList);
        }
    }

    private void joinMorePreempt(CsInOutMatchRespDto matchRespDto, List<InventoryPreemptionEo> preemptionEoList, Map<String, BigDecimal> cargoMap1, Map<String, BigDecimal> cargoBatchMap1, List<CsInOutBasicsOrderDetailRespDto> logicInventoryList, List<CsInOutBasicsOrderDetailRespDto> logicTotalInventoryList, List<CsInOutBasicsOrderDetailRespDto> physicsInventoryList, List<CsInOutBasicsOrderDetailRespDto> physicsTotalInventoryList) {
        for (InventoryPreemptionEo preemptionEo : preemptionEoList) {
            BigDecimal balance;
            CsInOutBasicsOrderDetailRespDto basicsOrderDetailRespDto = new CsInOutBasicsOrderDetailRespDto();
            basicsOrderDetailRespDto.setLongCode(preemptionEo.getSkuCode());
            basicsOrderDetailRespDto.setPreempt(preemptionEo.getPreemptNum().negate());
            basicsOrderDetailRespDto.setBatch(preemptionEo.getBatch());
            String key1 = preemptionEo.getSkuCode();
            String key2 = preemptionEo.getSkuCode() + "_" + preemptionEo.getBatch();
            if (CsWarehouseClassifyEnum.PHYSICS.getCode().equals(preemptionEo.getWarehouseClassify())) {
                if (StringUtils.isNotBlank((CharSequence)preemptionEo.getBatch())) {
                    balance = cargoBatchMap1.get(key2);
                    if (null == balance) continue;
                    basicsOrderDetailRespDto.setBalance(balance.negate());
                    physicsInventoryList.add(basicsOrderDetailRespDto);
                    continue;
                }
                balance = cargoMap1.get(key1);
                if (null == balance) continue;
                basicsOrderDetailRespDto.setBalance(balance.negate());
                physicsTotalInventoryList.add(basicsOrderDetailRespDto);
                continue;
            }
            if (!CsWarehouseClassifyEnum.LOGIC.getCode().equals(preemptionEo.getWarehouseClassify())) continue;
            if (StringUtils.isNotBlank((CharSequence)preemptionEo.getBatch())) {
                balance = cargoBatchMap1.get(key2);
                if (null == balance) continue;
                basicsOrderDetailRespDto.setBalance(balance.negate());
                logicInventoryList.add(basicsOrderDetailRespDto);
                continue;
            }
            balance = cargoMap1.get(key1);
            if (null == balance) continue;
            basicsOrderDetailRespDto.setBalance(balance.negate());
            logicTotalInventoryList.add(basicsOrderDetailRespDto);
        }
    }

    private void judgeAndJoin(List<CsWmsBasicsDetailReqDto> detailReqDtoList, Map<String, BigDecimal> cargoMap, Map<String, BigDecimal> cargoBatchMap, CsInOutMatchRespDto matchRespDto, Boolean allowBatchChange, List<CsInOutBasicsOrderDetailRespDto> logicInventoryList, List<CsInOutBasicsOrderDetailRespDto> logicTotalInventoryList, List<CsInOutBasicsOrderDetailRespDto> physicsInventoryList, List<CsInOutBasicsOrderDetailRespDto> physicsTotalInventoryList, List<CsInOutBasicsOrderDetailRespDto> batchChangeInventoryList) {
        HashMap<String, BigDecimal> baseCargoMap = new HashMap<String, BigDecimal>();
        for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : detailReqDtoList) {
            String key = csWmsBasicsDetailReqDto.getSkuCode();
            BigDecimal quantity = (BigDecimal)baseCargoMap.get(key);
            quantity = null == quantity ? csWmsBasicsDetailReqDto.getQuantity() : quantity.add(csWmsBasicsDetailReqDto.getQuantity());
            baseCargoMap.put(key, quantity);
            BigDecimal totalQuantity = cargoMap.get(csWmsBasicsDetailReqDto.getSkuCode());
            BigDecimal batchQuantity = cargoBatchMap.get(csWmsBasicsDetailReqDto.getSkuCode() + "_" + csWmsBasicsDetailReqDto.getBatch());
            AssertUtil.isTrue(null != totalQuantity, "\u8d27\u54c1\u4e0d\u53ef\u53d8\u66f4\uff0c\u539f\u5355\u6ca1\u6709\u8be5\u8d27\u54c1\uff0c\u8d27\u54c1\u7f16\u7801:" + csWmsBasicsDetailReqDto.getSkuCode());
            if (!allowBatchChange.booleanValue() && cargoBatchMap.size() > 0) {
                AssertUtil.isTrue(null != batchQuantity, "\u5f53\u524d\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u53d8\u66f4\u6279\u6b21\uff0c\u539f\u5355\u6ca1\u6709\u8be5\u8d27\u54c1\u6279\u6b21\uff0c\u8d27\u54c1\u7f16\u7801:" + csWmsBasicsDetailReqDto.getSkuCode() + "\u6279\u6b21" + csWmsBasicsDetailReqDto.getBatch());
            }
            if (csWmsBasicsDetailReqDto.getQuantity().compareTo(totalQuantity) > 0 || quantity.compareTo(totalQuantity) > 0) {
                matchRespDto.setOverchargeFlag(Boolean.valueOf(true));
                break;
            }
            if (null != batchQuantity || cargoBatchMap.size() <= 0) continue;
            CsInOutBasicsOrderDetailRespDto basicsOrderDetailRespDto = new CsInOutBasicsOrderDetailRespDto();
            basicsOrderDetailRespDto.setLongCode(csWmsBasicsDetailReqDto.getSkuCode());
            basicsOrderDetailRespDto.setCargoCode(csWmsBasicsDetailReqDto.getSkuCode());
            basicsOrderDetailRespDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
            basicsOrderDetailRespDto.setBalance(csWmsBasicsDetailReqDto.getQuantity().negate());
            batchChangeInventoryList.add(basicsOrderDetailRespDto);
            logicInventoryList.add(basicsOrderDetailRespDto);
            logicTotalInventoryList.add(basicsOrderDetailRespDto);
            physicsInventoryList.add(basicsOrderDetailRespDto);
            physicsTotalInventoryList.add(basicsOrderDetailRespDto);
        }
    }

    private void allOrderDeal(CsBasicsReceiveReqDto csBasicsReceiveReqDto, List<CsWmsBasicsDetailReqDto> detailReqDtoList, Map<String, BigDecimal> cargoMap, Map<String, BigDecimal> cargoBatchMap, CsInOutMatchRespDto matchRespDto, Boolean allowBatchChange, List<InventoryPreemptionEo> preemptionEoList) {
        if (YesNoHelper.YES.equals(csBasicsReceiveReqDto.getIsAllDeal())) {
            logger.info("\u6574\u5355\u5904\u7406");
            HashMap<String, BigDecimal> cargoMap1 = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> cargoBatchMap1 = new HashMap<String, BigDecimal>();
            for (CsWmsBasicsDetailReqDto csWmsBasicsDetailReqDto : csBasicsReceiveReqDto.getDetailReqDtoList()) {
                String key1 = csWmsBasicsDetailReqDto.getSkuCode();
                String key2 = csWmsBasicsDetailReqDto.getSkuCode() + "_" + csWmsBasicsDetailReqDto.getBatch();
                BigDecimal quantity1 = (BigDecimal)cargoMap1.get(key1);
                quantity1 = null == quantity1 ? BigDecimal.ZERO : quantity1;
                cargoMap1.put(key1, quantity1.add(csWmsBasicsDetailReqDto.getQuantity()));
                if (!StringUtils.isNotBlank((CharSequence)csWmsBasicsDetailReqDto.getBatch())) continue;
                cargoBatchMap1.put(key2, csWmsBasicsDetailReqDto.getQuantity());
            }
            ArrayList<CsInOutBasicsOrderDetailRespDto> logicInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            ArrayList<CsInOutBasicsOrderDetailRespDto> logicTotalInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            ArrayList<CsInOutBasicsOrderDetailRespDto> physicsInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            ArrayList<CsInOutBasicsOrderDetailRespDto> physicsTotalInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            this.joinOnePreempt(preemptionEoList, cargoMap1, cargoBatchMap1, logicInventoryList, logicTotalInventoryList, physicsInventoryList, physicsTotalInventoryList);
            ArrayList<CsInOutBasicsOrderDetailRespDto> batchChangeInventoryList = new ArrayList<CsInOutBasicsOrderDetailRespDto>();
            this.judgeAndJoin(detailReqDtoList, cargoMap, cargoBatchMap, matchRespDto, allowBatchChange, logicInventoryList, logicTotalInventoryList, physicsInventoryList, physicsTotalInventoryList, batchChangeInventoryList);
            matchRespDto.setLogicInventoryList(logicInventoryList);
            matchRespDto.setLogicTotalInventoryList(logicTotalInventoryList);
            matchRespDto.setPhysicsInventoryList(physicsInventoryList);
            matchRespDto.setPhysicsTotalInventoryList(physicsTotalInventoryList);
            matchRespDto.setBatchChangeInventoryList(batchChangeInventoryList);
        }
    }

    private void joinOnePreempt(List<InventoryPreemptionEo> preemptionEoList, Map<String, BigDecimal> cargoMap1, Map<String, BigDecimal> cargoBatchMap1, List<CsInOutBasicsOrderDetailRespDto> logicInventoryList, List<CsInOutBasicsOrderDetailRespDto> logicTotalInventoryList, List<CsInOutBasicsOrderDetailRespDto> physicsInventoryList, List<CsInOutBasicsOrderDetailRespDto> physicsTotalInventoryList) {
        for (InventoryPreemptionEo preemptionEo : preemptionEoList) {
            BigDecimal balance;
            CsInOutBasicsOrderDetailRespDto basicsOrderDetailRespDto = new CsInOutBasicsOrderDetailRespDto();
            basicsOrderDetailRespDto.setLongCode(preemptionEo.getSkuCode());
            basicsOrderDetailRespDto.setPreempt(preemptionEo.getPreemptNum().negate());
            basicsOrderDetailRespDto.setBatch(preemptionEo.getBatch());
            String key1 = preemptionEo.getSkuCode();
            String key2 = preemptionEo.getSkuCode() + "_" + preemptionEo.getBatch();
            if (CsWarehouseClassifyEnum.PHYSICS.getCode().equals(preemptionEo.getWarehouseClassify())) {
                if (StringUtils.isNotBlank((CharSequence)preemptionEo.getBatch())) {
                    balance = cargoBatchMap1.get(key2);
                    if (null != balance) {
                        balance = balance.negate();
                    }
                    basicsOrderDetailRespDto.setBalance(balance);
                    physicsInventoryList.add(basicsOrderDetailRespDto);
                    continue;
                }
                balance = cargoMap1.get(key1);
                if (null != balance) {
                    balance = balance.negate();
                }
                basicsOrderDetailRespDto.setBalance(balance);
                physicsTotalInventoryList.add(basicsOrderDetailRespDto);
                continue;
            }
            if (!CsWarehouseClassifyEnum.LOGIC.getCode().equals(preemptionEo.getWarehouseClassify())) continue;
            if (StringUtils.isNotBlank((CharSequence)preemptionEo.getBatch())) {
                balance = cargoBatchMap1.get(key2);
                if (null != balance) {
                    balance = balance.negate();
                }
                basicsOrderDetailRespDto.setBalance(balance);
                logicInventoryList.add(basicsOrderDetailRespDto);
                continue;
            }
            balance = cargoMap1.get(key1);
            if (null != balance) {
                balance = balance.negate();
            }
            basicsOrderDetailRespDto.setBalance(balance);
            logicTotalInventoryList.add(basicsOrderDetailRespDto);
        }
    }

    @Override
    public void inInventoryDeal(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2, boolean inFlag) {
        if (inFlag) {
            this.balanceIn(csInOutMatchRespDto, InOutNoticeOrderEo2);
        }
    }

    private void balanceIn(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2) {
        FormInDto param = new FormInDto();
        param.setSourceNo(InOutNoticeOrderEo2.getRelevanceNo());
        param.setSourceType(InOutNoticeOrderEo2.getBusinessType());
        param.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        param.setExternalOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        ArrayList detailParams = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)csInOutMatchRespDto.getBatchInventoryList())) {
            for (CsInOutBasicsOrderDetailRespDto detailReqDto : csInOutMatchRespDto.getBatchInventoryList()) {
                CalcDetailDto detailParam = new CalcDetailDto();
                BigDecimal balance = BigDecimalUtils.abs((BigDecimal)detailReqDto.getBalance());
                detailParam.setNum(balance);
                if (BigDecimalUtils.eqZero((BigDecimal)balance).booleanValue()) continue;
                detailParam.setSkuCode(detailReqDto.getLongCode());
                String warehouseCode = StringUtils.isNotBlank((CharSequence)InOutNoticeOrderEo2.getInLogicWarehouseCode()) ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
                detailParam.setLogicWarehouseCode(warehouseCode);
                detailParam.setBatch(detailReqDto.getBatch());
                detailParam.setExpireDate(detailReqDto.getExpireTime());
                detailParam.setProduceDate(detailReqDto.getProduceTime());
                detailParams.add(detailParam);
            }
        }
        param.setDetails((List)detailParams);
        if (CollectionUtils.isNotEmpty((Collection)detailParams)) {
            this.calcInventoryService.formIn(param);
        }
    }

    @Override
    public void outInventoryDeal(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2, boolean inFlag, Integer isAllDeal) {
        if (!inFlag) {
            this.releasePreemptOnlyLogic(csInOutMatchRespDto, InOutNoticeOrderEo2, isAllDeal);
            this.balanceOut(csInOutMatchRespDto, InOutNoticeOrderEo2);
        }
    }

    private void releasePreemptOnlyLogic(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2, Integer isAllDeal) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(InOutNoticeOrderEo2.getRelevanceNo());
        releasePreemptParam.setSourceType(InOutNoticeOrderEo2.getBusinessType());
        if (StringUtils.contains((CharSequence)releasePreemptParam.getSourceNo(), (CharSequence)"DD")) {
            releasePreemptParam.setSourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_RELEASE.getCode());
        }
        releasePreemptParam.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        releasePreemptParam.setExternalOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        releasePreemptParam.setIsSaleOrder(Boolean.valueOf(StringUtils.equals((CharSequence)InOutNoticeOrderEo2.getRelevanceTableName(), (CharSequence)CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode())));
        this.calcInventoryService.releasePreempt(releasePreemptParam);
    }

    private void balanceOut(CsInOutMatchRespDto csInOutMatchRespDto, InOutNoticeOrderEo InOutNoticeOrderEo2) {
        logger.info("======>\u6267\u884c\u51fa\u5e93\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)csInOutMatchRespDto));
        List detailReqDtoList = csInOutMatchRespDto.getDetailReqDtoList();
        this.actualOut(detailReqDtoList, InOutNoticeOrderEo2);
    }

    private void actualOut(List<CsWmsBasicsDetailReqDto> detailReqDtoList, InOutNoticeOrderEo InOutNoticeOrderEo2) {
        ArrayList detailParams = Lists.newArrayList();
        for (CsWmsBasicsDetailReqDto detailReqDto : detailReqDtoList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal balance = BigDecimalUtils.abs((BigDecimal)detailReqDto.getQuantity());
            detailParam.setNum(balance);
            if (BigDecimalUtils.eqZero((BigDecimal)balance).booleanValue()) continue;
            detailParam.setSkuCode(detailReqDto.getSkuCode());
            String warehouseCode = StringUtils.isNotBlank((CharSequence)InOutNoticeOrderEo2.getInLogicWarehouseCode()) ? InOutNoticeOrderEo2.getInLogicWarehouseCode() : InOutNoticeOrderEo2.getOutLogicWarehouseCode();
            detailParam.setLogicWarehouseCode(warehouseCode);
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParam.setLineNo(detailReqDto.getLineNo());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            detailParams.add(detailParam);
        }
        FormOutDto outParam = new FormOutDto();
        outParam.setSourceNo(InOutNoticeOrderEo2.getRelevanceNo());
        outParam.setSourceType(InOutNoticeOrderEo2.getBusinessType());
        if (StringUtils.contains((CharSequence)outParam.getSourceNo(), (CharSequence)"DD")) {
            outParam.setSourceType(CsInventorySourceTypeEnum.OUT_SALE.getCode());
        }
        outParam.setBusinessType(InOutNoticeOrderEo2.getBusinessType());
        outParam.setExternalOrderNo(InOutNoticeOrderEo2.getExternalOrderNo());
        outParam.setDetails((List)detailParams);
        if (CollectionUtils.isNotEmpty((Collection)detailParams)) {
            this.calcInventoryService.formOut(outParam);
        }
    }

    @Override
    public void generateReceiveResultOrderInfo(CsBasicsReceiveReqDto basicsReceiveBasicsReqDto, ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo, List<ReceiveDeliveryNoticeOrderDetailEo> deliveryNoticeOrderDetailEoList, InOutResultOrderEo InOutResultOrderEo2, Boolean inFlag) {
        Map<String, List<ReceiveDeliveryNoticeOrderDetailEo>> receiveNoticeOrderDetailMap = deliveryNoticeOrderDetailEoList.stream().collect(Collectors.groupingBy(ReceiveDeliveryNoticeOrderDetailEo::getSkuCode));
        List detailReqDtoList = basicsReceiveBasicsReqDto.getDetailReqDtoList();
        BigDecimal totalQuantity = detailReqDtoList.stream().map(CsWmsBasicsDetailReqDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        ReceiveDeliveryResultOrderContext resultOrderContext = new ReceiveDeliveryResultOrderContext();
        CubeBeanUtils.copyProperties((Object)resultOrderContext, (Object)receiveDeliveryNoticeOrderEo, (String[])new String[0]);
        CubeBeanUtils.copyProperties((Object)resultOrderContext, (Object)basicsReceiveBasicsReqDto, (String[])new String[0]);
        resultOrderContext.setShippingInfoReqDtoList(basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
        resultOrderContext.setRelevanceNo(InOutResultOrderEo2.getRelevanceNo());
        resultOrderContext.setPreOrderNo(InOutResultOrderEo2.getDocumentNo());
        resultOrderContext.setExternalOrderNo(InOutResultOrderEo2.getExternalOrderNo());
        resultOrderContext.setTotalQuantity(totalQuantity);
        resultOrderContext.setOrderStatus(BaseOrderStatusEnum.RRO_RECEIVED);
        resultOrderContext.setLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseCode());
        resultOrderContext.setLogicWarehouseName(receiveDeliveryNoticeOrderEo.getReceiveLogicWarehouseName());
        resultOrderContext.setPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode());
        resultOrderContext.setPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseName());
        if (!inFlag.booleanValue()) {
            resultOrderContext.setOrderStatus(BaseOrderStatusEnum.DRO_DELIVERED);
            resultOrderContext.setLogicWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseCode());
            resultOrderContext.setLogicWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryLogicWarehouseName());
            resultOrderContext.setPhysicsWarehouseCode(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseCode());
            resultOrderContext.setPhysicsWarehouseName(receiveDeliveryNoticeOrderEo.getDeliveryPhysicsWarehouseName());
        }
        ArrayList orderDetailReqDtoList = Lists.newArrayList();
        for (CsWmsBasicsDetailReqDto detailReqDto : detailReqDtoList) {
            BaseOrderDetailReqDto csBasicsOrderDetailReqDto = new BaseOrderDetailReqDto();
            CubeBeanUtils.copyProperties((Object)csBasicsOrderDetailReqDto, (Object)detailReqDto, (String[])new String[0]);
            String skuCode = detailReqDto.getSkuCode();
            List<ReceiveDeliveryNoticeOrderDetailEo> tempEoList = receiveNoticeOrderDetailMap.get(skuCode);
            if (CollectionUtils.isNotEmpty(tempEoList)) {
                ReceiveDeliveryNoticeOrderDetailEo csReceiveNoticeOrderDetailEo = tempEoList.get(0);
                csBasicsOrderDetailReqDto.setSkuCode(csReceiveNoticeOrderDetailEo.getSkuCode());
                csBasicsOrderDetailReqDto.setSkuName(csReceiveNoticeOrderDetailEo.getSkuName());
                csBasicsOrderDetailReqDto.setExtension(tempEoList.stream().filter(r -> Objects.equals(detailReqDto.getBatch(), r.getBatch())).findAny().orElse(csReceiveNoticeOrderDetailEo).getExtension());
            }
            orderDetailReqDtoList.add(csBasicsOrderDetailReqDto);
        }
        resultOrderContext.setOrderBasicsDetailReqDtoList((List)orderDetailReqDtoList);
        if (!inFlag.booleanValue()) {
            this.baseOrderFacade.receiveResultOrderGen(resultOrderContext);
        } else {
            this.baseOrderFacade.deliveryResultOrderGen(resultOrderContext);
        }
    }

    @Override
    public void updateNoticeOrderInfo(List<CsInOutResultDetailRespDto> inOutResultDetailRespDtoList, List<InOutNoticeOrderDetailEo> InOutNoticeOrderDetailEoList, List<ReceiveDeliveryNoticeOrderDetailEo> deliveryNoticeOrderDetailEoList) {
        HashMap<String, InOutNoticeOrderDetailEo> batchCargoMap = new HashMap<String, InOutNoticeOrderDetailEo>();
        for (InOutNoticeOrderDetailEo inOutNoticeOrderDetailEo : InOutNoticeOrderDetailEoList) {
            String noticeKey2 = inOutNoticeOrderDetailEo.getSkuCode() + "_" + inOutNoticeOrderDetailEo.getBatch();
            batchCargoMap.putIfAbsent(noticeKey2, inOutNoticeOrderDetailEo);
        }
        ArrayList<InOutNoticeOrderDetailEo> noticeOrderDetailEoList = new ArrayList<InOutNoticeOrderDetailEo>();
        block1: for (CsInOutResultDetailRespDto csInOutResultDetailRespDto : inOutResultDetailRespDtoList) {
            BigDecimal alreadyQuantity = csInOutResultDetailRespDto.getDoneQuantity();
            String key1 = csInOutResultDetailRespDto.getSkuCode();
            String key2 = csInOutResultDetailRespDto.getSkuCode() + "_" + csInOutResultDetailRespDto.getBatch();
            InOutNoticeOrderDetailEo noticeOrderDetailEo = (InOutNoticeOrderDetailEo)batchCargoMap.get(key2);
            if (null != noticeOrderDetailEo) {
                noticeOrderDetailEo.setWaitQuantity(noticeOrderDetailEo.getWaitQuantity().subtract(alreadyQuantity));
                noticeOrderDetailEo.setDoneQuantity(noticeOrderDetailEo.getDoneQuantity().add(alreadyQuantity));
                noticeOrderDetailEoList.add(noticeOrderDetailEo);
                continue;
            }
            for (InOutNoticeOrderDetailEo InOutNoticeOrderDetailEo3 : InOutNoticeOrderDetailEoList) {
                BigDecimal waitQuantity;
                String noticeKey1 = InOutNoticeOrderDetailEo3.getSkuCode();
                if (!key1.equals(noticeKey1) || BigDecimal.ZERO.compareTo(waitQuantity = InOutNoticeOrderDetailEo3.getWaitQuantity()) > 0 && StringUtils.isNotBlank((CharSequence)InOutNoticeOrderDetailEo3.getBatch())) continue;
                InOutNoticeOrderDetailEo3.setWaitQuantity(waitQuantity.subtract(alreadyQuantity));
                InOutNoticeOrderDetailEo3.setDoneQuantity(InOutNoticeOrderDetailEo3.getDoneQuantity().add(alreadyQuantity));
                noticeOrderDetailEoList.add(InOutNoticeOrderDetailEo3);
                continue block1;
            }
        }
        HashMap<String, InOutNoticeOrderDetailEo> hashMap = new HashMap<String, InOutNoticeOrderDetailEo>();
        for (InOutNoticeOrderDetailEo InOutNoticeOrderDetailEo4 : noticeOrderDetailEoList) {
            this.inOutNoticeOrderDetailDomain.getMapper().updateById((BaseEo)InOutNoticeOrderDetailEo4);
            hashMap.put(InOutNoticeOrderDetailEo4.getSkuCode() + "_" + InOutNoticeOrderDetailEo4.getBatch(), InOutNoticeOrderDetailEo4);
        }
        for (ReceiveDeliveryNoticeOrderDetailEo ReceiveDeliveryNoticeOrderDetailEo2 : deliveryNoticeOrderDetailEoList) {
            String noticeKey = ReceiveDeliveryNoticeOrderDetailEo2.getSkuCode() + "_" + ReceiveDeliveryNoticeOrderDetailEo2.getBatch();
            InOutNoticeOrderDetailEo InOutNoticeOrderDetailEo5 = (InOutNoticeOrderDetailEo)hashMap.get(noticeKey);
            if (null == InOutNoticeOrderDetailEo5) continue;
            ReceiveDeliveryNoticeOrderDetailEo2.setWaitQuantity(InOutNoticeOrderDetailEo5.getWaitQuantity());
            ReceiveDeliveryNoticeOrderDetailEo2.setDoneQuantity(InOutNoticeOrderDetailEo5.getDoneQuantity());
            this.receiveDeliveryNoticeOrderDetailDomain.getMapper().updateById((BaseEo)ReceiveDeliveryNoticeOrderDetailEo2);
        }
    }

    @Override
    public void updateNoticeStatus(InOutNoticeOrderEo InOutNoticeOrderEo2, ReceiveDeliveryNoticeOrderEo ReceiveDeliveryNoticeOrderEo2, List<InOutNoticeOrderDetailEo> InOutNoticeOrderDetailEoList, CsOrderBusinessCallBackContext callBackContext) {
        String outInOrderStatus;
        BigDecimal totalQuantity = InOutNoticeOrderDetailEoList.stream().map(InOutNoticeOrderDetailEo::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        String deliveryOrderStatus = "delivery".equals(ReceiveDeliveryNoticeOrderEo2.getOrderType()) ? BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode() : BaseOrderStatusEnum.RNO_TOTAL_RECEIVE.getCode();
        String string = outInOrderStatus = "out".equals(InOutNoticeOrderEo2.getOrderType()) ? BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode() : BaseOrderStatusEnum.INO_TOTAL_IN.getCode();
        if (InOutNoticeOrderEo2.getTotalQuantity().compareTo(totalQuantity) > 0) {
            callBackContext.setPortionFlag(Boolean.valueOf(true));
            deliveryOrderStatus = "delivery".equals(ReceiveDeliveryNoticeOrderEo2.getOrderType()) ? BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode() : BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode();
            outInOrderStatus = "out".equals(InOutNoticeOrderEo2.getOrderType()) ? BaseOrderStatusEnum.ONO_PORTION_OUT.getCode() : BaseOrderStatusEnum.INO_PORTION_IN.getCode();
        }
        InOutNoticeOrderEo2.setOrderStatus(outInOrderStatus);
        ReceiveDeliveryNoticeOrderEo2.setOrderStatus(deliveryOrderStatus);
        this.receiveDeliveryNoticeOrderDomain.getMapper().updateById((BaseEo)ReceiveDeliveryNoticeOrderEo2);
        this.inOutNoticeOrderDomain.getMapper().updateById((BaseEo)InOutNoticeOrderEo2);
    }

    @Override
    public void updateResultStatus(boolean inFlag, InOutResultOrderEo InOutResultOrderEo2, String remark) {
        String orderStatus = inFlag ? BaseOrderStatusEnum.IRO_DONE_IN.getCode() : BaseOrderStatusEnum.ORO_DONE_OUT.getCode();
        InOutResultOrderEo2.setOrderStatus(orderStatus);
        InOutResultOrderEo2.setRemark(remark);
        InOutResultOrderEo2.setUnOverChargeTime(new Date());
        this.inOutResultOrderDomain.getMapper().updateById((BaseEo)InOutResultOrderEo2);
    }

    @Override
    public void updateMainOrderStatus(String relevanceNo, boolean inFlag) {
    }

    @Override
    public void pushResultOrder(CsOrderBusinessCallBackContext callBackContext) {
    }

    @Override
    public void beforeNotice(BaseOrderBaseContext context) {
    }
}

