/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.utils;

import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DistributedMutexHandler {
    private static final Logger log = LoggerFactory.getLogger(DistributedMutexHandler.class);
    private static int waitTime = 30;
    private static int releaseTime = 35;
    @Autowired
    private ILockService lockService;

    public Map<String, Mutex> addMutexMaps(String tableName, List<String> mutexKeys) {
        return this.addMutexMaps(Maps.newHashMap(), tableName, mutexKeys);
    }

    public Map<String, Mutex> addMutexMaps(Map<String, Mutex> mutexMap, String tableName, List<String> mutexKeys) {
        long start = System.currentTimeMillis();
        log.info("\u52a0\u9501\u524d: {}", mutexMap);
        if (null == mutexMap) {
            mutexMap = Maps.newHashMap();
        }
        for (String mutexKey : mutexKeys) {
            if (!StringUtils.isNotBlank((CharSequence)mutexKey) || mutexMap.containsKey(mutexKey)) continue;
            mutexMap.put(mutexKey, this.lockService.lock(tableName, mutexKey, waitTime, releaseTime, TimeUnit.SECONDS));
        }
        log.info("\u52a0\u9501\u540e: {}", (Object)mutexMap);
        log.info("DistributedMutexHandler ==> addMutexMaps exec time: {}", (Object)LogUtils.getExecuteTime(start));
        return mutexMap;
    }

    public void unlockMutexMap(Map<String, Mutex> mutexMap) {
        if (MapUtils.isEmpty(mutexMap)) {
            return;
        }
        for (Map.Entry<String, Mutex> entry : mutexMap.entrySet()) {
            this.lockService.unlock(entry.getValue());
        }
    }

    public static enum MutexTable {
        CS_DELIVERY_NOTICE_ORDER("CS_DELIVERY_NOTICE_ORDER", "\u53d1\u8d27\u901a\u77e5\u5355"),
        CS_INVENTORY_OPERATE("CS_INVENTORY_OPERATE", "\u5e93\u5b58\u64cd\u4f5c"),
        CS_INVENTORY_CHECK("CS_INVENTORY_CHECK", "\u5e93\u5b58\u68c0\u67e5");

        String tableName;
        String desc;

        private MutexTable(String tableName, String desc) {
            this.tableName = tableName;
            this.desc = desc;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

