/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressQueryService;
import com.dtyunxi.yundt.cube.center.inventory.biz.service.cs.warehouse.ICsWarehouseAddressService;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.AssertUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.LogUtils;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressUpdateReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="csWarehouseAddressService")
public class CsWarehouseAddressServiceImpl
implements ICsWarehouseAddressService {
    private static Logger logger = LoggerFactory.getLogger(CsWarehouseAddressServiceImpl.class);
    @Autowired
    IWarehouseAddressDomain warehouseAddressDomain;
    @Autowired
    private ICsWarehouseAddressQueryService csWarehouseAddressQueryService;

    @Override
    public Long add(CsWarehouseAddressAddReqDto addReqDto) {
        logger.info("\u6dfb\u52a0\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(addReqDto));
        AssertUtil.isTrue(addReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        WarehouseAddressEo insertEo = new WarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)insertEo, (Object)addReqDto, (String[])new String[0]);
        this.warehouseAddressDomain.insert((BaseEo)insertEo);
        return insertEo.getId();
    }

    @Override
    public void update(Long id, CsWarehouseAddressUpdateReqDto updateReqDto) {
        logger.info("\u4fee\u6539\u53c2\u6570\uff1a[id:{}, {}]", (Object)id, (Object)LogUtils.buildLogContent(updateReqDto));
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(updateReqDto != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        WarehouseAddressEo updateEo = new WarehouseAddressEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)updateReqDto, (String[])new String[0]);
        updateEo.setId(id);
        this.warehouseAddressDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void delete(Long id) {
        logger.info("\u5220\u9664\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtil.isTrue(id != null && id > 0L, "id\u53c2\u6570\u6709\u8bef");
        WarehouseAddressEo eo = this.csWarehouseAddressQueryService.selectByPrimaryKey(id);
        AssertUtil.isTrue(eo != null, "\u8bb0\u5f55\u4e0d\u5b58\u5728");
        this.warehouseAddressDomain.getMapper().deleteLogicById(id);
    }

    @Override
    public void batchAdd(List<CsWarehouseAddressAddReqDto> addReqDtoList) {
        AssertUtil.isTrue(CollectionUtil.isNotEmpty(addReqDtoList), "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList insertEoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)insertEoList, addReqDtoList, WarehouseAddressEo.class);
        this.warehouseAddressDomain.insertBatch((List)insertEoList);
    }

    @Override
    public void updateByWarehouseId(WarehouseAddressEo warehouseAddressEo) {
        AssertUtil.isTrue(warehouseAddressEo != null, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList sqlFilterList = Lists.newArrayList();
        sqlFilterList.add(SqlFilter.eq((String)"warehouse_id", (Object)warehouseAddressEo.getWarehouseId()));
        warehouseAddressEo.setSqlFilters((List)sqlFilterList);
        this.warehouseAddressDomain.updateSelectiveSqlFilter((BaseEo)warehouseAddressEo);
    }
}

