/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.biz.utils;

import com.dtyunxi.cube.utils.ReflectUtil;
import com.dtyunxi.dto.BasePageDto;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.inventory.biz.utils.FetchProperties;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@FunctionalInterface
public interface FetchDataProcessService<REQ, RESP> {
    public static final String PAGE_SIZE = "pageSize";
    public static final String PAGE_NUM = "pageNum";

    public PageInfo<RESP> fetch(REQ var1);

    default public void processAll(REQ req, DataProcess<RESP> dataProcess) {
        FetchProperties properties = (FetchProperties)SpringBeanUtil.getBean(FetchProperties.class);
        this.setPageNum(1, req);
        this.setPageSize(properties.getLimitProcessPageSize(), req);
        PageInfo<RESP> fetch = this.fetch(req);
        int total = Math.toIntExact(Optional.ofNullable(fetch).map(PageSerializable::getTotal).orElse(0L));
        ArrayList resp = new ArrayList(total);
        if (total <= properties.getLimitProcessPageSize()) {
            dataProcess.process(fetch.getList());
            return;
        }
        dataProcess.process(fetch.getList());
        Stream.iterate(2, n -> n + 1).limit(total / properties.getLimitProcessPageSize() + (total % properties.getLimitProcessPageSize() != 0 ? 1 : 0) - 1).forEach(n -> {
            this.setPageNum((int)n, req);
            dataProcess.process(this.fetch(req).getList());
        });
    }

    default public <REQ> void setPageNum(int i, REQ req) {
        if (req instanceof BasePageDto) {
            ((BasePageDto)req).setPageNum(Integer.valueOf(i));
        } else {
            this.reflectSetVal(i, req, PAGE_NUM);
        }
    }

    default public <REQ> void reflectSetVal(int i, REQ req, String pageNum) {
        this.getFirst(req, pageNum).ifPresent(field -> {
            field.setAccessible(true);
            try {
                field.set(req, i);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        });
    }

    default public <REQ> Optional<Field> getFirst(REQ req, String fieldName) {
        return ReflectUtil.getAllFields(req.getClass()).stream().filter(field -> field.getName().equals(fieldName)).findFirst();
    }

    default public <REQ> void setPageSize(int i, REQ req) {
        if (req instanceof BasePageDto) {
            ((BasePageDto)req).setPageSize(Integer.valueOf(i));
        } else {
            this.reflectSetVal(i, req, PAGE_SIZE);
        }
    }

    public static interface DataProcess<RESP> {
        public void process(List<RESP> var1);
    }
}

